/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmImporter
extends FileImporter {
    public OsmImporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files") + " (*.osm *.xml)"));
    }

    public OsmImporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.importData(fileInputStream, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()));
        }
    }

    protected void importData(InputStream inputStream, File file) throws IllegalDataException {
        DataSet dataSet = OsmReader.parseDataSet(inputStream, NullProgressMonitor.INSTANCE);
        final OsmDataLayer osmDataLayer = new OsmDataLayer(dataSet, file.getName(), file);
        Runnable runnable = new Runnable(){

            public void run() {
                Main.main.addLayer(osmDataLayer);
                osmDataLayer.onPostLoadFromFile();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

