/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM_France_DOM
implements Projection,
ProjectionSubPrefs {
    private static String FortMarigotName = I18n.tr("Guadeloupe Fort-Marigot 1949");
    private static String SainteAnneName = I18n.tr("Guadeloupe Ste-Anne 1948");
    private static String MartiniqueName = I18n.tr("Martinique Fort Desaix 1952");
    private static String Reunion92Name = I18n.tr("Reunion RGR92");
    private static String Guyane92Name = I18n.tr("Guyane RGFG95");
    public static String[] utmGeodesicsNames = new String[]{FortMarigotName, SainteAnneName, MartiniqueName, Reunion92Name, Guyane92Name};
    private Bounds FortMarigotBounds = new Bounds(new LatLon(17.6, -63.25), new LatLon(18.5, -62.5));
    private Bounds SainteAnneBounds = new Bounds(new LatLon(15.8, -61.9), new LatLon(16.6, -60.9));
    private Bounds MartiniqueBounds = new Bounds(new LatLon(14.25, -61.25), new LatLon(15.025, -60.725));
    private Bounds ReunionBounds = new Bounds(new LatLon(-25.92, 37.58), new LatLon(-10.6, 58.27));
    private Bounds GuyaneBounds = new Bounds(new LatLon(2.16, -54.0), new LatLon(9.06, -49.62));
    private Bounds[] utmBounds = new Bounds[]{this.FortMarigotBounds, this.SainteAnneBounds, this.MartiniqueBounds, this.ReunionBounds, this.GuyaneBounds};
    private String FortMarigotEPSG = "EPSG::2969";
    private String SainteAnneEPSG = "EPSG::2970";
    private String MartiniqueEPSG = "EPSG::2973";
    private String ReunionEPSG = "EPSG::2975";
    private String GuyaneEPSG = "EPSG::2972";
    private String[] utmEPSGs = new String[]{this.FortMarigotEPSG, this.SainteAnneEPSG, this.MartiniqueEPSG, this.ReunionEPSG, this.GuyaneEPSG};
    private static final double Xs = 500000.0;
    private static double Ys = 0.0;
    protected double lg0;
    private static int zone;
    private boolean isNorth;
    public static final int DEFAULT_GEODESIC = 0;
    public static int currentGeodesic;
    private static double tx;
    private static double ty;
    private static double tz;
    private static double rx;
    private static double ry;
    private static double rz;
    private static double scaleDiff;
    public static final double epsilon = 1.0E-11;

    private void refresh7ParametersTranslation() {
        if (currentGeodesic == 0) {
            this.set7ParametersTranslation(new double[]{136.596, 248.148, -429.789}, new double[]{0.0, 0.0, 0.0}, 0.0, true, 20);
        } else if (currentGeodesic == 1) {
            this.set7ParametersTranslation(new double[]{-472.29, -5.63, -304.12}, new double[]{0.4362, -0.8374, 0.2563}, 1.8984E-6, true, 20);
        } else if (currentGeodesic == 2) {
            this.set7ParametersTranslation(new double[]{126.926, 547.939, 130.409}, new double[]{-2.7867, 5.16124, -0.85844}, 1.382265E-5, true, 20);
        } else if (currentGeodesic == 3) {
            this.set7ParametersTranslation(new double[]{789.524, -626.486, -89.904}, new double[]{0.6006, 76.7946, -10.5788}, -3.23241E-5, false, 40);
        } else if (currentGeodesic == 4) {
            this.set7ParametersTranslation(new double[]{-193.066, 236.993, 105.447}, new double[]{0.4814, -0.8074, 0.1276}, 1.5649E-6, true, 22);
        }
    }

    private void set7ParametersTranslation(double[] dArray, double[] dArray2, double d, boolean bl, int n) {
        tx = dArray[0];
        ty = dArray[1];
        tz = dArray[2];
        rx = dArray2[0] / 206264.80624709636;
        ry = dArray2[1] / 206264.80624709636;
        rz = dArray2[2] / 206264.80624709636;
        scaleDiff = d;
        this.isNorth = bl;
        Ys = this.isNorth ? 0.0 : 1.0E7;
        zone = n;
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        if (currentGeodesic < 3) {
            LatLon latLon2 = this.GRS802Hayford(latLon);
            return this.MTProjection(latLon2, Ellipsoid.hayford.a, Ellipsoid.hayford.e);
        }
        LatLon latLon3 = new LatLon(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()));
        return this.MTProjection(latLon3, Ellipsoid.GRS80.a, Ellipsoid.GRS80.e);
    }

    private LatLon GRS802Hayford(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        double d3 = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(d);
        double[] dArray = this.invSevenParametersTransformation(d4, d5, d6);
        return this.Geographic(dArray[0], dArray[1], dArray[2], Ellipsoid.hayford);
    }

    private LatLon Geographic(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    private EastNorth MTProjection(LatLon latLon, double d, double d2) {
        double d3 = 0.9996 * d;
        Ys = latLon.lat() >= 0.0 ? 0.0 : 1.0E7;
        double d4 = 0.10471975511965977;
        this.lg0 = d4 * ((double)zone - 0.5) - Math.PI;
        double d5 = d2 * d2;
        double d6 = d5 * d5;
        double d7 = d6 * d5;
        double d8 = d6 * d6;
        double[] dArray = new double[]{1.0 - d5 / 4.0 - 3.0 * d6 / 64.0 - 5.0 * d7 / 256.0 - 175.0 * d8 / 16384.0, d5 / 8.0 - d6 / 96.0 - 9.0 * d7 / 1024.0 - 901.0 * d8 / 184320.0, 13.0 * d6 / 768.0 + 17.0 * d7 / 5120.0 - 311.0 * d8 / 737280.0, 61.0 * d7 / 15360.0 + 899.0 * d8 / 430080.0, 49561.0 * d8 / 4.128768E7};
        double d9 = d2 * Math.sin(latLon.lat());
        double d10 = Math.log(Math.tan(0.7853981633974483 + latLon.lat() / 2.0) * Math.pow((1.0 - d9) / (1.0 + d9), d2 / 2.0));
        double d11 = Math.asin(Math.sin(latLon.lon() - this.lg0) / ((Math.exp(d10) + Math.exp(-d10)) / 2.0));
        double d12 = Math.log(Math.tan(0.7853981633974483 + d11 / 2.0));
        double d13 = Math.atan((Math.exp(d10) - Math.exp(-d10)) / 2.0 / Math.cos(latLon.lon() - this.lg0));
        double d14 = dArray[0] * d13;
        double d15 = dArray[0] * d12;
        for (int i = 1; i < 5; ++i) {
            double d16 = 2.0 * (double)i * d13;
            double d17 = 2.0 * (double)i * d12;
            double d18 = Math.exp(d17);
            double d19 = Math.exp(-d17);
            double d20 = Math.sin(d16) / 2.0 * (d18 + d19);
            double d21 = Math.cos(d16) / 2.0 * (d18 - d19);
            d14 += dArray[i] * d20;
            d15 += dArray[i] * d21;
        }
        d15 *= d3;
        d14 *= d3;
        return new EastNorth(d15 += 500000.0, d14 += Ys);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        if (currentGeodesic < 3) {
            this.MTProjection(eastNorth.east(), eastNorth.north(), zone, this.isNorth);
            LatLon latLon = this.Geographic(eastNorth, Ellipsoid.hayford.a, Ellipsoid.hayford.e, 0.0);
            double d = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(latLon.lat()) * Math.sin(latLon.lat()));
            double d2 = d * Math.cos(latLon.lat()) * Math.cos(latLon.lon());
            double d3 = d * Math.cos(latLon.lat()) * Math.sin(latLon.lon());
            double d4 = d * (1.0 - Ellipsoid.hayford.e2) * Math.sin(latLon.lat());
            double[] dArray = this.sevenParametersTransformation(d2, d3, d4);
            LatLon latLon2 = this.cart2LatLon(dArray[0], dArray[1], dArray[2], Ellipsoid.GRS80);
            return new LatLon(Math.toDegrees(latLon2.lat()), Math.toDegrees(latLon2.lon()));
        }
        LatLon latLon = this.Geographic(eastNorth, Ellipsoid.GRS80.a, Ellipsoid.GRS80.e, 0.0);
        double d = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(latLon.lat()) * Math.sin(latLon.lat()));
        double d5 = d * Math.cos(latLon.lat()) * Math.cos(latLon.lon());
        double d6 = d * Math.cos(latLon.lat()) * Math.sin(latLon.lon());
        double d7 = d * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(latLon.lat());
        LatLon latLon3 = this.cart2LatLon(d5, d6, d7, Ellipsoid.GRS80);
        return new LatLon(Math.toDegrees(latLon3.lat()), Math.toDegrees(latLon3.lon()));
    }

    private void MTProjection(double d, double d2, int n, boolean bl) {
        Ys = bl ? 0.0 : 1.0E7;
        double d3 = 0.10471975511965977;
        this.lg0 = d3 * ((double)n - 0.5) - Math.PI;
    }

    public double scaleFactor() {
        return 0.15915494309189535;
    }

    private LatLon Geographic(EastNorth eastNorth, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = 0.9996 * d;
        double d7 = d2 * d2;
        double d8 = d7 * d7;
        double d9 = d8 * d7;
        double d10 = d8 * d8;
        double[] dArray = new double[]{1.0 - d7 / 4.0 - 3.0 * d8 / 64.0 - 5.0 * d9 / 256.0 - 175.0 * d10 / 16384.0, d7 / 8.0 + d8 / 48.0 + 7.0 * d9 / 2048.0 + d10 / 61440.0, d8 / 768.0 + 3.0 * d9 / 1280.0 + 559.0 * d10 / 368640.0, 17.0 * d9 / 30720.0 + 283.0 * d10 / 430080.0, 4397.0 * d10 / 4.128768E7};
        double d11 = (eastNorth.north() - Ys) / (d6 * dArray[0]);
        double d12 = (eastNorth.east() - 500000.0) / (d6 * dArray[0]);
        double d13 = d11;
        double d14 = d12;
        for (int i = 1; i < 5; ++i) {
            double d15 = 2.0 * (double)i * d13;
            double d16 = 2.0 * (double)i * d14;
            double d17 = Math.exp(d16);
            double d18 = Math.exp(-d16);
            double d19 = Math.sin(d15) / 2.0 * (d17 + d18);
            double d20 = Math.cos(d15) / 2.0 * (d17 - d18);
            d11 -= dArray[i] * d19;
            d12 -= dArray[i] * d20;
        }
        double d21 = this.lg0 + Math.atan((Math.exp(d12) - Math.exp(-d12)) / 2.0 / Math.cos(d11));
        double d22 = Math.asin(Math.sin(d11) / ((Math.exp(d12) + Math.exp(-d12)) / 2.0));
        d11 = Math.log(Math.tan(0.7853981633974483 + d22 / 2.0));
        double d23 = 2.0 * Math.atan(Math.exp(d11)) - 1.5707963267948966;
        do {
            d4 = d23;
        } while (Math.abs((d23 = 2.0 * Math.atan(Math.pow((1.0 + (d5 = d2 * Math.sin(d23))) / (1.0 - d5), d2 / 2.0) * Math.exp(d11)) - 1.5707963267948966) - d4) >= 1.0E-11);
        return new LatLon(d23, d21);
    }

    private LatLon cart2LatLon(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double[] dArray = new double[]{d, d2, d3};
        LatLon latLon = ellipsoid.cart2LatLon(dArray, 1.0E-11);
        return new LatLon(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()));
    }

    private double[] sevenParametersTransformation(double d, double d2, double d3) {
        double d4 = tx + d * (1.0 + scaleDiff) + d3 * ry - d2 * rz;
        double d5 = ty + d2 * (1.0 + scaleDiff) + d * rz - d3 * rx;
        double d6 = tz + d3 * (1.0 + scaleDiff) + d2 * rx - d * ry;
        return new double[]{d4, d5, d6};
    }

    private double[] invSevenParametersTransformation(double d, double d2, double d3) {
        double d4 = (1.0 - scaleDiff) * (-tx + d + ((-tz + d3) * -ry - (-ty + d2) * -rz));
        double d5 = (1.0 - scaleDiff) * (-ty + d2 + ((-tx + d) * -rz - (-tz + d3) * -rx));
        double d6 = (1.0 - scaleDiff) * (-tz + d3 + ((-ty + d2) * -rx - (-tx + d) * -ry));
        return new double[]{d4, d5, d6};
    }

    @Override
    public String getCacheDirectoryName() {
        return this.toString();
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return this.utmBounds[currentGeodesic];
    }

    @Override
    public String toCode() {
        return this.utmEPSGs[currentGeodesic];
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + currentGeodesic;
    }

    @Override
    public String toString() {
        return I18n.tr("UTM France (DOM)");
    }

    public int getCurrentGeodesic() {
        return currentGeodesic;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(utmGeodesicsNames);
        jComboBox.setSelectedIndex(currentGeodesic);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("UTM Geodesic system")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        currentGeodesic = ((JComboBox)component).getSelectedIndex();
        this.refresh7ParametersTranslation();
        return Collections.singleton(Integer.toString(currentGeodesic + 1));
    }

    @Override
    public String[] allCodes() {
        return this.utmEPSGs;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (int i = 0; i < this.utmEPSGs.length; ++i) {
            if (!this.utmEPSGs[i].endsWith(string)) continue;
            return Collections.singleton(Integer.toString(i + 1));
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        currentGeodesic = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((currentGeodesic = Integer.parseInt(string = iterator.next()) - 1) < 0 || currentGeodesic >= this.utmEPSGs.length)) {
                    currentGeodesic = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.refresh7ParametersTranslation();
    }

    static {
        currentGeodesic = 0;
        tx = 0.0;
        ty = 0.0;
        tz = 0.0;
        rx = 0.0;
        ry = 0.0;
        rz = 0.0;
        scaleDiff = 0.0;
    }
}

