/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeAction
extends JosmAction {
    protected OsmDataLayer layer;
    JCheckBox cbClearUndoRedo;
    protected Set<OsmPrimitive> toPurge;
    protected Set<OsmPrimitive> toPurgeChecked;
    protected Set<OsmPrimitive> makeIncomplete;
    protected List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge..."), "purge", I18n.tr("Forget objects but do not delete them on server when uploading."), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge")), 80, 2, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashSet<OsmPrimitive> hashSet;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = PurgeAction.getCurrentDataSet().getSelected();
        this.layer = Main.map.mapView.getEditLayer();
        this.toPurge = new HashSet<OsmPrimitive>(collection);
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        this.toPurgeChecked = new HashSet<OsmPrimitive>();
        while (!this.toPurge.isEmpty()) {
            hashSet = this.toPurge.iterator().next();
            for (OsmPrimitive osmPrimitive : ((OsmPrimitive)((Object)hashSet)).getReferrers()) {
                if (this.toPurge.contains(osmPrimitive) || this.toPurgeChecked.contains(osmPrimitive) || !(osmPrimitive instanceof Way) && (!(osmPrimitive instanceof Relation) || !((OsmPrimitive)((Object)hashSet)).isNew())) continue;
                this.toPurgeAdditionally.add(osmPrimitive);
                this.toPurge.add(osmPrimitive);
            }
            this.toPurge.remove(hashSet);
            this.toPurgeChecked.add((OsmPrimitive)((Object)hashSet));
        }
        this.makeIncomplete = new HashSet<OsmPrimitive>();
        block2: for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
            if (osmPrimitive.isNew()) continue;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || this.toPurgeChecked.contains(osmPrimitive2)) continue;
                this.makeIncomplete.add(osmPrimitive);
                continue block2;
            }
        }
        if (Main.pref.getBoolean("purge.add_untagged_waynodes", true)) {
            hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
                if (!(osmPrimitive instanceof Way)) continue;
                Way way = (Way)osmPrimitive;
                block5: for (Node node : way.getNodes()) {
                    if (node.isTagged() || this.toPurgeChecked.contains(node)) continue;
                    for (OsmPrimitive osmPrimitive3 : node.getReferrers()) {
                        if (osmPrimitive3 == way || this.toPurgeChecked.contains(osmPrimitive3)) continue;
                        continue block5;
                    }
                    hashSet.add(node);
                }
            }
            this.toPurgeChecked.addAll(hashSet);
            this.toPurgeAdditionally.addAll(hashSet);
        }
        if (Main.pref.getBoolean("purge.add_relations_with_only_incomplete_members", true)) {
            void var5_23;
            hashSet = new HashSet();
            for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
                for (OsmPrimitive osmPrimitive4 : osmPrimitive.getReferrers()) {
                    if (!(osmPrimitive4 instanceof Relation) || this.toPurgeChecked.contains(osmPrimitive4) || !this.hasOnlyIncompleteMembers((Relation)osmPrimitive4, this.toPurgeChecked, hashSet)) continue;
                    hashSet.add((Relation)osmPrimitive4);
                }
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(hashSet);
            boolean bl = false;
            while (var5_23 < arrayList.size()) {
                for (OsmPrimitive osmPrimitive : ((Relation)arrayList.get((int)var5_23)).getReferrers()) {
                    if (this.toPurgeChecked.contains(osmPrimitive) || !this.hasOnlyIncompleteMembers((Relation)osmPrimitive, this.toPurgeChecked, arrayList)) continue;
                    arrayList.add((Relation)osmPrimitive);
                }
                ++var5_23;
            }
            hashSet = new HashSet(arrayList);
            this.toPurgeChecked.addAll(hashSet);
            this.toPurgeAdditionally.addAll(hashSet);
        }
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
            if (!osmPrimitive.isModified()) continue;
            bl = true;
            break;
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Confirm Purging"), new String[]{I18n.tr("Purge"), I18n.tr("Cancel")});
        extendedDialog.setContent(this.buildPanel(bl), false);
        extendedDialog.setButtonIcons(new String[]{"ok", "cancel"});
        int n = extendedDialog.showDialog().getValue();
        if (n != 1) {
            return;
        }
        Main.pref.put("purge.clear_undo_redo", this.cbClearUndoRedo.isSelected());
        Main.main.undoRedo.add(new PurgeCommand(Main.map.mapView.getEditLayer(), this.toPurgeChecked, this.makeIncomplete));
        if (this.cbClearUndoRedo.isSelected()) {
            Main.main.undoRedo.clean();
            Main.map.selectionListDialog.clearSelectionHistory();
        }
    }

    private JPanel buildPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.") + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:") + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            Collections.sort(this.toPurgeAdditionally, new Comparator<OsmPrimitive>(){

                @Override
                public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                    int n = osmPrimitive.getType().compareTo(osmPrimitive2.getType());
                    if (n != 0) {
                        return -n;
                    }
                    return Long.valueOf(osmPrimitive.getUniqueId()).compareTo(osmPrimitive2.getUniqueId());
                }
            });
            JList<OsmPrimitive> jList = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[0]));
            jList.setCellRenderer(new OsmPrimitivRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent(jList, object, n, true, false);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setPreferredSize(new Dimension(250, 300));
            jScrollPane.setMinimumSize(new Dimension(250, 300));
            jPanel.add((Component)jScrollPane, GBC.std().fill(3).weight(0.0, 1.0));
            JButton jButton = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection"));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jButton, GBC.eol().anchor(16).weight(1.0, 1.0).insets(2, 0, 0, 3));
        }
        if (bl) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>"), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer"));
        this.cbClearUndoRedo.setSelected(Main.pref.getBoolean("purge.clear_undo_redo", false));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)this.cbClearUndoRedo, GBC.eol());
        return jPanel;
    }

    @Override
    protected void updateEnabledState() {
        if (PurgeAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!PurgeAction.getCurrentDataSet().selectionEmpty());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private boolean hasOnlyIncompleteMembers(Relation relation, Collection<OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember().isIncomplete() || collection.contains(relationMember.getMember()) || collection2.contains(relationMember.getMember())) continue;
            return false;
        }
        return true;
    }
}

