/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    public static final String loadDataPermissionKey = "remotecontrol.permission.load-data";
    public static final boolean loadDataPermissionDefault = true;
    public static final String changeSelectionPermissionKey = "remotecontrol.permission.change-selection";
    public static final boolean changeSelectionPermissionDefault = true;
    public static final String changeViewportPermissionKey = "remotecontrol.permission.change-viewport";
    public static final boolean changeViewportPermissionDefault = true;

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load data from the API.") + "<br>" + I18n.tr("Request details: {0}", this.request);
    }

    protected String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        Object object;
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d = Double.parseDouble((String)this.args.get("bottom"));
            d2 = Double.parseDouble((String)this.args.get("top"));
            d3 = Double.parseDouble((String)this.args.get("left"));
            d4 = Double.parseDouble((String)this.args.get("right"));
            if (command.equals(this.myCommand)) {
                if (!Main.pref.getBoolean(loadDataPermissionKey, true)) {
                    System.out.println("RemoteControl: download forbidden by preferences");
                } else {
                    Object object2;
                    object = null;
                    Area area = null;
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet != null) {
                        object = dataSet.getDataSourceArea();
                    }
                    if (object != null && !((Area)object).isEmpty()) {
                        area = new Area(new Rectangle2D.Double(d3, d, d4 - d3, d2 - d));
                        area.subtract((Area)object);
                        if (!area.isEmpty()) {
                            object2 = area.getBounds2D();
                            d = ((RectangularShape)object2).getMinY();
                            d3 = ((RectangularShape)object2).getMinX();
                            d2 = ((RectangularShape)object2).getMaxY();
                            d4 = ((RectangularShape)object2).getMaxX();
                        }
                    }
                    if (area != null && area.isEmpty()) {
                        System.out.println("RemoteControl: no download necessary");
                    } else {
                        object2 = downloadOsmTask.download(false, new Bounds(d, d3, d2, d4), null);
                        Main.worker.submit(new PostDownloadHandler((DownloadTask)downloadOsmTask, (Future<?>)object2));
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
        if (this.args.containsKey("select") && Main.pref.getBoolean(changeSelectionPermissionKey, true)) {
            object = (String)this.args.get("select");
            Main.worker.execute(new Runnable((String)object){
                final /* synthetic */ String val$selection;
                {
                    this.val$selection = string;
                }

                public void run() {
                    HashSet<Long> hashSet = new HashSet<Long>();
                    HashSet<Long> hashSet2 = new HashSet<Long>();
                    HashSet<Long> hashSet3 = new HashSet<Long>();
                    HashSet<OsmPrimitive> hashSet4 = new HashSet<OsmPrimitive>();
                    for (String string : this.val$selection.split(",")) {
                        if (string.startsWith("way")) {
                            hashSet.add(Long.parseLong(string.substring(3)));
                            continue;
                        }
                        if (string.startsWith("node")) {
                            hashSet2.add(Long.parseLong(string.substring(4)));
                            continue;
                        }
                        if (string.startsWith("relation")) {
                            hashSet3.add(Long.parseLong(string.substring(8)));
                            continue;
                        }
                        if (string.startsWith("rel")) {
                            hashSet3.add(Long.parseLong(string.substring(3)));
                            continue;
                        }
                        System.out.println("RemoteControl: invalid selection '" + string + "' ignored");
                    }
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet == null) {
                        return;
                    }
                    for (Way way : dataSet.getWays()) {
                        if (!hashSet.contains(way.getId())) continue;
                        hashSet4.add(way);
                    }
                    for (Node node : dataSet.getNodes()) {
                        if (!hashSet2.contains(node.getId())) continue;
                        hashSet4.add(node);
                    }
                    for (Relation relation : dataSet.getRelations()) {
                        if (!hashSet3.contains(relation.getId())) continue;
                        hashSet4.add(relation);
                    }
                    dataSet.setSelected(hashSet4);
                    if (Main.pref.getBoolean(LoadAndZoomHandler.changeViewportPermissionKey, true)) {
                        new AutoScaleAction("selection").actionPerformed(null);
                    }
                }
            });
        } else if (Main.pref.getBoolean(changeViewportPermissionKey, true)) {
            this.zoom(d, d2, d3, d4);
        }
    }

    protected void zoom(double d, double d2, double d3, double d4) {
        final Bounds bounds = new Bounds(new LatLon(d, d3), new LatLon(d2, d4));
        if (Main.map != null && Main.map.mapView != null) {
            Main.worker.execute(new Runnable(){

                public void run() {
                    BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                    boundingXYVisitor.visit(bounds);
                    Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                }
            });
        }
    }
}

