/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorPreference
implements PreferenceSetting {
    public static final String PREFIX = "validator";
    public static final String PREF_DEBUG = "validator.debug";
    public static final String PREF_LAYER = "validator.layer";
    public static final String PREF_TESTS = "validator.tests";
    public static final String PREF_USE_IGNORE = "validator.ignore";
    public static final String PREF_TESTS_BEFORE_UPLOAD = "validator.testsBeforeUpload";
    public static final String PREF_OTHER_UPLOAD = "validator.otherUpload";
    public static final String PREF_OTHER = "validator.other";
    public static final String PREF_FILTER_BY_SELECTION = "validator.selectionFilter";
    private JCheckBox prefUseIgnore;
    private JCheckBox prefUseLayer;
    private JCheckBox prefOtherUpload;
    private JCheckBox prefOther;
    private Collection<Test> allTests;

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.prefUseIgnore = new JCheckBox(I18n.tr("Use ignore list."), Main.pref.getBoolean(PREF_USE_IGNORE, true));
        this.prefUseIgnore.setToolTipText(I18n.tr("Use the ignore list to suppress warnings."));
        jPanel.add((Component)this.prefUseIgnore, GBC.eol());
        this.prefUseLayer = new JCheckBox(I18n.tr("Use error layer."), Main.pref.getBoolean(PREF_LAYER, true));
        this.prefUseLayer.setToolTipText(I18n.tr("Use the error layer to display problematic elements."));
        jPanel.add((Component)this.prefUseLayer, GBC.eol());
        this.prefOther = new JCheckBox(I18n.tr("Show informational level."), Main.pref.getBoolean(PREF_OTHER, false));
        this.prefOther.setToolTipText(I18n.tr("Show the informational tests."));
        jPanel.add((Component)this.prefOther, GBC.eol());
        this.prefOtherUpload = new JCheckBox(I18n.tr("Show informational level on upload."), Main.pref.getBoolean(PREF_OTHER_UPLOAD, false));
        this.prefOtherUpload.setToolTipText(I18n.tr("Show the informational tests in the upload check windows."));
        jPanel.add((Component)this.prefOtherUpload, GBC.eol());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorPreference.this.prefOtherUpload.setEnabled(ValidatorPreference.this.prefOther.isSelected());
            }
        };
        this.prefOther.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        GBC gBC = GBC.eol().insets(-5, 0, 0, 0);
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(I18n.tr("On demand")), GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr("On upload")), gBC);
        this.allTests = OsmValidator.getTests();
        for (Test object2 : this.allTests) {
            object2.addGui(jPanel);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        String string = I18n.tr("An OSM data validator that checks for common errors made by users and editor programs.");
        JPanel jPanel2 = preferenceTabbedPane.createPreferenceTab(PREFIX, I18n.tr("Data validator"), string);
        jPanel2.add((Component)jScrollPane, GBC.eol().fill(1));
        jPanel2.add(GBC.glue(0, 10), gBC);
    }

    public boolean ok() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Test test : this.allTests) {
            test.ok();
            String string = test.getClass().getSimpleName();
            stringBuilder.append(',').append(string).append('=').append(test.enabled);
            stringBuilder2.append(',').append(string).append('=').append(test.testBeforeUpload);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder = stringBuilder.deleteCharAt(0);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2 = stringBuilder2.deleteCharAt(0);
        }
        OsmValidator.initializeTests(this.allTests);
        Main.pref.put(PREF_TESTS, stringBuilder.toString());
        Main.pref.put(PREF_TESTS_BEFORE_UPLOAD, stringBuilder2.toString());
        Main.pref.put(PREF_USE_IGNORE, this.prefUseIgnore.isSelected());
        Main.pref.put(PREF_OTHER, this.prefOther.isSelected());
        Main.pref.put(PREF_OTHER_UPLOAD, this.prefOtherUpload.isSelected());
        Main.pref.put(PREF_LAYER, this.prefUseLayer.isSelected());
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorPreference();
        }
    }
}

