/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class RemoteControlPreference
implements PreferenceSetting {
    private JCheckBox enableRemoteControl;
    private JCheckBox permissionLoadData = new JCheckBox(I18n.tr("Load data from API"));
    private JCheckBox permissionImportData = new JCheckBox(I18n.tr("Import data from URL"));
    private JCheckBox permissionLoadImagery = new JCheckBox(I18n.tr("Load imagery layers"));
    private JCheckBox permissionCreateObjects = new JCheckBox(I18n.tr("Create new objects"));
    private JCheckBox permissionChangeSelection = new JCheckBox(I18n.tr("Change the selection"));
    private JCheckBox permissionChangeViewport = new JCheckBox(I18n.tr("Change the viewport"));
    private JCheckBox permissionReadProtocolversion = new JCheckBox(I18n.tr("Read protocol version"));
    private JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr("Confirm all Remote Control actions manually"));

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = preferenceTabbedPane.createPreferenceTab("remotecontrol.gif", I18n.tr("Remote Control"), I18n.tr("Settings for the remote control feature."));
        this.enableRemoteControl = new JCheckBox(I18n.tr("Enable remote control"), RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        jPanel.add((Component)this.enableRemoteControl, GBC.eol());
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray)));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2).insets(5, 5, 5, 5));
        final JLabel jLabel = new JLabel("<html>" + I18n.tr("The remote control feature allows JOSM to be controlled from other applications, e.g. from a web browser.") + "</html>");
        jPanel2.add((Component)jLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jPanel2.add((Component)new JLabel(I18n.tr("Permitted actions:")), GBC.eol());
        int n = 15;
        jPanel2.add((Component)this.permissionLoadData, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionImportData, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionLoadImagery, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionChangeSelection, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionChangeViewport, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionCreateObjects, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)this.permissionReadProtocolversion, GBC.eol().insets(n, 5, 0, 0).fill(2));
        jPanel2.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        jPanel2.add((Component)this.alwaysAskUserConfirm, GBC.eol().fill(2));
        final JLabel jLabel2 = new JLabel("<html>" + I18n.tr("JOSM will always listen at port 8111 on localhost.This port is not configurable because it is referenced by external applications talking to JOSM.") + "</html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        jPanel2.add((Component)jLabel2, GBC.eol().insets(5, 5, 0, 10).fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.permissionLoadData.setSelected(Main.pref.getBoolean("remotecontrol.permission.load-data", true));
        this.permissionImportData.setSelected(Main.pref.getBoolean("remotecontrol.permission.import", true));
        this.permissionLoadImagery.setSelected(Main.pref.getBoolean("remotecontrol.permission.imagery", true));
        this.permissionChangeSelection.setSelected(Main.pref.getBoolean("remotecontrol.permission.change-selection", true));
        this.permissionChangeViewport.setSelected(Main.pref.getBoolean("remotecontrol.permission.change-viewport", true));
        this.permissionCreateObjects.setSelected(Main.pref.getBoolean("remotecontrol.permission.create-objects", false));
        this.permissionReadProtocolversion.setSelected(Main.pref.getBoolean("remotecontrol.permission.read-protocolversion", true));
        this.alwaysAskUserConfirm.setSelected(Main.pref.getBoolean("remotecontrol.always-confirm", false));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RemoteControlPreference.this.enableRemoteControl.isSelected();
                GuiHelper.setEnabledRec(jPanel2, RemoteControlPreference.this.enableRemoteControl.isSelected());
                jLabel2.setForeground(bl ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
                jLabel.setForeground(bl ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
            }
        };
        this.enableRemoteControl.addActionListener(actionListener);
        actionListener.actionPerformed(null);
    }

    public boolean ok() {
        boolean bl = this.enableRemoteControl.isSelected();
        boolean bl2 = RemoteControl.PROP_REMOTECONTROL_ENABLED.put(bl);
        if (bl) {
            Main.pref.put("remotecontrol.permission.load-data", this.permissionLoadData.isSelected());
            Main.pref.put("remotecontrol.permission.import", this.permissionImportData.isSelected());
            Main.pref.put("remotecontrol.permission.imagery", this.permissionLoadImagery.isSelected());
            Main.pref.put("remotecontrol.permission.change-selection", this.permissionChangeSelection.isSelected());
            Main.pref.put("remotecontrol.permission.change-viewport", this.permissionChangeViewport.isSelected());
            Main.pref.put("remotecontrol.permission.create-objects", this.permissionCreateObjects.isSelected());
            Main.pref.put("remotecontrol.permission.read-protocolversion", this.permissionReadProtocolversion.isSelected());
            Main.pref.put("remotecontrol.always-confirm", this.alwaysAskUserConfirm.isSelected());
        }
        return bl2;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new RemoteControlPreference();
        }
    }
}

