/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.ChangePropertyKeyCommand;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagChecker
extends Test {
    public static final String DATA_FILE = "resource://data/tagchecker.cfg";
    public static final String IGNORE_FILE = "resource://data/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/words.cfg";
    protected static Map<String, String> spellCheckKeyData;
    protected static MultiMap<String, String> presetsValueData;
    protected static List<CheckerData> checkerData;
    protected static List<String> ignoreDataStartsWith;
    protected static List<String> ignoreDataEquals;
    protected static List<String> ignoreDataEndsWith;
    protected static List<IgnoreKeyPair> ignoreDataKeyPair;
    protected static List<IgnoreTwoKeyPair> ignoreDataTwoKeyPair;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    public static final String PREF_USE_DATA_FILE;
    public static final String PREF_USE_IGNORE_FILE;
    public static final String PREF_USE_SPELL_FILE;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    protected boolean checkKeys = false;
    protected boolean checkValues = false;
    protected boolean checkComplex = false;
    protected boolean checkFixmes = false;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected JCheckBox prefUseDataFile;
    protected JCheckBox prefUseIgnoreFile;
    protected JCheckBox prefUseSpellFile;
    protected JButton addSrcButton;
    protected JButton editSrcButton;
    protected JButton deleteSrcButton;
    protected static int EMPTY_VALUES;
    protected static int INVALID_KEY;
    protected static int INVALID_VALUE;
    protected static int FIXME;
    protected static int INVALID_SPACE;
    protected static int INVALID_KEY_SPACE;
    protected static int INVALID_HTML;
    protected static int LONG_VALUE;
    protected static int LONG_KEY;
    protected static int LOW_CHAR_VALUE;
    protected static int LOW_CHAR_KEY;
    protected JList sourcesList;
    protected static Entities entities;

    public TagChecker() {
        super(I18n.tr("Properties checker :"), I18n.tr("This plugin checks for errors in property keys and values."));
    }

    @Override
    public void initialize() throws Exception {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    private static void initializeData() throws IOException {
        spellCheckKeyData = new HashMap<String, String>();
        String string = Main.pref.get(PREF_SOURCES, "");
        if (Main.pref.getBoolean(PREF_USE_DATA_FILE, true)) {
            string = string == null || string.length() == 0 ? DATA_FILE : "resource://data/tagchecker.cfg;" + string;
        }
        if (Main.pref.getBoolean(PREF_USE_IGNORE_FILE, true)) {
            string = string == null || string.length() == 0 ? IGNORE_FILE : "resource://data/ignoretags.cfg;" + string;
        }
        if (Main.pref.getBoolean(PREF_USE_SPELL_FILE, true)) {
            string = string == null || string.length() == 0 ? SPELL_FILE : "resource://data/words.cfg;" + string;
        }
        String string2 = "";
        if (string.length() == 0) {
            return;
        }
        for (String string3 : string.split(";")) {
            try {
                String string4;
                InputStreamReader inputStreamReader;
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string3, OsmValidator.getValidatorDir(), -1L);
                try {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader(mirroredInputStream);
                }
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string5 = null;
                boolean bl = false;
                boolean bl2 = false;
                while ((string4 = bufferedReader.readLine()) != null && (bl || string4.length() != 0)) {
                    Object object;
                    Object object2;
                    if (string4.startsWith("#")) {
                        if (string4.startsWith("# JOSM TagChecker")) {
                            bl = true;
                        }
                        if (!string4.startsWith("# JOSM IgnoreTags")) continue;
                        bl2 = true;
                        continue;
                    }
                    if (bl2) {
                        int n;
                        if ((string4 = string4.trim()).length() < 4) continue;
                        object2 = string4.substring(0, 2);
                        string4 = string4.substring(2);
                        if (((String)object2).equals("S:")) {
                            ignoreDataStartsWith.add(string4);
                            continue;
                        }
                        if (((String)object2).equals("E:")) {
                            ignoreDataEquals.add(string4);
                            continue;
                        }
                        if (((String)object2).equals("F:")) {
                            ignoreDataEndsWith.add(string4);
                            continue;
                        }
                        if (((String)object2).equals("K:")) {
                            object = new IgnoreKeyPair();
                            n = string4.indexOf("=");
                            ((IgnoreKeyPair)object).key = string4.substring(0, n);
                            ((IgnoreKeyPair)object).value = string4.substring(n + 1);
                            ignoreDataKeyPair.add((IgnoreKeyPair)object);
                            continue;
                        }
                        if (!((String)object2).equals("T:")) continue;
                        object = new IgnoreTwoKeyPair();
                        n = string4.indexOf("=");
                        int n2 = string4.indexOf("|");
                        ((IgnoreTwoKeyPair)object).key1 = string4.substring(0, n);
                        ((IgnoreTwoKeyPair)object).value1 = string4.substring(n + 1, n2);
                        string4 = string4.substring(n2 + 1);
                        n = string4.indexOf("=");
                        ((IgnoreTwoKeyPair)object).key2 = string4.substring(0, n);
                        ((IgnoreTwoKeyPair)object).value2 = string4.substring(n + 1);
                        ignoreDataTwoKeyPair.add((IgnoreTwoKeyPair)object);
                        continue;
                    }
                    if (bl) {
                        if (string4.length() <= 0) continue;
                        object2 = new CheckerData();
                        object = ((CheckerData)object2).getData(string4);
                        if (object == null) {
                            checkerData.add((CheckerData)object2);
                            continue;
                        }
                        System.err.println(I18n.tr("Invalid tagchecker line - {0}: {1}", object, string4));
                        continue;
                    }
                    if (string4.charAt(0) == '+') {
                        string5 = string4.substring(1);
                        continue;
                    }
                    if (string4.charAt(0) == '-' && string5 != null) {
                        spellCheckKeyData.put(string4.substring(1), string5);
                        continue;
                    }
                    System.err.println(I18n.tr("Invalid spellcheck line: {0}", string4));
                }
            }
            catch (IOException iOException) {
                string2 = string2 + string3 + "\n";
            }
        }
        if (string2.length() > 0) {
            throw new IOException(I18n.tr("Could not access data file(s):\n{0}", string2));
        }
    }

    public static void initializePresets() throws Exception {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            presetsValueData = new MultiMap();
            for (String object : OsmPrimitive.getUninterestingKeys()) {
                presetsValueData.putVoid(object);
            }
            for (String string : Main.pref.getCollection("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
                presetsValueData.putVoid(string);
            }
            for (TaggingPreset taggingPreset : collection) {
                for (TaggingPreset.Item item : taggingPreset.data) {
                    TaggingPreset.Item item2;
                    if (item instanceof TaggingPreset.Combo) {
                        item2 = (TaggingPreset.Combo)item;
                        if (item2.values == null) continue;
                        for (String string : item2.values.split(",")) {
                            presetsValueData.put(item2.key, string);
                        }
                        continue;
                    }
                    if (item instanceof TaggingPreset.Key) {
                        item2 = (TaggingPreset.Key)item;
                        presetsValueData.put(((TaggingPreset.Key)item2).key, ((TaggingPreset.Key)item2).value);
                        continue;
                    }
                    if (item instanceof TaggingPreset.Text) {
                        item2 = (TaggingPreset.Text)item;
                        presetsValueData.putVoid(((TaggingPreset.Text)item2).key);
                        continue;
                    }
                    if (!(item instanceof TaggingPreset.Check)) continue;
                    item2 = (TaggingPreset.Check)item;
                    presetsValueData.put(((TaggingPreset.Check)item2).key, "yes");
                    presetsValueData.put(((TaggingPreset.Check)item2).key, "no");
                }
            }
        }
    }

    @Override
    public void visit(Node node) {
        this.checkPrimitive(node);
    }

    @Override
    public void visit(Relation relation) {
        this.checkPrimitive(relation);
    }

    @Override
    public void visit(Way way) {
        this.checkPrimitive(way);
    }

    private boolean containsLow(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= ' ') continue;
            return true;
        }
        return false;
    }

    private void checkPrimitive(OsmPrimitive osmPrimitive) {
        String string;
        String string2;
        Map<Object, Object> map;
        MultiMap<OsmPrimitive, String> multiMap = new MultiMap<OsmPrimitive, String>();
        if (this.checkComplex) {
            map = osmPrimitive.getKeys() == null ? Collections.emptyMap() : osmPrimitive.getKeys();
            for (Map.Entry<Object, Object> object : map.entrySet()) {
                boolean string5 = true;
                string2 = (String)object.getKey();
                string = (String)object.getValue();
                for (IgnoreTwoKeyPair ignoreTwoKeyPair : ignoreDataTwoKeyPair) {
                    if (string2.equals(ignoreTwoKeyPair.key1) && string.equals(ignoreTwoKeyPair.value1)) {
                        string5 = false;
                        for (Map.Entry<Object, Object> entry : map.entrySet()) {
                            String string3 = (String)entry.getKey();
                            String string4 = (String)entry.getValue();
                            for (IgnoreTwoKeyPair ignoreTwoKeyPair2 : ignoreDataTwoKeyPair) {
                                if (!string3.equals(ignoreTwoKeyPair2.key2) || !string4.equals(ignoreTwoKeyPair2.value2)) continue;
                                string5 = true;
                                break;
                            }
                            if (!string5) continue;
                            break;
                        }
                    }
                    if (!string5) continue;
                    break;
                }
                if (string5) continue;
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Illegal tag/value combinations"), I18n.tr("Illegal tag/value combinations"), I18n.tr("Illegal tag/value combinations"), 1272, osmPrimitive));
                multiMap.put(osmPrimitive, "TC");
            }
            Map<String, String> map2 = osmPrimitive.getKeys();
            for (CheckerData checkerData : TagChecker.checkerData) {
                if (!checkerData.match(osmPrimitive, map2)) continue;
                this.errors.add(new TestError((Test)this, checkerData.getSeverity(), I18n.tr("Illegal tag/value combinations"), checkerData.getDescription(), checkerData.getDescriptionOrig(), checkerData.getCode(), osmPrimitive));
                multiMap.put(osmPrimitive, "TC");
            }
        }
        map = osmPrimitive.getKeys() == null ? Collections.emptyMap() : osmPrimitive.getKeys();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String string5 = I18n.marktr("Key ''{0}'' invalid.");
            string2 = (String)entry.getKey();
            string = (String)entry.getValue();
            if (this.checkValues && this.containsLow(string) && !multiMap.contains(osmPrimitive, "ICV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tag value contains character with code less than 0x20"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), LOW_CHAR_VALUE, osmPrimitive));
                multiMap.put(osmPrimitive, "ICV");
            }
            if (this.checkKeys && this.containsLow(string2) && !multiMap.contains(osmPrimitive, "ICK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tag key contains character with code less than 0x20"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), LOW_CHAR_KEY, osmPrimitive));
                multiMap.put(osmPrimitive, "ICK");
            }
            if (this.checkValues && string != null && string.length() > 255 && !multiMap.contains(osmPrimitive, "LV")) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Tag value longer than allowed"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), LONG_VALUE, osmPrimitive));
                multiMap.put(osmPrimitive, "LV");
            }
            if (this.checkKeys && string2 != null && string2.length() > 255 && !multiMap.contains(osmPrimitive, "LK")) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Tag key longer than allowed"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), LONG_KEY, osmPrimitive));
                multiMap.put(osmPrimitive, "LK");
            }
            if (this.checkValues && (string == null || string.trim().length() == 0) && !multiMap.contains(osmPrimitive, "EV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tags with empty values"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), EMPTY_VALUES, osmPrimitive));
                multiMap.put(osmPrimitive, "EV");
            }
            if (this.checkKeys && spellCheckKeyData.containsKey(string2) && !multiMap.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Invalid property key"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), INVALID_KEY, osmPrimitive));
                multiMap.put(osmPrimitive, "IPK");
            }
            if (this.checkKeys && string2.indexOf(" ") >= 0 && !multiMap.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Invalid white space in property key"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), INVALID_KEY_SPACE, osmPrimitive));
                multiMap.put(osmPrimitive, "IPK");
            }
            if (this.checkValues && string != null && (string.startsWith(" ") || string.endsWith(" ")) && !multiMap.contains(osmPrimitive, "SPACE")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Property values start or end with white space"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), INVALID_SPACE, osmPrimitive));
                multiMap.put(osmPrimitive, "SPACE");
            }
            if (this.checkValues && string != null && !string.equals(entities.unescape(string)) && !multiMap.contains(osmPrimitive, "HTML")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Property values contain HTML entity"), I18n.tr(string5, string2), MessageFormat.format(string5, string2), INVALID_HTML, osmPrimitive));
                multiMap.put(osmPrimitive, "HTML");
            }
            if (this.checkValues && string != null && string.length() > 0 && presetsValueData != null) {
                Object object;
                boolean bl;
                Set<String> set = presetsValueData.get(string2);
                if (set == null) {
                    bl = false;
                    for (String string6 : ignoreDataStartsWith) {
                        if (!string2.startsWith(string6)) continue;
                        bl = true;
                    }
                    for (String string7 : ignoreDataEquals) {
                        if (!string2.equals(string7)) continue;
                        bl = true;
                    }
                    for (String string8 : ignoreDataEndsWith) {
                        if (!string2.endsWith(string8)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        object = I18n.marktr("Key ''{0}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Presets do not contain property key"), I18n.tr((String)object, string2), MessageFormat.format((String)object, string2), INVALID_VALUE, osmPrimitive));
                        multiMap.put(osmPrimitive, "UPK");
                    }
                } else if (set.size() > 0 && !set.contains(entry.getValue())) {
                    bl = false;
                    for (IgnoreKeyPair ignoreKeyPair : ignoreDataKeyPair) {
                        if (!string2.equals(ignoreKeyPair.key) || !string.equals(ignoreKeyPair.value)) continue;
                        bl = true;
                    }
                    for (IgnoreTwoKeyPair ignoreTwoKeyPair : ignoreDataTwoKeyPair) {
                        if (!string2.equals(ignoreTwoKeyPair.key2) || !string.equals(ignoreTwoKeyPair.value2)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        object = I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Presets do not contain property value"), I18n.tr((String)object, entry.getValue(), string2), MessageFormat.format((String)object, entry.getValue(), string2), INVALID_VALUE, osmPrimitive));
                        multiMap.put(osmPrimitive, "UPV");
                    }
                }
            }
            if (!this.checkFixmes || string == null || string.length() <= 0 || !string.toLowerCase().contains("fixme") && !string.contains("check and delete") && !string2.contains("todo") && !string2.toLowerCase().contains("fixme") || multiMap.contains(osmPrimitive, "FIXME")) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("FIXMES"), FIXME, osmPrimitive));
            multiMap.put(osmPrimitive, "FIXME");
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Main.pref.getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkValues && Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes) {
            super.visit(collection);
        }
    }

    @Override
    public void addGui(JPanel jPanel) {
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(this.name), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys."), Main.pref.getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words."));
        jPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckKeysBeforeUpload, gBC);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker."), Main.pref.getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules."));
        jPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckComplexBeforeUpload, gBC);
        this.sourcesList = new JList(new DefaultListModel());
        String string = Main.pref.get(PREF_SOURCES);
        if (string != null && string.length() > 0) {
            for (String string2 : string.split(";")) {
                ((DefaultListModel)this.sourcesList.getModel()).addElement(string2);
            }
        }
        this.addSrcButton = new JButton(I18n.tr("Add"));
        this.addSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, I18n.tr("TagChecker source"), I18n.tr("TagChecker source"), 3);
                if (string != null) {
                    ((DefaultListModel)TagChecker.this.sourcesList.getModel()).addElement(string);
                }
                TagChecker.this.sourcesList.clearSelection();
            }
        });
        this.editSrcButton = new JButton(I18n.tr("Edit"));
        this.editSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TagChecker.this.sourcesList.getSelectedIndex();
                if (n == -1 && TagChecker.this.sourcesList.getModel().getSize() == 1) {
                    TagChecker.this.sourcesList.setSelectedIndex(0);
                    n = 0;
                }
                if (n == -1) {
                    if (TagChecker.this.sourcesList.getModel().getSize() == 0) {
                        String string = JOptionPane.showInputDialog(Main.parent, I18n.tr("TagChecker source"), I18n.tr("TagChecker source"), 3);
                        if (string != null) {
                            ((DefaultListModel)TagChecker.this.sourcesList.getModel()).addElement(string);
                        }
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."), I18n.tr("Information"), 1);
                    }
                } else {
                    String string = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("TagChecker source"), I18n.tr("TagChecker source"), 3, null, null, TagChecker.this.sourcesList.getSelectedValue());
                    if (string != null) {
                        ((DefaultListModel)TagChecker.this.sourcesList.getModel()).setElementAt(string, n);
                    }
                }
                TagChecker.this.sourcesList.clearSelection();
            }
        });
        this.deleteSrcButton = new JButton(I18n.tr("Delete"));
        this.deleteSrcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TagChecker.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."), I18n.tr("Information"), 3);
                } else {
                    ((DefaultListModel)TagChecker.this.sourcesList.getModel()).remove(TagChecker.this.sourcesList.getSelectedIndex());
                }
            }
        });
        this.sourcesList.setMinimumSize(new Dimension(300, 50));
        this.sourcesList.setVisibleRowCount(3);
        this.sourcesList.setToolTipText(I18n.tr("The sources (URL or filename) of spell check (see http://wiki.openstreetmap.org/index.php/User:JLS/speller) or tag checking data files."));
        this.addSrcButton.setToolTipText(I18n.tr("Add a new source to the list."));
        this.editSrcButton.setToolTipText(I18n.tr("Edit the selected source."));
        this.deleteSrcButton.setToolTipText(I18n.tr("Delete the selected source from the list."));
        jPanel.add((Component)new JLabel(I18n.tr("Data sources")), GBC.eol().insets(23, 0, 0, 0));
        jPanel.add((Component)new JScrollPane(this.sourcesList), GBC.eol().insets(23, 0, 0, 0).fill(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel2.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        jPanel2.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagChecker.this.handlePrefEnable();
            }
        };
        this.prefCheckKeys.addActionListener(actionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(actionListener);
        this.prefCheckComplex.addActionListener(actionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(actionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values."), Main.pref.getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets."));
        jPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckValuesBeforeUpload, gBC);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for FIXMES."), Main.pref.getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with FIXME in any property value."));
        jPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckFixmesBeforeUpload, gBC);
        this.prefUseDataFile = new JCheckBox(I18n.tr("Use default data file."), Main.pref.getBoolean(PREF_USE_DATA_FILE, true));
        this.prefUseDataFile.setToolTipText(I18n.tr("Use the default data file (recommended)."));
        jPanel.add((Component)this.prefUseDataFile, GBC.eol().insets(20, 0, 0, 0));
        this.prefUseIgnoreFile = new JCheckBox(I18n.tr("Use default tag ignore file."), Main.pref.getBoolean(PREF_USE_IGNORE_FILE, true));
        this.prefUseIgnoreFile.setToolTipText(I18n.tr("Use the default tag ignore file (recommended)."));
        jPanel.add((Component)this.prefUseIgnoreFile, GBC.eol().insets(20, 0, 0, 0));
        this.prefUseSpellFile = new JCheckBox(I18n.tr("Use default spellcheck file."), Main.pref.getBoolean(PREF_USE_SPELL_FILE, true));
        this.prefUseSpellFile.setToolTipText(I18n.tr("Use the default spellcheck file (recommended)."));
        jPanel.add((Component)this.prefUseSpellFile, GBC.eol().insets(20, 0, 0, 0));
    }

    public void handlePrefEnable() {
        boolean bl = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(bl);
        this.addSrcButton.setEnabled(bl);
        this.editSrcButton.setEnabled(bl);
        this.deleteSrcButton.setEnabled(bl);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        Main.pref.put(PREF_USE_DATA_FILE, this.prefUseDataFile.isSelected());
        Main.pref.put(PREF_USE_IGNORE_FILE, this.prefUseIgnoreFile.isSelected());
        Main.pref.put(PREF_USE_SPELL_FILE, this.prefUseSpellFile.isSelected());
        String string = "";
        if (this.sourcesList.getModel().getSize() > 0) {
            String string2 = "";
            for (int i = 0; i < this.sourcesList.getModel().getSize(); ++i) {
                string2 = string2 + ";" + this.sourcesList.getModel().getElementAt(i);
            }
            string = string2.substring(1);
        }
        if (string.length() == 0) {
            string = null;
        }
        return Main.pref.put(PREF_SOURCES, string);
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> arrayList = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            Map<String, String> map = osmPrimitive.getKeys();
            if (map == null || map.isEmpty()) continue;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == null || string2.trim().length() == 0) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(osmPrimitive), string, null));
                    continue;
                }
                if (string2.startsWith(" ") || string2.endsWith(" ")) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(osmPrimitive), string, string2.trim()));
                    continue;
                }
                if (string.startsWith(" ") || string.endsWith(" ")) {
                    arrayList.add(new ChangePropertyKeyCommand(Collections.singleton(osmPrimitive), string, string.trim()));
                    continue;
                }
                String string3 = entities.unescape(string2);
                if (!string3.equals(string2)) {
                    arrayList.add(new ChangePropertyCommand(Collections.singleton(osmPrimitive), string, string3));
                    continue;
                }
                String string4 = spellCheckKeyData.get(string);
                if (string4 == null) continue;
                arrayList.add(new ChangePropertyKeyCommand(Collections.singleton(osmPrimitive), string, string4));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix properties"), arrayList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int n = testError.getCode();
            return n == INVALID_KEY || n == EMPTY_VALUES || n == INVALID_SPACE || n == INVALID_KEY_SPACE || n == INVALID_HTML;
        }
        return false;
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new ArrayList<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataKeyPair = new ArrayList<IgnoreKeyPair>();
        ignoreDataTwoKeyPair = new ArrayList<IgnoreTwoKeyPair>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".sources";
        PREF_USE_DATA_FILE = PREFIX + ".usedatafile";
        PREF_USE_IGNORE_FILE = PREFIX + ".useignorefile";
        PREF_USE_SPELL_FILE = PREFIX + ".usespellfile";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        EMPTY_VALUES = 1200;
        INVALID_KEY = 1201;
        INVALID_VALUE = 1202;
        FIXME = 1203;
        INVALID_SPACE = 1204;
        INVALID_KEY_SPACE = 1205;
        INVALID_HTML = 1206;
        LONG_VALUE = 1208;
        LONG_KEY = 1209;
        LOW_CHAR_VALUE = 1210;
        LOW_CHAR_KEY = 1211;
        entities = new Entities();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CheckerData {
        private String description;
        private List<CheckerElement> data = new ArrayList<CheckerElement>();
        private OsmPrimitiveType type;
        private int code;
        protected Severity severity;
        protected static int TAG_CHECK_ERROR = 1250;
        protected static int TAG_CHECK_WARN = 1260;
        protected static int TAG_CHECK_INFO = 1270;

        protected CheckerData() {
        }

        public String getData(String string) {
            Matcher matcher = Pattern.compile(" *# *([^#]+) *$").matcher(string);
            string = matcher.replaceFirst("").trim();
            try {
                this.description = matcher.group(1);
                if (this.description != null && this.description.length() == 0) {
                    this.description = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.description = null;
            }
            String[] stringArray = string.split(" *: *", 3);
            if (stringArray[0].equals("way")) {
                this.type = OsmPrimitiveType.WAY;
            } else if (stringArray[0].equals("node")) {
                this.type = OsmPrimitiveType.NODE;
            } else if (stringArray[0].equals("relation")) {
                this.type = OsmPrimitiveType.RELATION;
            } else if (stringArray[0].equals("*")) {
                this.type = null;
            } else {
                return I18n.tr("Could not find element type");
            }
            if (stringArray.length != 3) {
                return I18n.tr("Incorrect number of parameters");
            }
            if (stringArray[1].equals("W")) {
                this.severity = Severity.WARNING;
                this.code = TAG_CHECK_WARN;
            } else if (stringArray[1].equals("E")) {
                this.severity = Severity.ERROR;
                this.code = TAG_CHECK_ERROR;
            } else if (stringArray[1].equals("I")) {
                this.severity = Severity.OTHER;
                this.code = TAG_CHECK_INFO;
            } else {
                return I18n.tr("Could not find warning level");
            }
            for (String string2 : stringArray[2].split(" *&& *")) {
                try {
                    this.data.add(new CheckerElement(string2));
                }
                catch (IllegalStateException illegalStateException) {
                    return I18n.tr("Illegal expression ''{0}''", string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return I18n.tr("Illegal regular expression ''{0}''", string2);
                }
            }
            return null;
        }

        public boolean match(OsmPrimitive osmPrimitive, Map<String, String> map) {
            if (this.type != null && OsmPrimitiveType.from(osmPrimitive) != this.type) {
                return false;
            }
            for (CheckerElement checkerElement : this.data) {
                if (checkerElement.match(osmPrimitive, map)) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return I18n.tr(this.description);
        }

        public String getDescriptionOrig() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            if (this.type == null) {
                return this.code;
            }
            return this.code + this.type.ordinal() + 1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckerElement {
            public Object tag;
            public Object value;
            public boolean noMatch;
            public boolean tagAll = false;
            public boolean valueAll = false;
            public boolean valueBool = false;

            private Pattern getPattern(String string) throws IllegalStateException, PatternSyntaxException {
                if (string.endsWith("/i")) {
                    return Pattern.compile(string.substring(1, string.length() - 2), 2);
                }
                if (string.endsWith("/")) {
                    return Pattern.compile(string.substring(1, string.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String string) throws IllegalStateException, PatternSyntaxException {
                Matcher matcher = Pattern.compile("(.+)([!=]=)(.+)").matcher(string);
                matcher.matches();
                String string2 = matcher.group(1).trim();
                if (string2.equals("*")) {
                    this.tagAll = true;
                } else {
                    this.tag = string2.startsWith("/") ? this.getPattern(string2) : string2;
                    this.noMatch = matcher.group(2).equals("!=");
                    string2 = matcher.group(3).trim();
                    if (string2.equals("*")) {
                        this.valueAll = true;
                    } else if (string2.equals("BOOLEAN_TRUE")) {
                        this.valueBool = true;
                        this.value = "yes";
                    } else if (string2.equals("BOOLEAN_FALSE")) {
                        this.valueBool = true;
                        this.value = "no";
                    } else {
                        this.value = string2.startsWith("/") ? this.getPattern(string2) : string2;
                    }
                }
            }

            public boolean match(OsmPrimitive osmPrimitive, Map<String, String> map) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string;
                    String string2 = entry.getKey();
                    String string3 = string = this.valueBool ? OsmUtils.getNamedOsmBoolean(entry.getValue()) : entry.getValue();
                    if (!this.tagAll && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(string2).matches() : string2.equals(this.tag)) || !this.valueAll && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(string).matches() : string.equals(this.value))) continue;
                    return !this.noMatch;
                }
                return this.noMatch;
            }
        }
    }

    protected static class IgnoreKeyPair {
        public String key;
        public String value;

        protected IgnoreKeyPair() {
        }
    }

    protected static class IgnoreTwoKeyPair {
        public String key1;
        public String value1;
        public String key2;
        public String value2;

        protected IgnoreTwoKeyPair() {
        }
    }
}

