/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.MultipolygonCreate;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMultipolygonAction
extends JosmAction {
    public CreateMultipolygonAction() {
        super(I18n.tr("Create multipolygon"), "multipoly_create", I18n.tr("Create multipolygon."), Shortcut.registerShortcut("tools:multipoly", I18n.tr("Tool: {0}", I18n.tr("Create multipolygon")), 65, 3, 1), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main.getEditLayer() == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data loaded."));
            return;
        }
        Collection<Way> collection = Main.main.getCurrentDataSet().getSelectedWays();
        if (collection.size() < 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select at least one way."));
            return;
        }
        MultipolygonCreate multipolygonCreate = this.analyzeWays(collection);
        if (multipolygonCreate == null) {
            return;
        }
        final Relation relation = this.createRelation(multipolygonCreate);
        if (Main.pref.getBoolean("multipoly.show-relation-editor", false)) {
            RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation, null);
            relationEditor.setModal(true);
            relationEditor.setVisible(true);
        } else {
            List<Command> list = this.removeTagsFromInnerWays(relation);
            list.add(new AddCommand(relation));
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create multipolygon"), list));
            Main.map.relationListDialog.unfurlDialog();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.map.relationListDialog.selectRelation(relation);
                }
            });
        }
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private MultipolygonCreate analyzeWays(Collection<Way> collection) {
        MultipolygonCreate multipolygonCreate = new MultipolygonCreate();
        String string = multipolygonCreate.makeFromWays(collection);
        if (string != null) {
            JOptionPane.showMessageDialog(Main.parent, string);
            return null;
        }
        return multipolygonCreate;
    }

    private Relation createRelation(MultipolygonCreate multipolygonCreate) {
        Relation relation = new Relation();
        relation.put("type", "multipolygon");
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.outerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("outer", way));
            }
        }
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.innerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("inner", way));
            }
        }
        return relation;
    }

    private List<Command> removeTagsFromInnerWays(Relation relation) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (relation.hasKeys()) {
            for (String arrayList2 : relation.keySet()) {
                hashMap.put(arrayList2, relation.get(arrayList2));
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.hasRole() && relationMember.getRole() == "inner" && relationMember.isWay() && relationMember.getWay().hasKeys()) {
                arrayList3.add(relationMember.getWay());
            }
            if (!relationMember.hasRole() || relationMember.getRole() != "outer" || !relationMember.isWay() || !relationMember.getWay().hasKeys()) continue;
            Object object = relationMember.getWay();
            for (String string : ((OsmPrimitive)object).keySet()) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, ((OsmPrimitive)object).get(string));
            }
        }
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Object object : hashMap.keySet()) {
            String string;
            ArrayList arrayList2 = new ArrayList();
            string = (String)hashMap.get(object);
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                Way way = (Way)iterator.next();
                if (!string.equals(way.get((String)object))) continue;
                arrayList2.add(way);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(new ChangePropertyCommand(arrayList2, (String)object, null));
        }
        return arrayList;
    }
}

