/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected List<MapMarker> mapMarkerList;
    protected List<MapRectangle> mapRectangleList;
    protected boolean mapMarkersVisible;
    protected boolean mapRectanglesVisible;
    protected boolean tileGridVisible;
    protected TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    private TileSource tileSource = new OsmTileSource.Mapnik();
    private Image attrImage;
    private String attrTermsUrl;
    public static final Font ATTR_FONT = new Font("Arial", 0, 10);
    public static final Font ATTR_LINK_FONT;

    public JMapViewer() {
        this(new MemoryTileCache(), 4);
        new DefaultMapController(this);
    }

    public JMapViewer(TileCache tileCache, int n) {
        this.tileController = new TileController(this.tileSource, tileCache, this);
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapRectangleList = new LinkedList<MapRectangle>();
        this.mapMarkersVisible = true;
        this.mapRectanglesVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(this.tileSource.getTileSize(), this.tileSource.getTileSize()));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPositionByLatLon(50.0, 9.0, 3);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return super.getToolTipText(mouseEvent);
    }

    protected void initializeZoomSlider() {
        ImageIcon imageIcon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.add(this.zoomSlider);
        int n = 18;
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("images/plus.png"));
            this.zoomInButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, n, n);
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomIn();
            }
        });
        this.add(this.zoomInButton);
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("images/minus.png"));
            this.zoomOutButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + n, 155, n, n);
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomOut();
            }
        });
        this.add(this.zoomOutButton);
    }

    public void setDisplayPositionByLatLon(double d, double d2, int n) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), d, d2, n);
    }

    public void setDisplayPositionByLatLon(Point point, double d, double d2, int n) {
        int n2 = OsmMercator.LonToX(d2, n);
        int n3 = OsmMercator.LatToY(d, n);
        this.setDisplayPosition(point, n2, n3, n);
    }

    public void setDisplayPosition(int n, int n2, int n3) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point point, int n, int n2, int n3) {
        if (n3 > this.tileController.getTileSource().getMaxZoom() || n3 < 0) {
            return;
        }
        Point point2 = new Point();
        point2.x = n - point.x + this.getWidth() / 2;
        point2.y = n2 - point.y + this.getHeight() / 2;
        this.center = point2;
        this.setIgnoreRepaint(true);
        try {
            int n4 = this.zoom;
            this.zoom = n3;
            if (n4 != n3) {
                this.zoomChanged(n4);
            }
            if (this.zoomSlider.getValue() != n3) {
                this.zoomSlider.setValue(n3);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    public void setDisplayToFitMapMarkers() {
        int n;
        int n2;
        int n3;
        if (this.mapMarkerList == null || this.mapMarkerList.size() == 0) {
            return;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = this.tileController.getTileSource().getMaxZoom();
        for (MapMarker mapMarker : this.mapMarkerList) {
            n3 = OsmMercator.LonToX(mapMarker.getLon(), n8);
            n2 = OsmMercator.LatToY(mapMarker.getLat(), n8);
            n6 = Math.max(n6, n3);
            n7 = Math.max(n7, n2);
            n4 = Math.min(n4, n3);
            n5 = Math.min(n5, n2);
        }
        int n9 = Math.max(0, this.getHeight());
        int n10 = Math.max(0, this.getWidth());
        n3 = n8;
        n2 = n6 - n4;
        for (n = n7 - n5; n2 > n10 || n > n9; n2 >>= 1, n >>= 1) {
            --n3;
        }
        n2 = n4 + (n6 - n4) / 2;
        n = n5 + (n7 - n5) / 2;
        int n11 = 1 << n8 - n3;
        this.setDisplayPosition(n2 /= n11, n /= n11, n3);
    }

    public void setDisplayToFitMapRectangle() {
        int n;
        if (this.mapRectangleList == null || this.mapRectangleList.size() == 0) {
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = this.tileController.getTileSource().getMaxZoom();
        for (MapRectangle mapRectangle : this.mapRectangleList) {
            n4 = Math.max(n4, OsmMercator.LonToX(mapRectangle.getBottomRight().getLon(), n6));
            n5 = Math.max(n5, OsmMercator.LatToY(mapRectangle.getTopLeft().getLat(), n6));
            n2 = Math.min(n2, OsmMercator.LonToX(mapRectangle.getTopLeft().getLon(), n6));
            n3 = Math.min(n3, OsmMercator.LatToY(mapRectangle.getBottomRight().getLat(), n6));
        }
        int n7 = Math.max(0, this.getHeight());
        int n8 = Math.max(0, this.getWidth());
        int n9 = n6;
        int n10 = n4 - n2;
        for (n = n5 - n3; n10 > n8 || n > n7; n10 >>= 1, n >>= 1) {
            --n9;
        }
        n10 = n2 + (n4 - n2) / 2;
        n = n3 + (n5 - n3) / 2;
        int n11 = 1 << n6 - n9;
        this.setDisplayPosition(n10 /= n11, n /= n11, n9);
    }

    public Coordinate getPosition() {
        double d = OsmMercator.XToLon(this.center.x, this.zoom);
        double d2 = OsmMercator.YToLat(this.center.y, this.zoom);
        return new Coordinate(d2, d);
    }

    public Coordinate getPosition(Point point) {
        return this.getPosition(point.x, point.y);
    }

    public Coordinate getPosition(int n, int n2) {
        int n3 = this.center.x + n - this.getWidth() / 2;
        int n4 = this.center.y + n2 - this.getHeight() / 2;
        double d = OsmMercator.XToLon(n3, this.zoom);
        double d2 = OsmMercator.YToLat(n4, this.zoom);
        return new Coordinate(d2, d);
    }

    public Point getMapPosition(double d, double d2, boolean bl) {
        int n = OsmMercator.LonToX(d2, this.zoom);
        int n2 = OsmMercator.LatToY(d, this.zoom);
        if (bl && ((n -= this.center.x - this.getWidth() / 2) < 0 || (n2 -= this.center.y - this.getHeight() / 2) < 0 || n > this.getWidth() || n2 > this.getHeight())) {
            return null;
        }
        return new Point(n, n2);
    }

    public Point getMapPosition(double d, double d2) {
        return this.getMapPosition(d, d2, true);
    }

    public Point getMapPosition(Coordinate coordinate) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon());
        }
        return null;
    }

    public Point getMapPosition(Coordinate coordinate, boolean bl) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon(), bl);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        super.paintComponent(graphics);
        int n2 = 0;
        int n3 = this.tileSource.getTileSize();
        int n4 = this.center.x / n3;
        int n5 = this.center.y / n3;
        int n6 = this.center.x % n3;
        int n7 = this.center.y % n3;
        int n8 = this.getWidth() / 2;
        int n9 = this.getHeight() / 2;
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        int n12 = n6;
        int n13 = n3 - n6;
        int n14 = n7;
        int n15 = n3 - n7;
        boolean bl2 = n12 < n13;
        boolean bl3 = bl = n14 < n15;
        n2 = bl ? (bl2 ? 2 : 3) : (bl2 ? 1 : 0);
        int n16 = -n3;
        int n17 = -n3;
        int n18 = this.getWidth();
        int n19 = this.getHeight();
        boolean bl4 = true;
        int n20 = 0;
        while (bl4) {
            bl4 = false;
            for (n = 0; n < 4; ++n) {
                if (n % 2 == 0) {
                    ++n20;
                }
                for (int i = 0; i < n20; ++i) {
                    Tile tile;
                    if (n16 <= n10 && n10 <= n18 && n17 <= n11 && n11 <= n19 && (tile = this.tileController.getTile(n4, n5, this.zoom)) != null) {
                        bl4 = true;
                        tile.paint(graphics, n10, n11);
                        if (this.tileGridVisible) {
                            graphics.drawRect(n10, n11, n3, n3);
                        }
                    }
                    Point object = move[n2];
                    n10 += object.x * n3;
                    n11 += object.y * n3;
                    n4 += object.x;
                    n5 += object.y;
                }
                n2 = (n2 + 1) % move.length;
            }
        }
        n = n3 << this.zoom;
        graphics.drawRect(n8 - this.center.x, n9 - this.center.y, n, n);
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            for (MapRectangle mapRectangle : this.mapRectangleList) {
                Coordinate coordinate = mapRectangle.getTopLeft();
                Coordinate coordinate2 = mapRectangle.getBottomRight();
                if (coordinate == null || coordinate2 == null) continue;
                Point point = this.getMapPosition(coordinate.getLat(), coordinate.getLon(), false);
                Point point2 = this.getMapPosition(coordinate2.getLat(), coordinate2.getLon(), false);
                if (point == null || point2 == null) continue;
                mapRectangle.paint(graphics, point, point2);
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            for (MapMarker mapMarker : this.mapMarkerList) {
                this.paintMarker(graphics, mapMarker);
            }
        }
        this.paintAttribution(graphics);
    }

    protected void paintMarker(Graphics graphics, MapMarker mapMarker) {
        Point point = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon());
        if (point != null) {
            mapMarker.paint(graphics, point);
        }
    }

    public void moveMap(int n, int n2) {
        this.center.x += n;
        this.center.y += n2;
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point point) {
        this.setZoom(this.zoom + 1, point);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point point) {
        this.setZoom(this.zoom - 1, point);
    }

    public void setZoom(int n, Point point) {
        if (n > this.tileController.getTileSource().getMaxZoom() || n < this.tileController.getTileSource().getMinZoom() || n == this.zoom) {
            return;
        }
        Coordinate coordinate = this.getPosition(point);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPositionByLatLon(point, coordinate.getLat(), coordinate.getLon(), n);
    }

    public void setZoom(int n) {
        this.setZoom(n, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int n) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean bl) {
        this.tileGridVisible = bl;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean bl) {
        this.mapMarkersVisible = bl;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> list) {
        this.mapMarkerList = list;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapRectangleList(List<MapRectangle> list) {
        this.mapRectangleList = list;
        this.repaint();
    }

    public List<MapRectangle> getMapRectangleList() {
        return this.mapRectangleList;
    }

    public void addMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.add(mapMarker);
        this.repaint();
    }

    public void removeMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.remove(mapMarker);
        this.repaint();
    }

    public void addMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.add(mapRectangle);
        this.repaint();
    }

    public void removeMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.remove(mapRectangle);
        this.repaint();
    }

    public void setZoomContolsVisible(boolean bl) {
        this.zoomSlider.setVisible(bl);
        this.zoomInButton.setVisible(bl);
        this.zoomOutButton.setVisible(bl);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        boolean bl;
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        if (bl = tileSource.requiresAttribution()) {
            this.attrImage = tileSource.getAttributionImage();
            this.attrTermsUrl = tileSource.getTermsOfUseURL();
        } else {
            this.attrImage = null;
            this.attrTermsUrl = null;
        }
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean bl) {
        this.repaint();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean bl) {
        this.mapRectanglesVisible = bl;
        this.repaint();
    }

    @Override
    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileController.setTileLoader(tileLoader);
    }

    private void paintAttribution(Graphics graphics) {
        int n;
        int n2;
        if (!this.tileSource.requiresAttribution()) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(ATTR_LINK_FONT);
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds("Background Terms of Use", graphics);
        int n3 = (int)rectangle2D.getHeight() - 5;
        int n4 = this.getHeight() - n3;
        if (this.attrTermsUrl != null) {
            n2 = 2;
            n = this.getHeight() - n3;
            graphics.setColor(Color.black);
            graphics.drawString("Background Terms of Use", n2 + 1, n + 1);
            graphics.setColor(Color.white);
            graphics.drawString("Background Terms of Use", n2, n);
        }
        if (this.attrImage != null) {
            n2 = 2;
            n = this.attrImage.getHeight(null);
            int n5 = n4 - n - n3 - 5;
            graphics.drawImage(this.attrImage, n2, n5, null);
        }
        graphics.setFont(ATTR_FONT);
        Coordinate coordinate = this.getPosition(0, 0);
        Coordinate coordinate2 = this.getPosition(this.getWidth(), this.getHeight());
        String string = this.tileSource.getAttributionText(this.zoom, coordinate, coordinate2);
        Rectangle2D rectangle2D2 = graphics.getFontMetrics().getStringBounds(string, graphics);
        int n6 = this.getWidth() - (int)rectangle2D2.getWidth();
        int n7 = this.getHeight() - n3;
        graphics.setColor(Color.black);
        graphics.drawString(string, n6 + 1, n7 + 1);
        graphics.setColor(Color.white);
        graphics.drawString(string, n6, n7);
        graphics.setFont(font);
    }

    static {
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(hashMap);
    }
}

