/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseChangesetTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private Exception lastException;
    private Collection<Changeset> changesets;
    private ArrayList<Changeset> closedChangesets;

    public CloseChangesetTask(Collection<Changeset> collection) {
        super(I18n.tr("Closing changeset"), false);
        if (collection == null) {
            collection = new ArrayList<Changeset>();
        }
        this.changesets = collection;
        this.closedChangesets = new ArrayList();
    }

    @Override
    protected void cancel() {
        this.cancelled = true;
        OsmApi.getOsmApi().cancel();
    }

    @Override
    protected void finish() {
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChangesetCache.getInstance().update(CloseChangesetTask.this.closedChangesets);
            }
        });
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            for (Changeset changeset : this.changesets) {
                if (this.cancelled) {
                    return;
                }
                if (changeset == null || changeset.getId() <= 0 || !changeset.isOpen()) continue;
                this.getProgressMonitor().subTask(I18n.tr("Closing changeset {0}", changeset.getId()));
                OsmApi.getOsmApi().closeChangeset(changeset, this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.closedChangesets.add(changeset);
            }
        }
        catch (Exception exception) {
            if (this.cancelled) {
                return;
            }
            this.lastException = exception;
        }
    }
}

