/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTableModel
extends AbstractTableModel
implements TableModelListener,
SelectionChangedListener,
DataSetListener {
    private List<RelationMember> members = new ArrayList<RelationMember>();
    private List<WayConnectionType> connectionType = null;
    private DefaultListSelectionModel listSelectionModel;
    private CopyOnWriteArrayList<IMemberModelListener> listeners = new CopyOnWriteArrayList();
    private OsmDataLayer layer;

    public MemberTableModel(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
        this.addTableModelListener(this);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void register() {
        DataSet.addSelectionListener(this);
        this.getLayer().data.addDataSetListener(this);
    }

    public void unregister() {
        DataSet.removeSelectionListener(this);
        this.getLayer().data.removeDataSetListener(this);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (Main.main.getEditLayer() != this.layer) {
            return;
        }
        Collection<RelationMember> collection2 = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(collection2);
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(collection);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void primtivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void primtivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i).getMember() != tagsChangedEvent.getPrimitive()) continue;
            this.fireTableCellUpdated(i, 1);
        }
        this.setSelectedMembers(collection);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    public void addMemberModelListener(IMemberModelListener iMemberModelListener) {
        if (iMemberModelListener != null) {
            this.listeners.addIfAbsent(iMemberModelListener);
        }
    }

    public void removeMemberModelListener(IMemberModelListener iMemberModelListener) {
        this.listeners.remove(iMemberModelListener);
    }

    protected void fireMakeMemberVisible(int n) {
        for (IMemberModelListener iMemberModelListener : this.listeners) {
            iMemberModelListener.makeMemberVisible(n);
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.members.get(n).getRole();
            }
            case 1: {
                return this.members.get(n).getMember();
            }
            case 2: {
                return this.wayConnection(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = new RelationMember(object.toString(), relationMember.getMember());
        this.members.remove(n);
        this.members.add(n, relationMember2);
    }

    public OsmPrimitive getReferredPrimitive(int n) {
        return this.members.get(n).getMember();
    }

    public void moveUp(int[] nArray) {
        if (!this.canMoveUp(nArray)) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n - 1);
            this.members.set(n, relationMember2);
            this.members.set(n - 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(--n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] - 1);
    }

    public void moveDown(int[] nArray) {
        if (!this.canMoveDown(nArray)) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n + 1);
            this.members.set(n, relationMember2);
            this.members.set(n + 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(++n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] + 1);
    }

    public void remove(int[] nArray) {
        if (!this.canRemove(nArray)) {
            return;
        }
        int n = 0;
        for (int n2 : nArray) {
            this.members.remove(n2 -= n);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return nArray[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return this.members.size() > 0 && nArray[nArray.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] nArray) {
        return nArray != null && nArray.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        Iterator<RelationMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            RelationMember relationMember = iterator.next();
            if (!list.contains(relationMember.getMember())) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public Set<OsmPrimitive> getIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getSelectedIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncompleteSelectedMembers() {
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public void addMembersAtBeginning(List<OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(0, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.fireMakeMemberVisible(0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(this.members.size() - 1 - i, this.members.size() - 1 - i);
        }
        this.fireMakeMemberVisible(this.members.size() - 1);
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> list, int n) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(n, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(n + i, n + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(n);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> list, int n) {
        if (list == null) {
            return;
        }
        int n2 = 1;
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(n + n2, relationMember);
            ++n2;
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(n + 1 + i, n + 1 + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(n + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive osmPrimitive) {
        int n = 0;
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().equals(osmPrimitive)) continue;
            ++n;
        }
        return n;
    }

    public void updateRole(int[] nArray, String string) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = new RelationMember(string, relationMember.getMember());
            this.members.remove(n);
            this.members.add(n, relationMember2);
        }
        this.fireTableDataChanged();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (int n : this.getSelectedIndices()) {
            arrayList.add(this.members.get(n));
        }
        return arrayList;
    }

    public Collection<OsmPrimitive> getSelectedChildPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            arrayList.add(relationMember.getMember());
        }
        return arrayList;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return null;
        }
        for (RelationMember relationMember : this.members) {
            if (!collection.contains(relationMember.getMember())) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public void setSelectedMembers(Collection<RelationMember> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (RelationMember relationMember : collection) {
            int n = this.members.indexOf(relationMember);
            if (n < 0) continue;
            hashSet.add(n);
        }
        this.setSelectedMembersIdx(hashSet);
    }

    public void setSelectedMembersIdx(Collection<Integer> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : collection) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (collection.size() > 0) {
            this.fireMakeMemberVisible(Collections.min(collection));
        }
    }

    public boolean isEditableRelation(int n) {
        if (n < 0 || n >= this.members.size()) {
            return false;
        }
        RelationMember relationMember = this.members.get(n);
        if (!relationMember.isRelation()) {
            return false;
        }
        Relation relation = relationMember.getRelation();
        return !relation.isIncomplete();
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember primitiveId : this.members) {
            hashSet.add(primitiveId.getMember());
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!hashSet.contains(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember relationMember = this.members.get(i);
            if (!collection.contains(relationMember.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.getSelectedIndices().size() > 0) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    public boolean isInJosmSelection(OsmPrimitive osmPrimitive) {
        return this.layer.data.isSelected(osmPrimitive);
    }

    protected boolean isActiveLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    private static Node getUnusedNode(RelationMember relationMember, RelationMember relationMember2) {
        Node node = null;
        if (relationMember.isWay()) {
            Way way = relationMember.getWay();
            if (relationMember2.isWay()) {
                Way way2 = relationMember2.getWay();
                node = way.firstNode() == way2.firstNode() || way.firstNode() == way2.lastNode() ? way.lastNode() : way.firstNode();
            } else if (relationMember2.isNode()) {
                Node node2 = relationMember2.getNode();
                node = way.firstNode() == node2 ? way.lastNode() : way.firstNode();
            }
        } else if (relationMember.isNode()) {
            Node node3;
            node = node3 = relationMember.getNode();
        }
        return node;
    }

    private List<RelationMember> sortMembers(List<RelationMember> list) {
        Serializable serializable;
        LinkedList<Serializable> linkedList;
        Integer n;
        RelationNodeMap relationNodeMap = new RelationNodeMap(list);
        ArrayList arrayList = new ArrayList();
        while ((n = relationNodeMap.pop()) != null) {
            linkedList = new LinkedList<Serializable>();
            linkedList.add(n);
            arrayList.add(linkedList);
            serializable = n;
            while ((serializable = relationNodeMap.popAdjacent((Integer)serializable)) != null) {
                linkedList.addLast(serializable);
            }
            serializable = n;
            while ((serializable = relationNodeMap.popAdjacent((Integer)serializable)) != null) {
                linkedList.addFirst(serializable);
            }
        }
        linkedList = new LinkedList();
        linkedList.addAll(relationNodeMap.getNotSortableMembers());
        arrayList.add(linkedList);
        serializable = new ArrayList();
        for (LinkedList linkedList2 : arrayList) {
            for (Integer n2 : linkedList2) {
                ((ArrayList)serializable).add(list.get(n2));
            }
        }
        return serializable;
    }

    void sort() {
        List<RelationMember> list;
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.getSelectedMembers());
        List<RelationMember> list2 = null;
        if (arrayList.size() <= 1) {
            list2 = list = this.sortMembers(this.members);
        } else {
            list2 = this.sortMembers(arrayList);
            List<Integer> list3 = this.getSelectedIndices();
            list = new ArrayList<RelationMember>();
            boolean bl = false;
            for (int i = 0; i < this.members.size(); ++i) {
                if (list3.contains(i)) {
                    if (bl) continue;
                    list.addAll(list2);
                    bl = true;
                    continue;
                }
                list.add(this.members.get(i));
            }
        }
        if (this.members.size() != list.size()) {
            throw new AssertionError();
        }
        this.members.clear();
        this.members.addAll(list);
        this.fireTableDataChanged();
        this.setSelectedMembers(list2);
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2) {
        if (n < 0 || n2 < 0 || n >= this.members.size() || n2 >= this.members.size()) {
            return WayConnectionType.Direction.NONE;
        }
        if (direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = this.members.get(n2);
        Way way = null;
        Way way2 = null;
        if (relationMember.isWay()) {
            way = relationMember.getWay();
        }
        if (relationMember2.isWay()) {
            way2 = relationMember2.getWay();
        }
        if (way == null || way2 == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Object> list = new ArrayList<Node>();
        switch (direction) {
            case FORWARD: {
                list.add(way.lastNode());
                break;
            }
            case BACKWARD: {
                list.add(way.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                list = way.getNodes();
            }
        }
        if (list == null) {
            return WayConnectionType.Direction.NONE;
        }
        for (Node node : list) {
            if (node == null) continue;
            if (this.roundaboutType(n2) != WayConnectionType.Direction.NONE) {
                for (Node node2 : way2.getNodes()) {
                    if (node != node2) continue;
                    return this.roundaboutType(n2);
                }
                continue;
            }
            if (node == way2.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (node != way2.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType.Direction roundaboutType(int n) {
        RelationMember relationMember = this.members.get(n);
        if (relationMember == null || !relationMember.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        Way way = relationMember.getWay();
        return MemberTableModel.roundaboutType(way);
    }

    static WayConnectionType.Direction roundaboutType(Way way) {
        if (way != null && "roundabout".equals(way.get("junction")) && way.getNodesCount() < 200 && way.getNodesCount() > 2 && way.getNode(0) != null && way.getNode(1) != null && way.getNode(2) != null && way.firstNode() == way.lastNode()) {
            EastNorth eastNorth = way.getNode(0).getEastNorth();
            EastNorth eastNorth2 = way.getNode(1).getEastNorth();
            EastNorth eastNorth3 = way.getNode(2).getEastNorth();
            eastNorth = eastNorth.sub(eastNorth2);
            eastNorth2 = eastNorth2.sub(eastNorth3);
            return eastNorth.north() * eastNorth2.east() - eastNorth2.north() * eastNorth.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType wayConnection(int n) {
        if (this.connectionType == null) {
            this.updateLinks();
        }
        return this.connectionType.get(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.connectionType = null;
    }

    void reverse() {
        List<Integer> list = this.getSelectedIndices();
        List<Integer> list2 = this.getSelectedIndices();
        if (list.size() <= 1) {
            Collections.reverse(this.members);
            this.fireTableDataChanged();
            this.setSelectedMembers(this.members);
        } else {
            Collections.reverse(list2);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.members);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.set(list.get(i), this.members.get(list2.get(i)));
            }
            if (this.members.size() != arrayList.size()) {
                throw new AssertionError();
            }
            this.members.clear();
            this.members.addAll(arrayList);
            this.fireTableDataChanged();
            this.setSelectedMembersIdx(list);
        }
    }

    public void updateLinks() {
        int n;
        this.connectionType = null;
        ArrayList<WayConnectionType> arrayList = new ArrayList<WayConnectionType>();
        for (n = 0; n < this.members.size(); ++n) {
            arrayList.add(null);
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < this.members.size(); ++i) {
            boolean bl2;
            boolean bl3;
            WayConnectionType.Direction direction;
            boolean bl4;
            RelationMember relationMember;
            if (bl) {
                n = i;
                bl = false;
            }
            if (!(relationMember = this.members.get(i)).isWay()) {
                arrayList.set(i, new WayConnectionType());
                bl = true;
                continue;
            }
            Way way = relationMember.getWay();
            if (way == null || way.isIncomplete()) {
                arrayList.set(i, new WayConnectionType());
                bl = true;
                continue;
            }
            boolean bl5 = bl4 = i != n;
            if (bl4) {
                direction = this.determineDirection(i - 1, arrayList.get((int)(i - 1)).direction, i);
                bl3 = this.determineDirection(i, direction, i + 1) != WayConnectionType.Direction.NONE;
            } else {
                if (this.roundaboutType(i) != WayConnectionType.Direction.NONE) {
                    direction = this.determineDirection(i, this.roundaboutType(i), i + 1) != WayConnectionType.Direction.NONE ? this.roundaboutType(i) : WayConnectionType.Direction.NONE;
                } else {
                    WayConnectionType.Direction direction2 = direction = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i + 1) != WayConnectionType.Direction.NONE ? WayConnectionType.Direction.FORWARD : WayConnectionType.Direction.NONE;
                    if (direction == WayConnectionType.Direction.NONE) {
                        direction = this.determineDirection(i, WayConnectionType.Direction.BACKWARD, i + 1) != WayConnectionType.Direction.NONE ? WayConnectionType.Direction.BACKWARD : WayConnectionType.Direction.NONE;
                    }
                }
                boolean bl6 = bl3 = direction != WayConnectionType.Direction.NONE;
                if (direction == WayConnectionType.Direction.NONE && this.roundaboutType(i) != WayConnectionType.Direction.NONE) {
                    direction = this.roundaboutType(i);
                }
            }
            arrayList.set(i, new WayConnectionType(bl4, bl3, direction));
            if (bl3) continue;
            if (i == n) {
                bl2 = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i) == WayConnectionType.Direction.FORWARD;
            } else {
                boolean bl7 = bl2 = this.determineDirection(i, direction, n) == arrayList.get((int)n).direction;
            }
            if (bl2) {
                for (int j = n; j <= i; ++j) {
                    arrayList.get((int)j).isLoop = true;
                }
            }
            bl = true;
        }
        this.connectionType = arrayList;
    }
}

