/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected Collection<OsmPrimitive> primitives;
    protected JTextArea textArea;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> collection) {
        super(Main.parent, I18n.tr("Advanced object info"), new String[]{"Close"});
        this.primitives = collection;
        this.setPreferredSize(new Dimension(450, 350));
        this.setButtonIcons(new String[]{"ok.png"});
        JPanel jPanel = this.buildPanel();
        this.textArea.setText(this.buildText());
        this.setContent(jPanel, false);
    }

    protected JPanel buildPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", this.textArea.getFont().getStyle(), this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add((Component)jScrollPane, GBC.std().fill());
        return jPanel;
    }

    protected String buildText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.nodePredicate)) {
            stringBuilder.append("Node id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addWayReferrer(stringBuilder, (Node)osmPrimitive);
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" lat=%s lon=%s (projected: x=%s, y=%s); ", Double.toString(((Node)osmPrimitive).getCoor().lat()), Double.toString(((Node)osmPrimitive).getCoor().lon()), Double.toString(((Node)osmPrimitive).getEastNorth().east()), Double.toString(((Node)osmPrimitive).getEastNorth().north())));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addWayReferrer(stringBuilder, (Node)osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.wayPredicate)) {
            stringBuilder.append("Way id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" %d nodes; ", ((Way)osmPrimitive).getNodes().size()));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append("  nodes:\n");
            for (Node primitiveId : ((Way)osmPrimitive).getNodes()) {
                stringBuilder.append(String.format("    %d\n", primitiveId.getUniqueId()));
            }
            stringBuilder.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.relationPredicate)) {
            stringBuilder.append("Relation id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" %d members; ", ((Relation)osmPrimitive).getMembersCount()));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append("  members:\n");
            for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                stringBuilder.append(String.format("    %d %s\n", relationMember.getMember().getUniqueId(), relationMember.getRole()));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }

    protected void addCommon(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        stringBuilder.append(String.format("Data set: %X; User: [%s]; ChangeSet id: %H; Timestamp: %s, Version: %d", osmPrimitive.getDataSet().hashCode(), this.userString(osmPrimitive.getUser()), osmPrimitive.getChangesetId(), DateUtils.fromDate(osmPrimitive.getTimestamp()), osmPrimitive.getVersion()));
        if (osmPrimitive.isDeleted()) {
            stringBuilder.append("; deleted");
        }
        if (!osmPrimitive.isVisible()) {
            stringBuilder.append("; deleted-on-server");
        }
        if (osmPrimitive.isModified()) {
            stringBuilder.append("; modified");
        }
        if (osmPrimitive.isDisabledAndHidden()) {
            stringBuilder.append("; filtered/hidden");
        }
        if (osmPrimitive.isDisabled()) {
            stringBuilder.append("; filtered/disabled");
        }
        if (osmPrimitive.hasDirectionKeys()) {
            stringBuilder.append("; has direction keys");
            if (osmPrimitive.reversedDirection()) {
                stringBuilder.append(" (reversed)");
            }
        }
        stringBuilder.append("\n");
    }

    protected void addAttributes(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        if (osmPrimitive.hasKeys()) {
            stringBuilder.append("  tags:\n");
            for (String string : osmPrimitive.keySet()) {
                stringBuilder.append(String.format("    \"%s\"=\"%s\"\n", string, osmPrimitive.get(string)));
            }
        }
    }

    protected void addWayReferrer(StringBuilder stringBuilder, Node node) {
        List<OsmPrimitive> list = node.getReferrers();
        DatasetCollection datasetCollection = new DatasetCollection(list, OsmPrimitive.wayPredicate);
        if (datasetCollection.size() > 0) {
            stringBuilder.append("  way referrer:\n");
            for (Way way : datasetCollection) {
                stringBuilder.append("    " + way.getUniqueId() + "\n");
            }
        }
    }

    protected void addRelationReferrer(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        DatasetCollection datasetCollection = new DatasetCollection(list, OsmPrimitive.relationPredicate);
        if (datasetCollection.size() > 0) {
            stringBuilder.append("  relation referrer:\n");
            for (Relation relation : datasetCollection) {
                stringBuilder.append("    " + relation.getUniqueId() + "\n");
            }
        }
    }

    protected boolean checkDataSet(OsmPrimitive osmPrimitive) {
        DataSet dataSet = osmPrimitive.getDataSet();
        if (dataSet == null) {
            return false;
        }
        return dataSet.getPrimitiveById(osmPrimitive) != null;
    }

    protected String userString(User user) {
        if (user == null) {
            return "<null>";
        }
        ArrayList<String> arrayList = user.getNames();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id:" + user.getId());
        if (arrayList.size() == 1) {
            stringBuilder.append(" name:" + user.getName());
        } else if (arrayList.size() > 1) {
            stringBuilder.append(String.format(" %d names:%s", arrayList.size(), user.getName()));
        }
        return stringBuilder.toString();
    }
}

