/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    protected static int WRONGLY_ORDERED_COAST = 1001;
    protected static int WRONGLY_ORDERED_WATER = 1002;
    protected static int WRONGLY_ORDERED_LAND = 1003;

    public WronglyOrderedWays() {
        super(I18n.tr("Wrongly Ordered Ways."), I18n.tr("This test checks the direction of water, land and coastline ways."));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
    }

    public void endTest() {
        super.endTest();
    }

    public void visit(Way way) {
        int n;
        String string = "";
        if (!way.isUsable()) {
            return;
        }
        if (way.getNodesCount() <= 0) {
            return;
        }
        String string2 = way.get("natural");
        if (string2 == null) {
            return;
        }
        if (string2.equals("coastline")) {
            string = I18n.tr("Reversed coastline: land not on left side");
            n = WRONGLY_ORDERED_COAST;
        } else if (string2.equals("water")) {
            string = I18n.tr("Reversed water: land not on left side");
            n = WRONGLY_ORDERED_WATER;
        } else if (string2.equals("land")) {
            string = I18n.tr("Reversed land: land not on left side");
            n = WRONGLY_ORDERED_LAND;
        } else {
            return;
        }
        if (way.getNode(0) == way.getNode(way.getNodesCount() - 1)) {
            double d = 0.0;
            for (int i = 1; i < way.getNodesCount(); ++i) {
                d += way.getNode(i - 1).getCoor().lon() * way.getNode(i).getCoor().lat() - way.getNode(i).getCoor().lon() * way.getNode(i - 1).getCoor().lat();
            }
            if ((string2.equals("coastline") || string2.equals("land")) && d < 0.0 || string2.equals("water") && d > 0.0) {
                ArrayList<Way> arrayList = new ArrayList<Way>();
                arrayList.add(way);
                this.errors.add(new TestError((Test)this, Severity.OTHER, string, n, arrayList));
            }
        }
    }
}

