/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About"), "about", I18n.tr("Display the about screen."), Shortcut.registerShortcut("system:about", I18n.tr("About"), 112, 5, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(Version.loadResourceFile(Main.class.getResource("/README")));
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setEditable(false);
        jTextArea2.setText(Version.loadResourceFile(Main.class.getResource("/CONTRIBUTION")));
        JTextArea jTextArea3 = new JTextArea();
        jTextArea3.setEditable(false);
        jTextArea3.setText(Version.loadResourceFile(Main.class.getResource("/LICENSE")));
        Version version = Version.getInstance();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        jLabel.setFont(new Font("Helvetica", 1, 20));
        jPanel.add((Component)jLabel, GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Version {0}", version.getVersionString())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Last change at {0}", version.getTime())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Java Version {0}", System.getProperty("java.version"))), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Homepage")), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de"), GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Bug Reports")), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eol().fill(2));
        JTextArea jTextArea4 = new JTextArea();
        jTextArea4.setEditable(false);
        jTextArea4.setText(version.getReleaseAttributes());
        jTabbedPane.addTab(I18n.tr("Info"), jPanel);
        jTabbedPane.addTab(I18n.tr("Readme"), this.createScrollPane(jTextArea));
        jTabbedPane.addTab(I18n.tr("Revision"), this.createScrollPane(jTextArea4));
        jTabbedPane.addTab(I18n.tr("Contribution"), this.createScrollPane(jTextArea2));
        jTabbedPane.addTab(I18n.tr("License"), this.createScrollPane(jTextArea3));
        jTabbedPane.addTab(I18n.tr("Plugins"), new JScrollPane(PluginHandler.getInfoPanel()));
        jTabbedPane.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(Main.parent, jTabbedPane, I18n.tr("About JOSM..."), 1, ImageProvider.get("logo"));
    }

    private JScrollPane createScrollPane(JTextArea jTextArea) {
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }
}

