/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    private static final Logger logger = Logger.getLogger(OsmServerWriter.class.getName());
    private Collection<OsmPrimitive> processed;
    private OsmApi api = OsmApi.getOsmApi();
    private boolean canceled = false;
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        float f = (float)n / (float)l2;
        float f2 = n2 - n;
        int n3 = (int)(f2 / f);
        int n4 = n3 / 60000;
        int n5 = n3 / 1000 % 60;
        String string = Integer.toString(n4) + ":";
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n5);
        return string;
    }

    protected void uploadChangesIndividually(Collection<OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ..."));
            progressMonitor.setTicksCount(collection.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = progressMonitor.getTicks();
                String string = this.timeLeft(n, collection.size());
                String string2 = "";
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                    }
                }
                progressMonitor.subTask(I18n.tr(string2, Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string, osmPrimitive.getName() == null ? Long.valueOf(osmPrimitive.getId()) : osmPrimitive.getName(), osmPrimitive.getId()));
                this.makeApiRequest(osmPrimitive, progressMonitor);
                this.processed.add(osmPrimitive);
                progressMonitor.worked(1);
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ..."));
            this.processed.addAll(this.api.uploadDiff(collection, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesInChunks(Collection<OsmPrimitive> collection, ProgressMonitor progressMonitor, int n) throws OsmTransferException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Value >0 expected for parameter ''{0}'', got {1}", "chunkSize", n));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in chunks..."));
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(n);
            Iterator<OsmPrimitive> iterator = collection.iterator();
            int n2 = (int)Math.ceil((double)collection.size() / (double)n);
            int n3 = 0;
            while (iterator.hasNext()) {
                ++n3;
                if (this.canceled) {
                    return;
                }
                arrayList.clear();
                for (int i = 0; iterator.hasNext() && i < n; ++i) {
                    if (this.canceled) {
                        return;
                    }
                    arrayList.add(iterator.next());
                }
                progressMonitor.setCustomText(I18n.trn("({0}/{1}) Uploading {2} object...", "({0}/{1}) Uploading {2} objects...", arrayList.size(), n3, n2, arrayList.size()));
                this.processed.addAll(this.api.uploadDiff(arrayList, progressMonitor.createSubTaskMonitor(-1, false)));
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uploadOsm(UploadStrategySpecification uploadStrategySpecification, Collection<OsmPrimitive> collection, Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.processed = new LinkedList<OsmPrimitive>();
        progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        progressMonitor.beginTask(I18n.tr("Uploading data ..."));
        try {
            this.api.initialize(progressMonitor);
            if (changeset.getId() == 0) {
                this.api.openChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
            } else {
                this.api.updateChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            switch (uploadStrategySpecification.getStrategy()) {
                case SINGLE_REQUEST_STRATEGY: {
                    this.uploadChangesAsDiffUpload(collection, progressMonitor.createSubTaskMonitor(0, false));
                    return;
                }
                case INDIVIDUAL_OBJECTS_STRATEGY: {
                    this.uploadChangesIndividually(collection, progressMonitor.createSubTaskMonitor(0, false));
                    return;
                }
                case CHUNKED_DATASET_STRATEGY: {
                    this.uploadChangesInChunks(collection, progressMonitor.createSubTaskMonitor(0, false), uploadStrategySpecification.getChunkSize());
                    return;
                }
            }
            return;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            progressMonitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osmPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osmPrimitive.isDeleted()) {
            this.api.deletePrimitive(osmPrimitive, progressMonitor);
        } else if (osmPrimitive.isNew()) {
            this.api.createPrimitive(osmPrimitive, progressMonitor);
        } else {
            this.api.modifyPrimitive(osmPrimitive, progressMonitor);
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }
}

