/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.TileSelectionBBoxChooser;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class TileSelection
implements DownloadSelection,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TileSelection.class.getName());
    private TileSelectionBBoxChooser chooser;
    private DownloadDialog parent;

    protected void build() {
        this.chooser = new TileSelectionBBoxChooser();
        this.chooser.addPropertyChangeListener(this);
    }

    public TileSelection() {
        this.build();
    }

    public void addGui(DownloadDialog downloadDialog) {
        downloadDialog.addDownloadAreaSelector(this.chooser, I18n.tr("Tile Numbers"));
        this.parent = downloadDialog;
    }

    public void setDownloadArea(Bounds bounds) {
        this.chooser.setBoundingBox(bounds);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(BBoxChooser.BBOX_PROP)) {
            Bounds bounds = (Bounds)propertyChangeEvent.getNewValue();
            this.parent.boundingBoxChanged(bounds, this);
        }
    }
}

