/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RelationListDialog
extends ToggleDialog
implements DataSetListener {
    private JList displaylist;
    private RelationListModel model;
    private EditAction editAction;
    private DeleteAction deleteAction;
    private NewAction newAction;
    private RelationDialogPopupMenu popupMenu;

    public RelationListDialog() {
        super(I18n.tr("Relations"), "relationlist", I18n.tr("Open a list of all relations."), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations")), 82, 4, 1), 150);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new RelationListModel(defaultListSelectionModel);
        this.displaylist = new JList(this.model);
        this.displaylist.setSelectionModel(defaultListSelectionModel);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer(){

            protected String getComponentToolTipText(OsmPrimitive osmPrimitive) {
                return null;
            }
        });
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseEventHandler());
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel jPanel = this.getButtonPanel(5);
        this.newAction = new NewAction();
        jPanel.add(new SideButton((Action)this.newAction, false));
        this.editAction = new EditAction();
        this.displaylist.addListSelectionListener(this.editAction);
        jPanel.add(new SideButton((Action)this.editAction, false));
        DuplicateAction duplicateAction = new DuplicateAction();
        this.displaylist.addListSelectionListener(duplicateAction);
        jPanel.add(new SideButton((Action)duplicateAction, false));
        this.deleteAction = new DeleteAction();
        this.displaylist.addListSelectionListener(this.deleteAction);
        jPanel.add(new SideButton((Action)this.deleteAction, false));
        SelectAction selectAction = new SelectAction();
        this.displaylist.addListSelectionListener(selectAction);
        jPanel.add(new SideButton((Action)selectAction, false));
        this.add((Component)jPanel, "South");
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteRelation");
        this.displaylist.getActionMap().put("deleteRelation", this.deleteAction);
        this.popupMenu = new RelationDialogPopupMenu();
    }

    public void showNotify() {
        MapView.addLayerChangeListener(this.newAction);
        this.newAction.updateEnabledState();
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
        this.dataChanged(null);
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener(this.newAction);
        DatasetEventManager.getInstance().removeDatasetListener(this);
    }

    protected void initFromLayer(Layer layer) {
        if (layer == null || !(layer instanceof OsmDataLayer)) {
            this.model.setRelations(null);
            return;
        }
        OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
        this.model.setRelations(osmDataLayer.data.getRelations());
        this.model.updateTitle();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.removeListSelectionListener(listSelectionListener);
    }

    private Relation getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        if (relation == null) {
            this.model.setSelectedRelations(null);
        } else {
            this.model.setSelectedRelations(Collections.singletonList(relation));
            Integer n = this.model.getRelationIndex(relation);
            if (n != null) {
                this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(n, n));
            }
        }
    }

    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    public void primtivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        this.model.addRelations(primitivesAddedEvent.getPrimitives());
        this.model.updateTitle();
    }

    public void primtivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.model.removeRelations(primitivesRemovedEvent.getPrimitives());
        this.model.updateTitle();
    }

    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        List<Relation> list = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(list);
        this.displaylist.repaint();
    }

    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        OsmPrimitive osmPrimitive = tagsChangedEvent.getPrimitive();
        if (osmPrimitive == null || !(osmPrimitive instanceof Relation)) {
            return;
        }
        List<Relation> list = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(list);
        this.displaylist.repaint();
    }

    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.initFromLayer(Main.main.getEditLayer());
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    class RelationDialogPopupMenu
    extends JPopupMenu {
        protected void build() {
            DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(downloadMembersAction);
            this.add(downloadMembersAction);
            DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(downloadSelectedIncompleteMembersAction);
            this.add(downloadSelectedIncompleteMembersAction);
            this.addSeparator();
            SelectMembersAction selectMembersAction = new SelectMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(selectMembersAction);
            this.add(selectMembersAction);
        }

        public RelationDialogPopupMenu() {
            this.build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationListModel
    extends AbstractListModel {
        private final ArrayList<Relation> relations = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public RelationListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public Relation getRelation(int n) {
            return this.relations.get(n);
        }

        public void sort() {
            Collections.sort(this.relations, new Comparator<Relation>(){
                NameFormatter formatter = DefaultNameFormatter.getInstance();

                @Override
                public int compare(Relation relation, Relation relation2) {
                    return relation.getDisplayName(this.formatter).compareTo(relation2.getDisplayName(this.formatter));
                }
            });
        }

        private boolean isValid(Relation relation) {
            return !relation.isDeleted() && relation.isVisible() && !relation.isIncomplete();
        }

        public void setRelations(Collection<Relation> collection) {
            List<Relation> list = this.getSelectedRelations();
            this.relations.clear();
            if (collection == null) {
                this.selectionModel.clearSelection();
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            for (Relation relation : collection) {
                if (!this.isValid(relation)) continue;
                this.relations.add(relation);
            }
            this.sort();
            this.fireIntervalAdded(this, 0, this.getSize());
            this.setSelectedRelations(list);
        }

        public void addRelations(Collection<? extends OsmPrimitive> collection) {
            boolean bl = false;
            for (OsmPrimitive osmPrimitive : collection) {
                Relation relation;
                if (!(osmPrimitive instanceof Relation) || this.relations.contains(relation = (Relation)osmPrimitive) || !this.isValid(relation)) continue;
                this.relations.add(relation);
                bl = true;
            }
            if (bl) {
                List<Relation> list = this.getSelectedRelations();
                this.sort();
                this.fireIntervalAdded(this, 0, this.getSize());
                this.setSelectedRelations(list);
            }
        }

        public void removeRelations(Collection<? extends OsmPrimitive> collection) {
            if (collection == null) {
                return;
            }
            HashSet<Relation> hashSet = new HashSet<Relation>();
            for (OsmPrimitive object : collection) {
                if (!(object instanceof Relation)) continue;
                hashSet.add((Relation)object);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            int n = this.relations.size();
            this.relations.removeAll(hashSet);
            if (n != this.relations.size()) {
                List<Relation> list = this.getSelectedRelations();
                this.sort();
                this.fireContentsChanged(this, 0, this.getSize());
                this.setSelectedRelations(list);
            }
        }

        public List<Relation> getSelectedRelationsWithIncompleteMembers() {
            List<Relation> list = this.getSelectedNonNewRelations();
            Iterator<Relation> iterator = list.iterator();
            while (iterator.hasNext()) {
                Relation relation = iterator.next();
                if (relation.hasIncompleteMembers()) continue;
                iterator.remove();
            }
            return list;
        }

        @Override
        public Object getElementAt(int n) {
            return this.relations.get(n);
        }

        @Override
        public int getSize() {
            return this.relations.size();
        }

        public List<Relation> getSelectedNonNewRelations() {
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i) || this.relations.get(i).isNew()) continue;
                arrayList.add(this.relations.get(i));
            }
            return arrayList;
        }

        public List<Relation> getSelectedRelations() {
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.relations.get(i));
            }
            return arrayList;
        }

        public void setSelectedRelations(List<Relation> list) {
            this.selectionModel.clearSelection();
            if (list == null || list.isEmpty()) {
                return;
            }
            for (Relation relation : list) {
                int n = this.relations.indexOf(relation);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public Integer getRelationIndex(Relation relation) {
            int n = this.relations.indexOf(relation);
            if (n < 0) {
                return null;
            }
            return n;
        }

        public void updateTitle() {
            if (this.getSize() > 0) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}", this.getSize()));
            } else {
                RelationListDialog.this.setTitle(I18n.tr("Relations"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members"));
            this.updateEnabledState();
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(List<Relation> list) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (Relation relation : list) {
                hashSet.addAll(relation.getIncompleteMembers());
            }
            return hashSet;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> list = RelationListDialog.this.model.getSelectedRelationsWithIncompleteMembers();
            if (list.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(list, this.buildSetOfIncompleteMembers(list), Main.map.mapView.getEditLayer()));
        }

        protected void updateEnabledState() {
            this.setEnabled(!RelationListDialog.this.model.getSelectedRelationsWithIncompleteMembers().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download all members of the selected relations"));
            this.putValue("Name", I18n.tr("Download members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "downloadincomplete"));
            this.putValue("help", HelpUtil.ht("/Dialog/RelationList#DownloadMembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(!RelationListDialog.this.model.getSelectedNonNewRelations().isEmpty());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<Relation> list = RelationListDialog.this.model.getSelectedNonNewRelations();
            if (list.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationTask(RelationListDialog.this.model.getSelectedNonNewRelations(), Main.map.mapView.getEditLayer()));
        }
    }

    class SelectMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select the members of all selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("selectall"));
            this.putValue("Name", I18n.tr("Select members"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> list = RelationListDialog.this.model.getSelectedRelations();
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (Relation relation : list) {
                hashSet.addAll(relation.getMemberPrimitives());
            }
            Main.map.mapView.getEditLayer().data.setSelected(hashSet);
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("ShortDescription", I18n.tr("Set the current selection to the list of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = RelationListDialog.this.displaylist.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(nArray.length);
            for (int n : nArray) {
                arrayList.add(RelationListDialog.this.model.getRelation(n));
            }
            Main.map.mapView.getEditLayer().data.setSelected(arrayList);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }

    class DuplicateAction
    extends AbstractAction
    implements ListSelectionListener {
        public DuplicateAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.updateEnabledState();
        }

        public void launchEditorForDuplicate(Relation relation) {
            Relation relation2 = new Relation(relation, true);
            relation2.setModified(true);
            RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation2, null);
            relationEditor.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditorForDuplicate(RelationListDialog.this.getSelected());
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class NewAction
    extends AbstractAction
    implements MapView.LayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "addrelation"));
            this.updateEnabledState();
        }

        public void run() {
            RelationEditor.getEditor(Main.main.getEditLayer(), null, null).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.setEnabled(false);
        }

        protected void deleteRelation(Relation relation) {
            if (relation == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation(Main.main.getEditLayer(), relation);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = RelationListDialog.this.displaylist.getSelectedIndices();
            ArrayList<Relation> arrayList = new ArrayList<Relation>(nArray.length);
            for (int n : nArray) {
                arrayList.add(RelationListDialog.this.model.getRelation(n));
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Relation relation = (Relation)object.next();
                this.deleteRelation(relation);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Open an editor for the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.setEnabled(false);
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation relation) {
            HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            Collection<OsmPrimitive> collection = Main.map.mapView.getEditLayer().data.getSelected();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
            return hashSet;
        }

        public void launchEditor(Relation relation) {
            if (relation == null) {
                return;
            }
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, this.getMembersForCurrentSelection(relation)).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditor(RelationListDialog.this.getSelected());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        MouseEventHandler() {
        }

        protected void setCurrentRelationAsSelection() {
            Main.main.getCurrentDataSet().setSelected((Relation)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            new EditAction().launchEditor(RelationListDialog.this.getSelected());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.isControlDown()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }

        private void openPopup(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = RelationListDialog.this.displaylist.locationToIndex(point);
            if (n < 0) {
                return;
            }
            if (!RelationListDialog.this.displaylist.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                return;
            }
            if (!RelationListDialog.this.displaylist.isSelectedIndex(n)) {
                RelationListDialog.this.displaylist.setSelectedIndex(n);
            }
            RelationListDialog.this.popupMenu.show(RelationListDialog.this.displaylist, point.x, point.y - 3);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.openPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.openPopup(mouseEvent);
            }
        }
    }
}

