/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected Collection<OsmPrimitive> primitives;
    protected JTextArea textArea;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> collection) {
        super(Main.parent, I18n.tr("Advanced object info"), new String[]{"Close"});
        this.primitives = collection;
        this.setPreferredSize(new Dimension(450, 350));
        this.setButtonIcons(new String[]{"ok.png"});
        JPanel jPanel = this.buildPanel();
        this.textArea.setText(this.buildText());
        this.setContent(jPanel, false);
    }

    protected JPanel buildPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", this.textArea.getFont().getStyle(), this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add((Component)jScrollPane, GBC.std().fill());
        return jPanel;
    }

    protected String buildText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.nodePredicate)) {
            stringBuffer.append("Node id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuffer.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuffer.append(" incomplete\n");
                this.addWayReferrer(stringBuffer, (Node)osmPrimitive);
                this.addRelationReferrer(stringBuffer, osmPrimitive);
                continue;
            }
            stringBuffer.append(String.format(" lat=%s; lon=%s; ", Double.toString(((Node)osmPrimitive).getCoor().lat()), Double.toString(((Node)osmPrimitive).getCoor().lon())));
            this.addCommon(stringBuffer, osmPrimitive);
            this.addAttributes(stringBuffer, osmPrimitive);
            this.addWayReferrer(stringBuffer, (Node)osmPrimitive);
            this.addRelationReferrer(stringBuffer, osmPrimitive);
            stringBuffer.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.wayPredicate)) {
            stringBuffer.append("Way id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuffer.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuffer.append(" incomplete\n");
                this.addRelationReferrer(stringBuffer, osmPrimitive);
                continue;
            }
            stringBuffer.append(String.format(" %d nodes; ", ((Way)osmPrimitive).getNodes().size()));
            this.addCommon(stringBuffer, osmPrimitive);
            this.addAttributes(stringBuffer, osmPrimitive);
            this.addRelationReferrer(stringBuffer, osmPrimitive);
            stringBuffer.append("  nodes:\n");
            for (Node primitiveId : ((Way)osmPrimitive).getNodes()) {
                stringBuffer.append(String.format("    %d\n", primitiveId.getUniqueId()));
            }
            stringBuffer.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new DatasetCollection(this.primitives, OsmPrimitive.relationPredicate)) {
            stringBuffer.append("Relation id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuffer.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuffer.append(" incomplete\n");
                this.addRelationReferrer(stringBuffer, osmPrimitive);
                continue;
            }
            stringBuffer.append(String.format(" %d members; ", ((Relation)osmPrimitive).getMembersCount()));
            this.addCommon(stringBuffer, osmPrimitive);
            this.addAttributes(stringBuffer, osmPrimitive);
            this.addRelationReferrer(stringBuffer, osmPrimitive);
            stringBuffer.append("  members:\n");
            for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                stringBuffer.append(String.format("    %d %s\n", relationMember.getMember().getUniqueId(), relationMember.getRole()));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString().trim();
    }

    protected void addCommon(StringBuffer stringBuffer, OsmPrimitive osmPrimitive) {
        stringBuffer.append(String.format("Data set: %X; User: [%s]; ChangeSet id: %H; Timestamp: %s, Version: %d", osmPrimitive.getDataSet().hashCode(), this.userString(osmPrimitive.getUser()), osmPrimitive.getChangesetId(), DateUtils.fromDate(osmPrimitive.getTimestamp()), osmPrimitive.getVersion()));
        if (osmPrimitive.isDeleted()) {
            stringBuffer.append("; deleted");
        }
        if (!osmPrimitive.isVisible()) {
            stringBuffer.append("; deleted-on-server");
        }
        if (osmPrimitive.isModified()) {
            stringBuffer.append("; modified");
        }
        if (osmPrimitive.isDisabledAndHidden()) {
            stringBuffer.append("; filtered/hidden");
        }
        if (osmPrimitive.isDisabled()) {
            stringBuffer.append("; filtered/disabled");
        }
        if (osmPrimitive.hasDirectionKeys()) {
            stringBuffer.append("; has direction keys");
            if (osmPrimitive.reversedDirection()) {
                stringBuffer.append(" (reversed)");
            }
        }
        stringBuffer.append("\n");
    }

    protected void addAttributes(StringBuffer stringBuffer, OsmPrimitive osmPrimitive) {
        if (osmPrimitive.hasKeys()) {
            stringBuffer.append("  tags:\n");
            for (String string : osmPrimitive.keySet()) {
                stringBuffer.append(String.format("    \"%s\"=\"%s\"\n", string, osmPrimitive.get(string)));
            }
        }
    }

    protected void addWayReferrer(StringBuffer stringBuffer, Node node) {
        List<OsmPrimitive> list = node.getReferrers();
        DatasetCollection datasetCollection = new DatasetCollection(list, OsmPrimitive.wayPredicate);
        if (datasetCollection.size() > 0) {
            stringBuffer.append("  way referrer:\n");
            for (Way way : datasetCollection) {
                stringBuffer.append("    " + way.getUniqueId() + "\n");
            }
        }
    }

    protected void addRelationReferrer(StringBuffer stringBuffer, OsmPrimitive osmPrimitive) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        DatasetCollection datasetCollection = new DatasetCollection(list, OsmPrimitive.relationPredicate);
        if (datasetCollection.size() > 0) {
            stringBuffer.append("  relation referrer:\n");
            for (Relation relation : datasetCollection) {
                stringBuffer.append("    " + relation.getUniqueId() + "\n");
            }
        }
    }

    protected boolean checkDataSet(OsmPrimitive osmPrimitive) {
        DataSet dataSet = osmPrimitive.getDataSet();
        if (dataSet == null) {
            return false;
        }
        return dataSet.getPrimitiveById(osmPrimitive) != null;
    }

    protected String userString(User user) {
        if (user == null) {
            return "<null>";
        }
        ArrayList<String> arrayList = user.getNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id:" + user.getId());
        if (arrayList.size() == 1) {
            stringBuffer.append(" name:" + user.getName());
        } else if (arrayList.size() > 1) {
            stringBuffer.append(String.format(" %d names:%s", arrayList.size(), user.getName()));
        }
        return stringBuffer.toString();
    }
}

