/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinePrimitiveResolverDialog
extends JDialog {
    private static CombinePrimitiveResolverDialog instance;
    private AutoAdjustingSplitPane spTagConflictTypes;
    private TagConflictResolver pnlTagConflictResolver;
    private RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private boolean cancelled;
    private JPanel pnlButtons;
    private OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private SideButton btnApply;

    public static CombinePrimitiveResolverDialog getInstance() {
        if (instance == null) {
            instance = new CombinePrimitiveResolverDialog(Main.parent);
        }
        return instance;
    }

    public OsmPrimitive getTargetPrimitmive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(OsmPrimitive osmPrimitive) {
        this.targetPrimitive = osmPrimitive;
        this.updateTitle();
        if (osmPrimitive instanceof Way) {
            this.pnlRelationMemberConflictResolver.initForWayCombining();
        } else if (osmPrimitive instanceof Node) {
            this.pnlRelationMemberConflictResolver.initForNodeMerging();
        }
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives"));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
        }
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver();
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver();
        return this.pnlRelationMemberConflictResolver;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.pnlTagConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.pnlRelationMemberConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.btnApply = new SideButton(applyAction);
        this.btnApply.setFocusable(true);
        jPanel.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        jPanel.add(new SideButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        jPanel.add(new SideButton(this.helpAction));
        return jPanel;
    }

    public CombinePrimitiveResolverDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.pnlTagConflictResolver.getModel();
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.pnlRelationMemberConflictResolver.getModel();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive osmPrimitive, TagCollection tagCollection) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (String string : tagCollection.getKeys()) {
            if (tagCollection.hasUniqueEmptyValue(string)) {
                if (osmPrimitive.get(string) == null) continue;
                linkedList.add(new ChangePropertyCommand(osmPrimitive, string, null));
                continue;
            }
            String string2 = tagCollection.getJoinedValues(string);
            if (string2.equals(osmPrimitive.get(string))) continue;
            linkedList.add(new ChangePropertyCommand(osmPrimitive, string, string2));
        }
        return linkedList;
    }

    public List<Command> buildResolutionCommands() {
        Command command;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        TagCollection tagCollection = this.getTagConflictResolverModel().getAllResolutions();
        if (tagCollection.size() > 0) {
            linkedList.addAll(this.buildTagChangeCommand(this.targetPrimitive, tagCollection));
        }
        if (this.targetPrimitive.get("created_by") != null) {
            linkedList.add(new ChangePropertyCommand(this.targetPrimitive, "created_by", null));
        }
        if (this.getRelationMemberConflictResolverModel().getNumDecisions() > 0) {
            linkedList.addAll(this.getRelationMemberConflictResolverModel().buildResolutionCommands(this.targetPrimitive));
        }
        if ((command = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.getRelationMemberConflictResolverModel().getModifiedRelations(this.targetPrimitive))) != null) {
            linkedList.add(command);
        }
        return linkedList;
    }

    protected void prepareDefaultTagDecisions() {
        TagConflictResolverModel tagConflictResolverModel = this.getTagConflictResolverModel();
        for (int i = 0; i < tagConflictResolverModel.getRowCount(); ++i) {
            MultiValueResolutionDecision multiValueResolutionDecision = tagConflictResolverModel.getDecision(i);
            List<String> list = multiValueResolutionDecision.getValues();
            list.remove("");
            if (list.size() == 1) {
                multiValueResolutionDecision.keepOne(list.get(0));
                continue;
            }
            multiValueResolutionDecision.keepAll();
        }
        tagConflictResolverModel.rebuild();
    }

    protected void prepareDefaultRelationDecisions() {
        RelationMemberConflictResolverModel relationMemberConflictResolverModel = this.getRelationMemberConflictResolverModel();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (int i = 0; i < relationMemberConflictResolverModel.getNumDecisions(); ++i) {
            RelationMemberConflictDecision relationMemberConflictDecision = relationMemberConflictResolverModel.getDecision(i);
            if (!hashSet.contains(relationMemberConflictDecision.getRelation())) {
                relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.KEEP);
                hashSet.add(relationMemberConflictDecision.getRelation());
                continue;
            }
            relationMemberConflictDecision.decide(RelationMemberConflictDecisionType.REMOVE);
        }
        relationMemberConflictResolverModel.refresh();
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultTagDecisions();
        this.prepareDefaultRelationDecisions();
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(new JLabel(I18n.tr("No conflicts to resolve")));
        return jPanel;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        RelationMemberConflictResolverModel relationMemberConflictResolverModel = this.getRelationMemberConflictResolverModel();
        TagConflictResolverModel tagConflictResolverModel = this.getTagConflictResolverModel();
        this.getContentPane().removeAll();
        if (relationMemberConflictResolverModel.getNumDecisions() > 0 && tagConflictResolverModel.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (relationMemberConflictResolverModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (tagConflictResolverModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        int n = this.getTagConflictResolverModel().getNumDecisions();
        int n2 = this.getRelationMemberConflictResolverModel().getNumDecisions();
        if (n > 0 && n2 > 0) {
            this.spTagConflictTypes.setDividerLocation(0.5);
        }
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.prepareGUIBeforeConflictResolutionStarts();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
            this.setCancelled(false);
            this.btnApply.requestFocusInWindow();
        } else {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    static class AutoAdjustingSplitPane
    extends JSplitPane
    implements PropertyChangeListener,
    HierarchyBoundsListener {
        private double dividerLocation;

        public AutoAdjustingSplitPane(int n) {
            super(n);
            this.addPropertyChangeListener("dividerLocation", this);
            this.addHierarchyBoundsListener(this);
        }

        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            this.setDividerLocation((int)(this.dividerLocation * (double)this.getHeight()));
        }

        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (this.getHeight() != 0) {
                    this.dividerLocation = (double)n / (double)this.getHeight();
                }
            }
        }
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            int n = CombinePrimitiveResolverDialog.this.getTagConflictResolverModel().getNumDecisions();
            int n2 = CombinePrimitiveResolverDialog.this.getRelationMemberConflictResolverModel().getNumDecisions();
            if (n > 0 && n2 > 0) {
                CombinePrimitiveResolverDialog.this.spTagConflictTypes.setDividerLocation(0.5);
            }
        }
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts"));
            this.putValue("Name", I18n.tr("Apply"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.getModel().getNumConflicts() == 0 && CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.getModel().getNumConflicts() == 0);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (propertyChangeEvent.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setCancelled(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

