/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<List<Node>> list;
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        List<Node> list2 = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list3 = OsmPrimitive.getFilteredList(collection, Way.class);
        List<Relation> list4 = OsmPrimitive.getFilteredList(collection, Relation.class);
        List<Way> list5 = this.getApplicableWays(list3, list2);
        if (list5 == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting - no node is selected."), I18n.tr("Warning"), 2);
            return;
        }
        if (list5.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."), I18n.tr("Warning"), 2);
            return;
        }
        Object object = list5.iterator();
        block0: while (object.hasNext()) {
            list = object.next();
            for (Node object2 : list2) {
                if (((Way)((Object)list)).isInnerNode(object2)) continue;
                object.remove();
                continue block0;
            }
        }
        if (list5.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", list2.size()), I18n.tr("Warning"), 2);
            return;
        }
        if (list5.size() > 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", list2.size()), I18n.tr("Warning"), 2);
            return;
        }
        object = list5.get(0);
        list = SplitWayAction.buildSplitChunks((Way)object, list2);
        if (list != null) {
            ArrayList arrayList = new ArrayList(list3.size() + list4.size());
            arrayList.addAll(list3);
            arrayList.addAll(list4);
            SplitWayResult splitWayResult = SplitWayAction.splitWay(this.getEditLayer(), (Way)object, list, arrayList);
            Main.main.undoRedo.add(splitWayResult.getCommand());
            this.getCurrentDataSet().setSelected(splitWayResult.getNewSelection());
        }
    }

    private List<Way> getApplicableWays(List<Way> list, List<Node> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>(OsmPrimitive.getFilteredList(list2.get(0).getReferrers(), Way.class));
        for (int i = 1; i < list2.size(); ++i) {
            Iterator iterator = arrayList.iterator();
            List<OsmPrimitive> list3 = list2.get(i).getReferrers();
            while (iterator.hasNext()) {
                if (list3.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((Way)iterator.next()).getNodesCount() > 2) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            return arrayList;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (list.contains(iterator.next())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public static List<List<Node>> buildSplitChunks(Way way, List<Node> list) {
        Object object;
        CheckParameterUtil.ensureParameterNotNull(way, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(list, "splitPoints");
        HashSet<Node> hashSet = new HashSet<Node>(list);
        LinkedList<List<Node>> linkedList = new LinkedList<List<Node>>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        linkedList.add(arrayList);
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = arrayList.isEmpty() || !iterator.hasNext();
            arrayList.add(object);
            if (!hashSet.contains(object) || bl) continue;
            arrayList = new ArrayList();
            arrayList.add(object);
            linkedList.add(arrayList);
        }
        object = (List)linkedList.get(linkedList.size() - 1);
        if (linkedList.size() >= 2 && ((List)linkedList.get(0)).get(0) == object.get(object.size() - 1) && !hashSet.contains(((List)linkedList.get(0)).get(0))) {
            if (linkedList.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
                return null;
            }
            object.remove(object.size() - 1);
            object.addAll((Collection)linkedList.get(0));
            linkedList.remove(linkedList.size() - 1);
            linkedList.set(0, (List<Node>)object);
        }
        if (linkedList.size() < 2) {
            if (((List)linkedList.get(0)).get(0) == ((List)linkedList.get(0)).get(((List)linkedList.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"), I18n.tr("Warning"), 2);
            }
            return null;
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    public static SplitWayResult splitWay(OsmDataLayer osmDataLayer, Way way, List<List<Node>> list, Collection<? extends OsmPrimitive> collection) {
        ArrayList<Command> arrayList = new ArrayList<Command>(list.size());
        ArrayList<? extends OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>(collection.size() + list.size());
        arrayList2.addAll(collection);
        Iterator<List<Node>> iterator = list.iterator();
        Way way2 = new Way(way);
        way2.setNodes(iterator.next());
        arrayList.add(new ChangeCommand(way, way2));
        if (!arrayList2.contains(way)) {
            arrayList2.add(way);
        }
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        while (iterator.hasNext()) {
            Way way3 = new Way();
            way3.setKeys(way.getKeys());
            arrayList3.add(way3);
            way3.setNodes(iterator.next());
            arrayList.add(new AddCommand(osmDataLayer, way3));
            arrayList2.add(way3);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Relation relation : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!relation.isUsable()) continue;
            Relation relation2 = null;
            String string = relation.get("type");
            if (string == null) {
                string = "";
            }
            int n = 0;
            int n2 = 0;
            List<RelationMember> list2 = relation.getMembers();
            for (RelationMember relationMember : list2) {
                if (relationMember.isWay() && relationMember.getMember() == way) {
                    Object object2;
                    Object object4;
                    boolean bl3 = true;
                    if ("restriction".equals(string)) {
                        object4 = relationMember.getRole();
                        if ("from".equals(object4) || "to".equals(object4)) {
                            void var24_31;
                            OsmPrimitive osmPrimitive = null;
                            for (RelationMember relationMember2 : relation.getMembers()) {
                                if (!"via".equals(relationMember2.getRole())) continue;
                                osmPrimitive = relationMember2.getMember();
                            }
                            object2 = new ArrayList();
                            if (osmPrimitive != null) {
                                if (osmPrimitive instanceof Node) {
                                    object2.add((Node)osmPrimitive);
                                } else if (osmPrimitive instanceof Way) {
                                    object2.add(((Way)osmPrimitive).lastNode());
                                    object2.add(((Way)osmPrimitive).firstNode());
                                }
                            }
                            Object var24_30 = null;
                            Object object = object2.iterator();
                            while (object.hasNext()) {
                                Node node = (Node)object.next();
                                if (!way2.isFirstLastNode(node)) continue;
                                Way way3 = way;
                            }
                            if (var24_31 == null) {
                                void var24_33;
                                for (Way way4 : arrayList3) {
                                    Iterator iterator2 = object2.iterator();
                                    while (iterator2.hasNext()) {
                                        Node node = (Node)iterator2.next();
                                        if (!way4.isFirstLastNode(node)) continue;
                                        Way way5 = way4;
                                    }
                                }
                                if (var24_33 != null) {
                                    if (relation2 == null) {
                                        relation2 = new Relation(relation);
                                    }
                                    relation2.addMember(new RelationMember((String)object4, (OsmPrimitive)var24_33));
                                    relation2.removeMembersFor(way);
                                    bl3 = false;
                                }
                            } else {
                                bl3 = false;
                            }
                        } else if (!"via".equals(object4)) {
                            bl2 = true;
                        }
                    } else if (!"route".equals(string) && !"multipolygon".equals(string)) {
                        bl2 = true;
                    }
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                    }
                    if (bl3) {
                        if (relationMember.hasRole() && !"multipolygon".equals(string)) {
                            bl = true;
                        }
                        object4 = null;
                        int n3 = 1;
                        while (n2 - n3 >= 0 || n2 + n3 < list2.size()) {
                            if (n2 - n3 >= 0 && list2.get(n2 - n3).isWay()) {
                                object2 = list2.get(n2 - n3).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = false;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = true;
                                break;
                            }
                            if (n2 + n3 < list2.size() && list2.get(n2 + n3).isWay()) {
                                object2 = list2.get(n2 + n3).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = true;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = false;
                                break;
                            }
                            ++n3;
                        }
                        int n4 = n;
                        for (Object object : arrayList3) {
                            RelationMember relationMember3 = new RelationMember(relationMember.getRole(), (OsmPrimitive)object);
                            ++n4;
                            if (object4 != null && ((Boolean)object4).booleanValue()) {
                                relation2.addMember(n, relationMember3);
                                continue;
                            }
                            relation2.addMember(n4, relationMember3);
                        }
                        n = n4;
                    }
                }
                ++n;
                ++n2;
            }
            if (relation2 == null) continue;
            arrayList.add(new ChangeCommand(osmDataLayer, relation, relation2));
        }
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        } else if (bl2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        }
        return new SplitWayResult(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", way.getDisplayName(DefaultNameFormatter.getInstance()), list.size()), arrayList), arrayList2, way, arrayList3);
    }

    public static SplitWayResult split(OsmDataLayer osmDataLayer, Way way, List<Node> list, Collection<? extends OsmPrimitive> collection) {
        List<List<Node>> list2 = SplitWayAction.buildSplitChunks(way, list);
        if (list2 == null) {
            return null;
        }
        return SplitWayAction.splitWay(osmDataLayer, way, list2, collection);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;
        private Way originalWay;
        private List<Way> newWays;

        public SplitWayResult(Command command, List<? extends PrimitiveId> list, Way way, List<Way> list2) {
            this.command = command;
            this.newSelection = list;
            this.originalWay = way;
            this.newWays = list2;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }

        public Way getOriginalWay() {
            return this.originalWay;
        }

        public List<Way> getNewWays() {
            return this.newWays;
        }
    }
}

