/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public class LanguageInfo {
    public static String getWikiLanguagePrefix(Locale locale) {
        String string = LanguageInfo.getJOSMLocaleCode(locale);
        if (string.length() == 2) {
            if (string.equals("en")) {
                return "";
            }
        } else if (!string.equals("zh_TW") && !string.equals("zh_CN")) {
            if (string.matches("[^_]+_[^_]+")) {
                string = string.substring(0, 2);
            } else {
                System.err.println(I18n.tr("Warning: failed to derive wiki language prefix from JOSM locale code ''{0}''. Using default code ''en''.", string));
                return "";
            }
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(Locale.getDefault());
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        String string = locale.toString();
        if (string.equals("iw_IL")) {
            return "he";
        }
        if (string.equals("en_GB") || string.equals("pt_BR") || string.equals("en_AU") || string.equals("zh_TW") || string.equals("zh_CN")) {
            return string;
        }
        return locale.getLanguage();
    }

    public static String getLanguageCodeXML() {
        return LanguageInfo.getJOSMLocaleCode() + ".";
    }

    public static String getLanguageCodeManifest() {
        return LanguageInfo.getJOSMLocaleCode() + "_";
    }
}

