/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class MirroredInputStream
extends InputStream {
    InputStream fs = null;
    File file = null;

    public MirroredInputStream(String string) throws IOException {
        this(string, null, -1L);
    }

    public MirroredInputStream(String string, long l) throws IOException {
        this(string, null, l);
    }

    public MirroredInputStream(String string, String string2) throws IOException {
        this(string, string2, -1L);
    }

    public MirroredInputStream(String string, String string2, long l) throws IOException {
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                this.file = new File(string.substring("file:/".length()));
                if (!this.file.exists()) {
                    this.file = new File(string.substring("file://".length()));
                }
            } else {
                this.file = this.checkLocal(uRL, string2, l);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (string.startsWith("resource://")) {
                this.fs = this.getClass().getResourceAsStream(string.substring("resource:/".length()));
                if (this.fs == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", string));
                }
                return;
            }
            this.file = new File(string);
        }
        if (this.file == null) {
            throw new IOException();
        }
        this.fs = new FileInputStream(this.file);
    }

    public InputStream getZipEntry(String string, String string2) {
        InputStream inputStream;
        block6: {
            if (this.file == null) {
                return null;
            }
            inputStream = null;
            try {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry zipEntry = null;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry2 = enumeration.nextElement();
                    if (!zipEntry2.getName().endsWith("." + string) || zipEntry != null && zipEntry2.getName().indexOf(string2) < 0) continue;
                    zipEntry = zipEntry2;
                }
                if (zipEntry != null) {
                    inputStream = zipFile.getInputStream(zipEntry);
                } else {
                    zipFile.close();
                }
            }
            catch (Exception exception) {
                if (!this.file.getName().endsWith(".zip")) break block6;
                System.err.println(I18n.tr("Warning: failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", this.file.getName(), exception.toString(), string, string2));
            }
        }
        return inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public static void cleanup(String string) {
        MirroredInputStream.cleanup(string, null);
    }

    public static void cleanup(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("file")) {
                String[] stringArray;
                File file;
                String string3 = Main.pref.get("mirror." + uRL);
                if (string3 != null && string3.length() > 0 && (file = new File((stringArray = string3.split(";"))[1])).exists()) {
                    file.delete();
                }
                Main.pref.put("mirror." + uRL, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkLocal(URL uRL, String string, long l) throws IOException {
        Object object;
        String string2 = Main.pref.get("mirror." + uRL);
        File file = null;
        if (string2 != null && string2.length() > 0) {
            object = string2.split(";");
            file = new File((String)object[1]);
            if (l <= 0L) {
                l = Main.pref.getInteger("mirror.maxtime", 604800);
            }
            if (System.currentTimeMillis() - Long.parseLong((String)object[0]) < l * 1000L && file.exists()) {
                return file;
            }
        }
        if (string == null) {
            string = Main.pref.getPreferencesDir();
        }
        if (!((File)(object = new File(string))).exists()) {
            ((File)object).mkdirs();
        }
        String string3 = uRL.toString().replaceAll("[^A-Za-z0-9_.-]", "_");
        string2 = "mirror_" + string3;
        object = new File(string, string2 + ".tmp");
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(5000);
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) > -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            file = new File(string, string2);
            ((File)object).renameTo(file);
            Main.pref.put("mirror." + uRL, System.currentTimeMillis() + ";" + file);
        }
        return file;
    }

    public int available() throws IOException {
        return this.fs.available();
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public int read() throws IOException {
        return this.fs.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fs.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fs.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.fs.skip(l);
    }
}

