/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private HashMap<OsmPrimitiveType, ImageIcon> icons;

    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(RelationMember relationMember) {
        if (relationMember == null) {
            this.setIcon(null);
        } else {
            this.setIcon(this.icons.get((Object)relationMember.getPrimitiveType()));
        }
    }

    protected void renderRole(HistoryBrowserModel.RelationMemberTableModel relationMemberTableModel, RelationMember relationMember, int n, boolean bl) {
        String string = "";
        Color color = Color.WHITE;
        if (relationMember == null) {
            color = BGCOLOR_EMPTY_ROW;
        } else {
            string = relationMember.getRole();
            color = relationMemberTableModel.isSameInOppositeWay(n) ? Color.WHITE : (relationMemberTableModel.isInOppositeWay(n) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setText(string);
        this.setToolTipText(string);
        this.setBackground(color);
    }

    protected void renderPrimitive(HistoryBrowserModel.RelationMemberTableModel relationMemberTableModel, RelationMember relationMember, int n, boolean bl) {
        String string = "";
        Color color = Color.WHITE;
        if (relationMember == null) {
            color = BGCOLOR_EMPTY_ROW;
        } else {
            string = "";
            switch (relationMember.getPrimitiveType()) {
                case NODE: {
                    string = I18n.tr("Node {0}", relationMember.getPrimitiveId());
                    break;
                }
                case WAY: {
                    string = I18n.tr("Way {0}", relationMember.getPrimitiveId());
                    break;
                }
                case RELATION: {
                    string = I18n.tr("Relation {0}", relationMember.getPrimitiveId());
                }
            }
            color = relationMemberTableModel.isSameInOppositeWay(n) ? Color.WHITE : (relationMemberTableModel.isInOppositeWay(n) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setText(string);
        this.setToolTipText(string);
        this.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        HistoryBrowserModel.RelationMemberTableModel relationMemberTableModel = this.gteRelationMemberTableModel(jTable);
        RelationMember relationMember = (RelationMember)object;
        this.renderIcon(relationMember);
        switch (n2) {
            case 0: {
                this.renderRole(relationMemberTableModel, relationMember, n, bl);
                break;
            }
            case 1: {
                this.renderPrimitive(relationMemberTableModel, relationMember, n, bl);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.RelationMemberTableModel gteRelationMemberTableModel(JTable jTable) {
        return (HistoryBrowserModel.RelationMemberTableModel)jTable.getModel();
    }
}

