/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class LatLonDialog
extends JDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    private JTextField tfLat;
    private JTextField tfLon;
    private String help;
    private boolean canceled = false;
    private LatLon coordinates;
    private OKAction actOK;
    private CancelAction actCancel;

    protected JPanel buildInputForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("Enter the coordinates for the new node.") + "<br>" + I18n.tr("Use decimal degrees.") + "<br>" + I18n.tr("Negative values denote Western/Southern hemisphere.")), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Latitude")), GBC.std().insets(0, 10, 5, 0));
        this.tfLat = new JTextField(12);
        jPanel.add((Component)this.tfLat, GBC.eol().insets(0, 10, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("Longitude")), GBC.std().insets(0, 0, 5, 10));
        this.tfLon = new JTextField(12);
        jPanel.add((Component)this.tfLon, GBC.eol().insets(0, 0, 0, 10));
        LatLonInputVerifier latLonInputVerifier = new LatLonInputVerifier();
        this.tfLat.getDocument().addDocumentListener(latLonInputVerifier);
        this.tfLon.getDocument().addDocumentListener(latLonInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfLat.addFocusListener(textFieldFocusHandler);
        this.tfLon.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.actOK = new OKAction();
        SideButton sideButton = new SideButton(this.actOK);
        jPanel.add(sideButton);
        this.makeButtonRespondToEnter(sideButton);
        this.actCancel = new CancelAction();
        sideButton = new SideButton(this.actCancel);
        jPanel.add(sideButton);
        this.makeButtonRespondToEnter(sideButton);
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(this.help)));
        return jPanel;
    }

    protected void makeButtonRespondToEnter(SideButton sideButton) {
        sideButton.setFocusable(true);
        sideButton.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        sideButton.getActionMap().put("enter", sideButton.getAction());
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildInputForm(), "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.pack();
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", this.actCancel);
        HelpUtil.setHelpContext(this.getRootPane(), this.help);
    }

    public LatLonDialog(Component component, String string, String string2) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.help = string2;
        this.setTitle(string);
        this.build();
        this.addWindowListener(new WindowEventHandler());
        this.setCoordinates(null);
    }

    public void setCoordinates(LatLon latLon) {
        if (latLon == null) {
            latLon = new LatLon(0.0, 0.0);
        }
        this.coordinates = latLon;
        this.tfLat.setText(latLon.latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLon.setText(latLon.lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.actOK.setEnabled(true);
    }

    public LatLon getCoordinates() {
        return this.coordinates;
    }

    protected void setErrorFeedback(JTextField jTextField, String string) {
        jTextField.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        jTextField.setToolTipText(string);
        jTextField.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JTextField jTextField, String string) {
        jTextField.setBorder(UIManager.getBorder("TextField.border"));
        jTextField.setToolTipText(string);
        jTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        string = string.replaceAll("\u00b0", "");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        number = numberFormat.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
            parsePosition = new ParsePosition(0);
            numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
            number = numberFormat.parse(string, parsePosition);
            if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
                return null;
            }
        }
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    protected Double parseLatFromUserInput() {
        Double d = this.parseDoubleFromUserInput(this.tfLat.getText());
        if (d == null || !LatLon.isValidLat(d)) {
            this.setErrorFeedback(this.tfLat, I18n.tr("Please enter a valid latitude in the range -90..90"));
            return null;
        }
        this.clearErrorFeedback(this.tfLat, I18n.tr("Please enter a latitude in the range -90..90"));
        return d;
    }

    protected Double parseLonFromUserInput() {
        Double d = this.parseDoubleFromUserInput(this.tfLon.getText());
        if (d == null || !LatLon.isValidLon(d)) {
            this.setErrorFeedback(this.tfLon, I18n.tr("Please enter a valid longitude in the range -180..180"));
            return null;
        }
        this.clearErrorFeedback(this.tfLon, I18n.tr("Please enter a longitude in the range -180..180"));
        return d;
    }

    protected void parseUserInput() {
        Double d = this.parseLatFromUserInput();
        Double d2 = this.parseLonFromUserInput();
        if (d == null || d2 == null) {
            this.coordinates = null;
            this.actOK.setEnabled(false);
        } else {
            this.coordinates = new LatLon(d, d2);
            this.actOK.setEnabled(true);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setCanceled(false);
            WindowGeometry.centerInWindow(Main.parent, this.getSize()).applySafe(this);
        }
        super.setVisible(bl);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }

        public void windowOpened(WindowEvent windowEvent) {
            LatLonDialog.this.tfLat.requestFocusInWindow();
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog, do not create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LatLonDialog.this.setCanceled(false);
            LatLonDialog.this.setVisible(false);
        }
    }
}

