/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.ImageProvider;

public class SourceButton {
    private int x = 0;
    private int y = 30;
    private ImageIcon enlargeImage = ImageProvider.get("layer-switcher-maximize.png");
    private ImageIcon shrinkImage = ImageProvider.get("layer-switcher-minimize.png");
    private ImageIcon imageMapnik = ImageProvider.get("blue_Mapnik.png");
    private ImageIcon imageOsmarender = ImageProvider.get("blue_Osmarender.png");
    private ImageIcon imageCycleMap = ImageProvider.get("blue_CycleMap.png");
    private boolean isEnlarged = false;
    private int currentMap = 2;
    public static final int HIDE_OR_SHOW = 1;
    public static final int MAPNIK = 2;
    public static final int OSMARENDER = 3;
    public static final int CYCLEMAP = 4;

    public void paint(Graphics graphics) {
        if (this.isEnlarged) {
            if (this.currentMap == 2) {
                graphics.drawImage(this.imageMapnik.getImage(), graphics.getClipBounds().width - this.imageMapnik.getIconWidth(), this.y, null);
            } else if (this.currentMap == 4) {
                graphics.drawImage(this.imageCycleMap.getImage(), graphics.getClipBounds().width - this.imageCycleMap.getIconWidth(), this.y, null);
            } else {
                graphics.drawImage(this.imageOsmarender.getImage(), graphics.getClipBounds().width - this.imageMapnik.getIconWidth(), this.y, null);
            }
            if (this.shrinkImage != null) {
                this.x = graphics.getClipBounds().width - this.shrinkImage.getIconWidth();
                graphics.drawImage(this.shrinkImage.getImage(), this.x, this.y, null);
            }
        } else if (this.enlargeImage != null) {
            this.x = graphics.getClipBounds().width - this.enlargeImage.getIconWidth();
            graphics.drawImage(this.enlargeImage.getImage(), this.x, this.y, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
    }

    public int hit(Point point) {
        if (this.isEnlarged) {
            if (this.x < point.x && point.x < this.x + this.shrinkImage.getIconWidth()) {
                if (this.y < point.y && point.y < this.y + this.shrinkImage.getIconHeight()) {
                    return 1;
                }
            } else if (this.x - this.imageMapnik.getIconWidth() < point.x && point.x < this.x) {
                if (this.y < point.y && point.y < this.y + this.imageMapnik.getIconHeight() / 3) {
                    this.currentMap = 3;
                    return 3;
                }
                if (this.y + this.imageMapnik.getIconHeight() / 3 < point.y && point.y < this.y + this.imageMapnik.getIconHeight() * 2 / 3) {
                    this.currentMap = 2;
                    return 2;
                }
                if (this.y + this.imageMapnik.getIconHeight() * 2 / 3 < point.y && point.y < this.y + this.imageMapnik.getIconHeight()) {
                    this.currentMap = 4;
                    return 4;
                }
            }
        } else if (this.x < point.x && point.x < this.x + this.enlargeImage.getIconWidth() && this.y < point.y && point.y < this.y + this.enlargeImage.getIconHeight()) {
            return 1;
        }
        return 0;
    }

    public void setMapStyle(int n) {
        this.currentMap = n < 2 || n > 4 ? 2 : n;
    }
}

