/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private boolean aspectRatio;

    public SelectionManager(SelectionEnded selectionEnded, boolean bl, NavigatableComponent navigatableComponent) {
        this.selectionEndedListener = selectionEnded;
        this.aspectRatio = bl;
        this.nc = navigatableComponent;
    }

    public void register(NavigatableComponent navigatableComponent) {
        navigatableComponent.addMouseListener(this);
        navigatableComponent.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        navigatableComponent.addPropertyChangeListener("scale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (SelectionManager.this.mousePosStart != null) {
                    SelectionManager.this.paintRect();
                    SelectionManager.this.mousePos = (SelectionManager.this.mousePosStart = null);
                }
            }
        });
    }

    public void unregister(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.mousePosStart = this.mousePos = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx() & 0x1400;
        if (n != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = mouseEvent.getPoint();
            }
            this.paintRect();
        }
        if (n == 1024) {
            this.mousePos = mouseEvent.getPoint();
            this.paintRect();
        } else if (n == 5120) {
            this.mousePosStart.x += mouseEvent.getX() - this.mousePos.x;
            this.mousePosStart.y += mouseEvent.getY() - this.mousePos.y;
            this.mousePos = mouseEvent.getPoint();
            this.paintRect();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.mousePos == null || this.mousePosStart == null) {
            return;
        }
        this.paintRect();
        Rectangle rectangle = this.getSelectionRectangle();
        this.mousePosStart = null;
        this.mousePos = null;
        boolean bl2 = (mouseEvent.getModifiersEx() & 0x40) != 0;
        boolean bl3 = (mouseEvent.getModifiersEx() & 0x2200) != 0;
        boolean bl4 = bl = (mouseEvent.getModifiersEx() & 0x80) != 0;
        if ((mouseEvent.getModifiersEx() & 0x1000) == 0) {
            this.selectionEndedListener.selectionEnded(rectangle, bl3, bl2, bl);
        }
    }

    private void paintRect() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        Graphics graphics = this.nc.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.setXORMode(Color.WHITE);
        Rectangle rectangle = this.getSelectionRectangle();
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Rectangle getSelectionRectangle() {
        int n = this.mousePosStart.x;
        int n2 = this.mousePosStart.y;
        int n3 = this.mousePos.x - this.mousePosStart.x;
        int n4 = this.mousePos.y - this.mousePosStart.y;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (this.aspectRatio) {
            double d = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)n3 / (double)n4 < d) {
                int n5 = (int)((double)n4 * d);
                if (this.mousePos.x < this.mousePosStart.x) {
                    n += n3 - n5;
                }
                n3 = n5;
            } else {
                int n6 = (int)((double)n3 / d);
                if (this.mousePos.y < this.mousePosStart.y) {
                    n2 += n4 - n6;
                }
                n4 = n6;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("active") && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.mousePosStart != null) {
            this.paintRect();
            this.mousePosStart = null;
            this.mousePos = null;
        }
    }

    public Collection<OsmPrimitive> getObjectsInRectangle(Rectangle rectangle, boolean bl) {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        boolean bl2 = rectangle.width <= 2 && rectangle.height <= 2;
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        if (bl2) {
            OsmPrimitive osmPrimitive = this.nc.getNearest(point, OsmPrimitive.isSelectablePredicate);
            if (osmPrimitive != null) {
                linkedList.add(osmPrimitive);
            }
        } else {
            for (Node osmPrimitive : this.nc.getCurrentDataSet().getNodes()) {
                if (!osmPrimitive.isSelectable() || !rectangle.contains(this.nc.getPoint(osmPrimitive))) continue;
                linkedList.add(osmPrimitive);
            }
            block1: for (Way way : this.nc.getCurrentDataSet().getWays()) {
                if (!way.isSelectable() || way.getNodesCount() == 0) continue;
                if (bl) {
                    for (Node node : way.getNodes()) {
                        if (node.isIncomplete() || !rectangle.contains(this.nc.getPoint(node))) continue;
                        linkedList.add(way);
                        continue block1;
                    }
                    continue;
                }
                boolean bl3 = true;
                for (Node node : way.getNodes()) {
                    if (node.isIncomplete() || rectangle.contains(this.nc.getPoint(node))) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                linkedList.add(way);
            }
        }
        return linkedList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static interface SelectionEnded {
        public void selectionEnded(Rectangle var1, boolean var2, boolean var3, boolean var4);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

