/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;

    public final void setCoor(LatLon latLon) {
        if (latLon != null) {
            this.updateCoor(latLon, null);
        }
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            this.updateCoor(null, eastNorth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoor(LatLon latLon, EastNorth eastNorth) {
        if (this.getDataSet() != null) {
            boolean bl = this.writeLock();
            try {
                this.getDataSet().fireNodeMoved(this, latLon, eastNorth);
            }
            finally {
                this.writeUnlock(bl);
            }
        } else {
            this.setCoorInternal(latLon, eastNorth);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    protected void setCoorInternal(LatLon latLon, EastNorth eastNorth) {
        if (this.coor == null) {
            this.coor = eastNorth == null ? new CachedLatLon(latLon) : new CachedLatLon(eastNorth);
        } else if (eastNorth == null) {
            this.coor.setCoor(latLon);
        } else {
            this.coor.setEastNorth(eastNorth);
        }
    }

    protected Node(long l, boolean bl) {
        super(l, bl);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long l) {
        super(l, false);
    }

    public Node(long l, int n) {
        super(l, n, false);
    }

    public Node(Node node, boolean bl) {
        super(node.getUniqueId(), true);
        this.cloneFrom(node);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Node(Node node) {
        this(node, false);
    }

    public Node(LatLon latLon) {
        super(0L, false);
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        if (!(this.isIncomplete() || this.getCoor() != null && this.getEastNorth() != null)) {
            throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString() + this.get3892DebugInfo());
        }
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            this.setCoor(((Node)osmPrimitive).coor);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.mergeFrom(osmPrimitive);
            if (!osmPrimitive.isIncomplete()) {
                this.setCoor(new LatLon(((Node)osmPrimitive).coor));
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            this.setCoor(((NodeData)primitiveData).getCoor());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public NodeData save() {
        NodeData nodeData = new NodeData();
        this.saveCommonAttributes(nodeData);
        if (!this.isIncomplete()) {
            nodeData.setCoor(this.getCoor());
        }
        return nodeData;
    }

    public String toString() {
        String string = this.coor == null ? "" : "lat=" + this.coor.lat() + ",lon=" + this.coor.lon();
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        if (this.coor == null && node.coor == null) {
            return true;
        }
        if (this.coor != null && node.coor != null) {
            return this.coor.equalsEpsilon(node.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : 1;
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public BBox getBBox() {
        return new BBox(this);
    }

    public void updatePosition() {
    }

    public boolean isConnectionNode() {
        return OsmPrimitive.getFilteredList(this.getReferrers(), Way.class).size() > 1;
    }

    public String get3892DebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected error. Please report it to http://josm.openstreetmap.de/ticket/3892\n");
        stringBuilder.append(this.toString());
        stringBuilder.append("\n");
        if (this.coor == null) {
            stringBuilder.append("Coor is null\n");
        } else {
            stringBuilder.append(String.format("EastNorth: %s\n", this.coor.getEastNorth()));
            stringBuilder.append(this.coor.getProjection());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

