/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.tools.I18n;

public class LatLon
extends Coordinate {
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDmMinuteFormatter = new DecimalFormat("00.000");
    public static DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    private static final String SOUTH;
    private static final String NORTH;
    private static final String WEST;
    private static final String EAST;

    public static boolean isValidLat(double d) {
        return d >= -90.0 && d <= 90.0;
    }

    public static boolean isValidLon(double d) {
        return d >= -180.0 && d <= 180.0;
    }

    public static String dms(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        int n2 = (int)d3;
        double d4 = (d3 - (double)n2) * 60.0;
        return n + "\u00b0" + cDmsMinuteFormatter.format(n2) + "'" + cDmsSecondFormatter.format(d4) + "\"";
    }

    public static String dm(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        return n + "\u00b0" + cDmMinuteFormatter.format(d3) + "'";
    }

    public LatLon(double d, double d2) {
        super(d2, d);
    }

    public LatLon(LatLon latLon) {
        super(latLon.lon(), latLon.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case NAUTICAL: {
                return LatLon.dm(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.proj.latlon2eastNorth(this).north());
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case NAUTICAL: {
                return LatLon.dm(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.proj.latlon2eastNorth(this).east());
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon latLon) {
        double d = 5.0E-8;
        return Math.abs(this.lat() - latLon.lat()) <= d && Math.abs(this.lon() - latLon.lon()) <= d;
    }

    public boolean isOutSideWorld() {
        Bounds bounds = Main.proj.getWorldBoundsLatLon();
        return this.lat() < bounds.getMin().lat() || this.lat() > bounds.getMax().lat() || this.lon() < bounds.getMin().lon() || this.lon() > bounds.getMax().lon();
    }

    public boolean isWithin(Bounds bounds) {
        return this.lat() >= bounds.getMin().lat() && this.lat() <= bounds.getMax().lat() && this.lon() > bounds.getMin().lon() && this.lon() < bounds.getMax().lon();
    }

    public double greatCircleDistance(LatLon latLon) {
        double d = 6378135.0;
        double d2 = Math.sin(Math.toRadians(latLon.lat() - this.lat()) / 2.0);
        double d3 = Math.sin(Math.toRadians(latLon.lon() - this.lon()) / 2.0);
        double d4 = 2.0 * d * Math.asin(Math.sqrt(d2 * d2 + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * d3 * d3));
        if (Double.isNaN(d4)) {
            System.err.println("Error: NaN in greatCircleDistance");
            d4 = Math.PI * d;
        }
        return d4;
    }

    public double heading(LatLon latLon) {
        double d;
        if (latLon.lat() == this.lat()) {
            d = latLon.lon() > this.lon() ? 1.5707963267948966 : 4.71238898038469;
        } else {
            d = Math.atan((latLon.lon() - this.lon()) / (latLon.lat() - this.lat()));
            if (d < 0.0) {
                d += Math.PI;
            }
            if (latLon.lon() < this.lon()) {
                d += Math.PI;
            }
        }
        return d;
    }

    public String toDisplayString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        return "lat=" + numberFormat.format(this.lat()) + "\u00b0, lon=" + numberFormat.format(this.lon()) + "\u00b0";
    }

    public LatLon interpolate(LatLon latLon, double d) {
        return new LatLon(this.lat() + d * (latLon.lat() - this.lat()), this.lon() + d * (latLon.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon latLon) {
        return new LatLon((this.lat() + latLon.lat()) / 2.0, (this.lon() + latLon.lon()) / 2.0);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon((double)Math.round(this.lat() / 1.0E-7) * 1.0E-7, (double)Math.round(this.lon() / 1.0E-7) * 1.0E-7);
    }

    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(coordinate.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(coordinate.y);
    }

    static {
        cDdFormatter.applyPattern("###0.0000000");
        SOUTH = I18n.trc("compass", "S");
        NORTH = I18n.trc("compass", "N");
        WEST = I18n.trc("compass", "W");
        EAST = I18n.trc("compass", "E");
    }
}

