/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutosaveTask
extends TimerTask
implements MapView.LayerChangeListener,
DataSetListenerAdapter.Listener {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String AUTOSAVE_DIR = "autosave";
    private static final String DELETED_LAYERS_DIR = "autosave/deleted_layers";
    public static final BooleanProperty PROP_AUTOSAVE_ENABLED = new BooleanProperty("autosave.enabled", true);
    public static final IntegerProperty PROP_FILES_PER_LAYER = new IntegerProperty("autosave.filesPerLayer", 1);
    public static final IntegerProperty PROP_DELETED_LAYERS = new IntegerProperty("autosave.deletedLayersBackupCount", 5);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("autosave.interval", 300);
    public static final IntegerProperty PROP_INDEX_LIMIT = new IntegerProperty("autosave.index-limit", 1000);
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter(this);
    private Set<DataSet> changedDatasets = new HashSet<DataSet>();
    private final List<AutosaveLayerInfo> layersInfo = new ArrayList<AutosaveLayerInfo>();
    private Timer timer;
    private final Object layersLock = new Object();
    private final Deque<File> deletedLayers = new LinkedList<File>();
    private final File autosaveDir = new File(Main.pref.getPreferencesDir() + "autosave");
    private final File deletedLayersDir = new File(Main.pref.getPreferencesDir() + "autosave/deleted_layers");

    public void schedule() {
        if (PROP_INTERVAL.get() > 0) {
            if (!this.autosaveDir.exists() && !this.autosaveDir.mkdirs()) {
                System.out.println(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.autosaveDir.getAbsolutePath()));
                return;
            }
            if (!this.deletedLayersDir.exists() && !this.deletedLayersDir.mkdirs()) {
                System.out.println(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.deletedLayersDir.getAbsolutePath()));
                return;
            }
            for (File file : this.deletedLayersDir.listFiles()) {
                this.deletedLayers.add(file);
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)(PROP_INTERVAL.get() * 1000));
            MapView.addLayerChangeListener(this);
            if (Main.isDisplayingMapView()) {
                for (OsmDataLayer osmDataLayer : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
                    this.registerNewlayer(osmDataLayer);
                }
            }
        }
    }

    private String getFileName(String string, int n) {
        String string2 = string;
        for (int i = 0; i < ILLEGAL_CHARACTERS.length; ++i) {
            string2 = string2.replaceAll(Pattern.quote(String.valueOf(ILLEGAL_CHARACTERS[i])), '&' + String.valueOf((int)ILLEGAL_CHARACTERS[i]) + ';');
        }
        if (n != 0) {
            string2 = string2 + '_' + n;
        }
        return string2;
    }

    private void setLayerFileName(AutosaveLayerInfo autosaveLayerInfo) {
        int n = 0;
        while (true) {
            String string = this.getFileName(autosaveLayerInfo.layer.getName(), n);
            boolean bl = false;
            for (AutosaveLayerInfo autosaveLayerInfo2 : this.layersInfo) {
                if (autosaveLayerInfo2 == autosaveLayerInfo || !string.equals(autosaveLayerInfo2.layerFileName)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                autosaveLayerInfo.layerFileName = string;
                return;
            }
            ++n;
        }
    }

    private File getNewLayerFile(AutosaveLayerInfo autosaveLayerInfo) {
        int n = 0;
        Date date = new Date();
        while (true) {
            File file = new File(this.autosaveDir, String.format("%1$s_%2$tY%2$tm%2$td_%2$tH%2$tM%3$s.osm", autosaveLayerInfo.layerFileName, date, n == 0 ? "" : "_" + n));
            try {
                if (file.createNewFile()) {
                    return file;
                }
                System.out.println(I18n.tr("Unable to create file {0}, other filename will be used", file.getAbsolutePath()));
                if (n > PROP_INDEX_LIMIT.get()) {
                    throw new IOException("index limit exceeded");
                }
            }
            catch (IOException iOException) {
                System.err.println(I18n.tr("IOError while creating file, autosave will be skipped: {0}", iOException.getMessage()));
                return null;
            }
            ++n;
        }
    }

    private void savelayer(AutosaveLayerInfo autosaveLayerInfo) throws IOException {
        File file;
        if (!autosaveLayerInfo.layer.getName().equals(autosaveLayerInfo.layerName)) {
            this.setLayerFileName(autosaveLayerInfo);
            autosaveLayerInfo.layerName = autosaveLayerInfo.layer.getName();
        }
        if (this.changedDatasets.contains(autosaveLayerInfo.layer.data) && (file = this.getNewLayerFile(autosaveLayerInfo)) != null) {
            autosaveLayerInfo.backupFiles.add(file);
            new OsmExporter().exportData(file, autosaveLayerInfo.layer);
        }
        while (autosaveLayerInfo.backupFiles.size() > PROP_FILES_PER_LAYER.get()) {
            file = autosaveLayerInfo.backupFiles.remove();
            if (file.delete()) continue;
            System.out.println(I18n.tr("Unable to delete old backup file {0}", file.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.layersLock;
        synchronized (object) {
            try {
                for (AutosaveLayerInfo autosaveLayerInfo : this.layersInfo) {
                    this.savelayer(autosaveLayerInfo);
                }
                this.changedDatasets.clear();
            }
            catch (Throwable throwable) {
                System.err.println("Autosave failed: ");
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(OsmDataLayer osmDataLayer) {
        Object object = this.layersLock;
        synchronized (object) {
            osmDataLayer.data.addDataSetListener(this.datasetAdapter);
            AutosaveLayerInfo autosaveLayerInfo = new AutosaveLayerInfo();
            autosaveLayerInfo.layer = osmDataLayer;
            this.layersInfo.add(autosaveLayerInfo);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            this.registerNewlayer((OsmDataLayer)layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
                osmDataLayer.data.removeDataSetListener(this.datasetAdapter);
                Iterator<AutosaveLayerInfo> iterator = this.layersInfo.iterator();
                while (iterator.hasNext()) {
                    AutosaveLayerInfo autosaveLayerInfo = iterator.next();
                    if (autosaveLayerInfo.layer != osmDataLayer) continue;
                    try {
                        this.savelayer(autosaveLayerInfo);
                        File file = autosaveLayerInfo.backupFiles.pollLast();
                        if (file != null) {
                            File file2 = new File(this.deletedLayersDir, file.getName());
                            file.renameTo(file2);
                            this.deletedLayers.add(file);
                        }
                        for (File file3 : autosaveLayerInfo.backupFiles) {
                            file3.delete();
                        }
                        while (this.deletedLayers.size() > PROP_DELETED_LAYERS.get()) {
                            this.deletedLayers.remove().delete();
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(I18n.tr("Error while creating backup of removed layer: {0}", iOException.getMessage()));
                    }
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.changedDatasets.add(abstractDatasetChangedEvent.getDataset());
    }

    public List<File> getUnsavedLayersFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.autosaveDir.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public List<OsmDataLayer> getUnsavedLayers() {
        ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
        for (File file : this.getUnsavedLayersFiles()) {
            try {
                DataSet dataSet = OsmReader.parseDataSet(new FileInputStream(file), NullProgressMonitor.INSTANCE);
                String string = file.getName();
                string = string.substring(0, string.lastIndexOf(46));
                arrayList.add(new OsmDataLayer(dataSet, string, null));
                file.renameTo(new File(this.deletedLayersDir, file.getName()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File " + file.getAbsolutePath() + " not found");
            }
            catch (IllegalDataException illegalDataException) {
                System.err.println(I18n.tr("Unable to read autosaved osm data ({0}) - {1}", file.getAbsoluteFile(), illegalDataException.getMessage()));
            }
        }
        return arrayList;
    }

    public void dicardUnsavedLayers() {
        for (File file : this.getUnsavedLayersFiles()) {
            file.renameTo(new File(this.deletedLayersDir, file.getName()));
        }
    }

    private static class AutosaveLayerInfo {
        OsmDataLayer layer;
        String layerName;
        String layerFileName;
        final Deque<File> backupFiles = new LinkedList<File>();

        private AutosaveLayerInfo() {
        }
    }
}

