/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayNodesConflictResolverCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(WayNodesConflictResolverCommand.class.getName());
    private Conflict<Way> conflict;
    private final List<Node> mergedNodeList;

    public WayNodesConflictResolverCommand(Conflict<? extends OsmPrimitive> conflict, List<Node> list) {
        this.conflict = conflict;
        this.mergedNodeList = list;
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Resolve conflicts in node list of way {0}", this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (Node node : this.mergedNodeList) {
            if (this.getLayer().data.getNodes().contains(node)) continue;
            logger.warning(I18n.tr("Main dataset does not include node {0}", node.toString()));
        }
        this.conflict.getMy().setNodes(this.mergedNodeList);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

