/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<PluginInformation> availablePlugins;

    protected void init(Collection<String> collection) {
        this.sites = collection;
        if (collection == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
    }

    public ReadRemotePluginInformationTask(Collection<String> collection) {
        super(I18n.tr("Download plugin list..."), false);
        this.init(collection);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor progressMonitor, Collection<String> collection) {
        super(I18n.tr("Download plugin list..."), progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        this.init(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File file, String string) {
        String string2;
        try {
            URL uRL = new URL(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("site-");
            stringBuilder.append(uRL.getHost()).append("-");
            if (uRL.getPort() != -1) {
                stringBuilder.append(uRL.getPort()).append("-");
            }
            String string3 = uRL.getPath();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append("_");
            }
            stringBuilder.append(".txt");
            string2 = stringBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "site-unknown.txt";
        }
        return new File(file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadPluginList(String string, ProgressMonitor progressMonitor) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string));
            URL uRL = new URL(string);
            Object object = this;
            synchronized (object) {
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", uRL.getHost());
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object).append("\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (MalformedURLException malformedURLException) {
            if (this.canceled) {
                String string3 = null;
                return string3;
            }
            malformedURLException.printStackTrace();
            String string4 = null;
            return string4;
        }
        catch (IOException iOException) {
            if (this.canceled) {
                String string5 = null;
                return string5;
            }
            iOException.printStackTrace();
            String string6 = null;
            return string6;
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePluginList(String string, String string2) {
        PrintWriter printWriter = null;
        try {
            File file = Main.pref.getPluginsDirectory();
            if (!file.exists() && !file.mkdirs()) {
                System.err.println(I18n.tr("Warning: failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", file.toString(), string));
            }
            File file2 = this.createSiteCacheFile(file, string);
            this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", file2.toString()));
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
            printWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> list) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(list.size());
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(PluginHandler.DEPRECATED_PLUGINS));
        for (PluginInformation pluginInformation : list) {
            if (hashSet.contains(pluginInformation.name)) continue;
            arrayList.add(pluginInformation);
        }
        return arrayList;
    }

    protected void parsePluginListDocument(String string, String string2) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", string));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            List<PluginInformation> list = new PluginListParser().parse(byteArrayInputStream);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(list));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, unsupportedEncodingException.toString()));
            unsupportedEncodingException.printStackTrace();
        }
        catch (PluginListParseException pluginListParseException) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, pluginListParseException.toString()));
            pluginListParseException.printStackTrace();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Object object;
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File file = Main.pref.getPluginsDirectory();
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String object2 : PluginInformation.getPluginLocations()) {
            object = new File(object2).listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.matches("^([0-9]+-)?site.*\\.txt$");
                }
            });
            if (object == null || ((File[])object).length <= 0) continue;
            linkedList.addAll(Arrays.asList(object));
        }
        for (String string : this.sites) {
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", string));
            object = this.downloadPluginList(string, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            linkedList.remove(this.createSiteCacheFile(file, string));
            if (object == null) continue;
            this.getProgressMonitor().worked(1);
            this.cachePluginList(string, (String)object);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            this.parsePluginListDocument(string, (String)object);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        for (File file2 : linkedList) {
            file2.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailabePlugins() {
        return this.availablePlugins;
    }
}

