/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.CommandListMutableTreeNode;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Shortcut;

public class CommandStackDialog
extends ToggleDialog
implements OsmDataLayer.CommandQueueListener {
    private DefaultTreeModel undoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private DefaultTreeModel redoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private JTree undoTree = new JTree(this.undoTreeModel);
    private JTree redoTree = new JTree(this.redoTreeModel);
    private UndoRedoSelectionListener undoSelectionListener;
    private UndoRedoSelectionListener redoSelectionListener;
    private JScrollPane scrollPane;
    private JSeparator separator = new JSeparator();
    private Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private UndoRedoType lastOperation = UndoRedoType.UNDO;
    Set<IEnabledStateUpdating> showNotifyListener = new LinkedHashSet<IEnabledStateUpdating>();

    public CommandStackDialog(MapFrame mapFrame) {
        super(I18n.tr("Command Stack"), "commandstack", I18n.tr("Open a list of all commands (undo buffer)."), Shortcut.registerShortcut("subwindow:commandstack", I18n.tr("Toggle: {0}", I18n.tr("Command Stack")), 79, 4, 1), 100, true);
        Main.main.undoRedo.listenerCommands.add(this);
        this.undoTree.addMouseListener(new PopupMenuHandler());
        this.undoTree.setRootVisible(false);
        this.undoTree.getSelectionModel().setSelectionMode(1);
        this.undoTree.setShowsRootHandles(true);
        this.undoTree.expandRow(0);
        this.undoTree.setCellRenderer(new CommandCellRenderer());
        this.undoSelectionListener = new UndoRedoSelectionListener(this.undoTree);
        this.undoTree.getSelectionModel().addTreeSelectionListener(this.undoSelectionListener);
        this.redoTree.addMouseListener(new PopupMenuHandler());
        this.redoTree.setRootVisible(false);
        this.redoTree.getSelectionModel().setSelectionMode(1);
        this.redoTree.setShowsRootHandles(true);
        this.redoTree.expandRow(0);
        this.redoTree.setCellRenderer(new CommandCellRenderer());
        this.redoSelectionListener = new UndoRedoSelectionListener(this.redoTree);
        this.redoTree.getSelectionModel().addTreeSelectionListener(this.redoSelectionListener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        jPanel.add((Component)this.undoTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        jPanel.add((Component)this.separator, GBC.eol().fill(2));
        jPanel.add((Component)this.redoTree, GBC.eol().fill(2));
        jPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0, 1));
        jPanel.setBackground(this.redoTree.getBackground());
        this.scrollPane = new JScrollPane(jPanel);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = this.getButtonPanel(3);
        SelectAction selectAction = new SelectAction();
        this.wireUpdateEnabledStateUpdater(selectAction, this.undoTree);
        this.wireUpdateEnabledStateUpdater(selectAction, this.redoTree);
        jPanel.add(new SideButton(selectAction));
        UndoRedoAction undoRedoAction = new UndoRedoAction(UndoRedoType.UNDO);
        this.wireUpdateEnabledStateUpdater(undoRedoAction, this.undoTree);
        jPanel.add(new SideButton(undoRedoAction));
        UndoRedoAction undoRedoAction2 = new UndoRedoAction(UndoRedoType.REDO);
        this.wireUpdateEnabledStateUpdater(undoRedoAction2, this.redoTree);
        jPanel.add(new SideButton(undoRedoAction2));
        return jPanel;
    }

    protected void wireUpdateEnabledStateUpdater(final IEnabledStateUpdating iEnabledStateUpdating, JTree jTree) {
        this.addShowNotifyListener(iEnabledStateUpdating);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
        jTree.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    public void showNotify() {
        this.buildTrees();
        for (IEnabledStateUpdating iEnabledStateUpdating : this.showNotifyListener) {
            iEnabledStateUpdating.updateEnabledState();
        }
    }

    private void addShowNotifyListener(IEnabledStateUpdating iEnabledStateUpdating) {
        this.showNotifyListener.add(iEnabledStateUpdating);
    }

    public void hideNotify() {
        this.undoTreeModel.setRoot(new DefaultMutableTreeNode());
        this.redoTreeModel.setRoot(new DefaultMutableTreeNode());
    }

    private void buildTrees() {
        this.setTitle(I18n.tr("Command Stack"));
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
            return;
        }
        LinkedList<Command> linkedList = Main.main.undoRedo.commands;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (int i = 0; i < linkedList.size(); ++i) {
            defaultMutableTreeNode.add(this.getNodeForCommand((PseudoCommand)linkedList.get(i), i));
        }
        this.undoTreeModel.setRoot(defaultMutableTreeNode);
        this.undoTree.scrollRowToVisible(this.undoTreeModel.getChildCount(defaultMutableTreeNode) - 1);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        LinkedList<Command> linkedList2 = Main.main.undoRedo.redoCommands;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        for (int i = 0; i < linkedList2.size(); ++i) {
            defaultMutableTreeNode2.add(this.getNodeForCommand((PseudoCommand)linkedList2.get(i), i));
        }
        this.redoTreeModel.setRoot(defaultMutableTreeNode2);
        if (this.redoTreeModel.getChildCount(defaultMutableTreeNode2) > 0) {
            this.redoTree.scrollRowToVisible(0);
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
        this.separator.setVisible(!linkedList.isEmpty() || !linkedList2.isEmpty());
        this.spacer.setVisible(linkedList.isEmpty() && !linkedList2.isEmpty());
        switch (this.lastOperation) {
            case UNDO: {
                if (!linkedList.isEmpty()) break;
                this.lastOperation = UndoRedoType.REDO;
                break;
            }
            case REDO: {
                if (!linkedList2.isEmpty()) break;
                this.lastOperation = UndoRedoType.UNDO;
            }
        }
        switch (this.lastOperation) {
            case UNDO: {
                this.undoTree.setSelectionRow(this.undoTree.getRowCount() - 1);
                break;
            }
            case REDO: {
                this.redoTree.setSelectionRow(0);
            }
        }
    }

    protected CommandListMutableTreeNode getNodeForCommand(PseudoCommand pseudoCommand, int n) {
        CommandListMutableTreeNode commandListMutableTreeNode = new CommandListMutableTreeNode(pseudoCommand, n);
        if (pseudoCommand.getChildren() != null) {
            ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>(pseudoCommand.getChildren());
            for (int i = 0; i < arrayList.size(); ++i) {
                commandListMutableTreeNode.add(this.getNodeForCommand((PseudoCommand)arrayList.get(i), i));
            }
        }
        return commandListMutableTreeNode;
    }

    public void commandChanged(int n, int n2) {
        if (!this.isVisible()) {
            return;
        }
        this.buildTrees();
    }

    private class CommandStackPopup
    extends JPopupMenu {
        private TreePath[] sel;

        public CommandStackPopup(TreePath[] treePathArray) {
            this.sel = treePathArray;
            this.add(new SelectAction());
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        public void launch(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            JTree jTree = (JTree)mouseEvent.getSource();
            int n = jTree.getRowForLocation(point.x, point.y);
            if (n != -1) {
                TreePath treePath = jTree.getPathForLocation(point.x, point.y);
                if (!jTree.isPathSelected(treePath)) {
                    jTree.setSelectionPath(treePath);
                }
                TreePath[] treePathArray = jTree.getSelectionPaths();
                CommandStackPopup commandStackPopup = new CommandStackPopup(treePathArray);
                commandStackPopup.show(jTree, point.x, point.y - 3);
            }
        }
    }

    protected class UndoRedoAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private UndoRedoType type;
        private JTree tree;

        public UndoRedoAction(UndoRedoType undoRedoType) {
            this.type = undoRedoType;
            switch (undoRedoType) {
                case UNDO: {
                    this.tree = CommandStackDialog.this.undoTree;
                    this.putValue("Name", I18n.tr("Undo"));
                    this.putValue("ShortDescription", I18n.tr("Undo the selected and all later commands"));
                    this.putValue("SmallIcon", ImageProvider.get("undo"));
                    break;
                }
                case REDO: {
                    this.tree = CommandStackDialog.this.redoTree;
                    this.putValue("Name", I18n.tr("Redo"));
                    this.putValue("ShortDescription", I18n.tr("Redo the selected and all earlier commands"));
                    this.putValue("SmallIcon", ImageProvider.get("redo"));
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandStackDialog.this.lastOperation = this.type;
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath.getPathCount() != 2) {
                throw new IllegalStateException();
            }
            int n = ((CommandListMutableTreeNode)treePath.getLastPathComponent()).getIndex();
            switch (this.type) {
                case UNDO: {
                    int n2 = ((DefaultMutableTreeNode)CommandStackDialog.this.undoTreeModel.getRoot()).getChildCount() - n;
                    Main.main.undoRedo.undo(n2);
                    break;
                }
                case REDO: {
                    int n3 = n + 1;
                    Main.main.undoRedo.redo(n3);
                }
            }
            Main.map.repaint();
        }

        public void updateEnabledState() {
            this.setEnabled(!this.tree.isSelectionEmpty() && this.tree.getSelectionPath().getPathCount() == 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum UndoRedoType {
        UNDO,
        REDO;

    }

    public class SelectAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Selects the objects that take part in this command (unless currently deleted)"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath;
            CommandStackDialog.this.undoTree.getSelectionPath();
            if (!CommandStackDialog.this.undoTree.isSelectionEmpty()) {
                treePath = CommandStackDialog.this.undoTree.getSelectionPath();
            } else if (!CommandStackDialog.this.redoTree.isSelectionEmpty()) {
                treePath = CommandStackDialog.this.redoTree.getSelectionPath();
            } else {
                throw new IllegalStateException();
            }
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
                return;
            }
            PseudoCommand pseudoCommand = ((CommandListMutableTreeNode)treePath.getLastPathComponent()).getCommand();
            final OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
            DatasetCollection datasetCollection = new DatasetCollection(pseudoCommand.getParticipatingPrimitives(), new Predicate<OsmPrimitive>(){

                @Override
                public boolean evaluate(OsmPrimitive osmPrimitive) {
                    OsmPrimitive osmPrimitive2 = osmDataLayer.data.getPrimitiveById(osmPrimitive);
                    return osmPrimitive2 != null && osmPrimitive2.isUsable();
                }
            });
            Main.map.mapView.getEditLayer().data.setSelected(datasetCollection);
        }

        public void updateEnabledState() {
            this.setEnabled(!CommandStackDialog.this.undoTree.isSelectionEmpty() || !CommandStackDialog.this.redoTree.isSelectionEmpty());
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }

    private class UndoRedoSelectionListener
    implements TreeSelectionListener {
        private JTree source;

        public UndoRedoSelectionListener(JTree jTree) {
            this.source = jTree;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.source == CommandStackDialog.this.undoTree) {
                CommandStackDialog.this.redoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
                CommandStackDialog.this.redoTree.clearSelection();
                CommandStackDialog.this.redoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
            }
            if (this.source == CommandStackDialog.this.redoTree) {
                CommandStackDialog.this.undoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
                CommandStackDialog.this.undoTree.clearSelection();
                CommandStackDialog.this.undoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
            }
        }
    }

    private static class CommandCellRenderer
    extends DefaultTreeCellRenderer {
        private CommandCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof JLabel) {
                JLabel jLabel = (JLabel)defaultMutableTreeNode.getUserObject();
                this.setIcon(jLabel.getIcon());
                this.setText(jLabel.getText());
            }
            return this;
        }
    }
}

