/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected String decorateNameWithId(String string, OsmPrimitive osmPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            if (Main.pref.getBoolean("osm-primitives.showid.new-primitives")) {
                return string + I18n.tr(" [id: {0}]", osmPrimitive.getUniqueId());
            }
            return string + I18n.tr(" [id: {0}]", osmPrimitive.getId());
        }
        return string;
    }

    @Override
    public String format(Node node) {
        String string = "";
        if (node.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
            if (string == null) {
                string = node.isNew() ? I18n.tr("node") : "" + node.getId();
            }
            string = string + " (" + node.getCoor().latToString(CoordinateFormat.getDefaultFormat()) + ", " + node.getCoor().lonToString(CoordinateFormat.getDefaultFormat()) + ")";
        }
        string = this.decorateNameWithId(string, node);
        return string;
    }

    @Override
    public String format(Way way) {
        String string = "";
        if (way.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            int n;
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
            if (string == null) {
                string = way.get("ref");
            }
            if (string == null) {
                String string2 = way.get("highway") != null ? I18n.tr("highway") : (way.get("railway") != null ? I18n.tr("railway") : (way.get("waterway") != null ? I18n.tr("waterway") : (string = way.get("landuse") != null ? I18n.tr("landuse") : "")));
            }
            if ((n = way.getNodesCount()) > 1 && way.isClosed()) {
                --n;
            }
            if (string.length() == 0) {
                string = String.valueOf(way.getId());
            }
            String string3 = I18n.trn("{0} node", "{0} nodes", n, n);
            string = string + (string.length() > 0 ? " (" + string3 + ")" : string3);
        }
        string = this.decorateNameWithId(string, way);
        return string;
    }

    @Override
    public String format(Relation relation) {
        String string;
        if (relation.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            String string2;
            string = I18n.tr(relation.get("type"));
            if (string == null) {
                String string3 = string = relation.get("public_transport") != null ? I18n.tr("public transport") : "";
            }
            if (string == null) {
                string2 = relation.get("building");
                if (OsmUtils.isTrue(string2)) {
                    string = I18n.tr("building");
                } else if (string2 != null) {
                    string = I18n.tr(string2);
                }
            }
            if (string == null) {
                string = I18n.tr("relation");
            }
            if ((string2 = relation.get("admin_level")) != null) {
                string = string + "[" + string2 + "]";
            }
            string = string + " (";
            String string4 = null;
            for (String string5 : DefaultNameFormatter.getNamingtagsForRelations()) {
                if (string5.equals("name")) {
                    string4 = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName();
                } else if (string5.equals(":LocationCode")) {
                    for (String object : relation.keySet()) {
                        if (!object.endsWith(string5)) continue;
                        string4 = relation.get(object);
                        break;
                    }
                } else {
                    String string6 = relation.get(string5);
                    if (string6 != null) {
                        string4 = I18n.tr(string6);
                    }
                }
                if (string4 == null) continue;
                break;
            }
            string = string4 == null ? string + Long.toString(relation.getId()) + ", " : string + "\"" + string4 + "\", ";
            int n = relation.getMembersCount();
            string = string + I18n.trn("{0} member", "{0} members", n, n);
            boolean bl = false;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getMember().isIncomplete()) continue;
                bl = true;
                break;
            }
            if (bl) {
                string = string + ", " + I18n.tr("incomplete");
            }
            string = string + ")";
        }
        string = this.decorateNameWithId(string, relation);
        return string;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(OsmPrimitive osmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(osmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(osmPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = osmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void decorateNameWithId(StringBuilder stringBuilder, HistoryOsmPrimitive historyOsmPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            stringBuilder.append(I18n.tr(" [id: {0}]", historyOsmPrimitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode historyNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyNode.getLocalName() : historyNode.getName();
        if (string == null) {
            stringBuilder.append(historyNode.getId());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(" (").append(historyNode.getCoords().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(historyNode.getCoords().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        this.decorateNameWithId(stringBuilder, historyNode);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryWay historyWay) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyWay.getLocalName() : historyWay.getName();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0 && historyWay.get("ref") != null) {
            stringBuilder.append(historyWay.get("ref"));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.get("highway") != null ? I18n.tr("highway") : (historyWay.get("railway") != null ? I18n.tr("railway") : (historyWay.get("waterway") != null ? I18n.tr("waterway") : (historyWay.get("landuse") != null ? I18n.tr("landuse") : ""))));
        }
        int n = historyWay.isClosed() ? historyWay.getNumNodes() - 1 : historyWay.getNumNodes();
        String string2 = I18n.trn("{0} node", "{0} nodes", n, n);
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.getId());
        }
        stringBuilder.append(stringBuilder.length() > 0 ? " (" + string2 + ")" : string2);
        this.decorateNameWithId(stringBuilder, historyWay);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryRelation historyRelation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (historyRelation.get("type") != null) {
            stringBuilder.append(historyRelation.get("type"));
        } else {
            stringBuilder.append(I18n.tr("relation"));
        }
        stringBuilder.append(" (");
        String string = null;
        HashSet<String> hashSet = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String string2 : historyRelation.getTags().keySet()) {
            if (hashSet.contains(string2.trim()) && (string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyRelation.getLocalName() : historyRelation.getName()) == null) {
                string = historyRelation.get(string2);
            }
            if (string == null) continue;
            break;
        }
        if (string == null) {
            stringBuilder.append(Long.toString(historyRelation.getId())).append(", ");
        } else {
            stringBuilder.append("\"").append(string).append("\", ");
        }
        int n = historyRelation.getNumMembers();
        stringBuilder.append(I18n.trn("{0} member", "{0} members", n, n)).append(")");
        this.decorateNameWithId(stringBuilder, historyRelation);
        return stringBuilder.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive historyOsmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(historyOsmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(historyOsmPrimitive.getTags().keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = historyOsmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    static {
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "public_transport", ":LocationCode", "note"};
        namingTagsForRelations = null;
    }
}

