/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MoveNodeAction
extends JosmAction {
    public MoveNodeAction() {
        super(I18n.tr("Move Node..."), "movenode", I18n.tr("Edit latitude and longitude of a node."), null, true);
        this.putValue("help", HelpUtil.ht("/Action/MoveNode"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.getCurrentDataSet().getSelectedNodes().size() != 1) {
            return;
        }
        LatLonDialog latLonDialog = new LatLonDialog(Main.parent);
        Node node = (Node)this.getCurrentDataSet().getSelectedNodes().toArray()[0];
        latLonDialog.setCoordinates(node.getCoor());
        latLonDialog.setVisible(true);
        if (latLonDialog.isCanceled()) {
            return;
        }
        LatLon latLon = latLonDialog.getCoordinates();
        if (latLon == null) {
            return;
        }
        Main.main.undoRedo.add(new MoveCommand(node, latLon));
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (collection.size() == 1 && collection.toArray()[0] instanceof Node) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

