/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAreasAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;

    public JoinAreasAction() {
        super(I18n.tr("Join overlapping Areas"), "joinareas", I18n.tr("Joins areas that overlap each other"), Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tool: {0}", I18n.tr("Join overlapping Areas")), 74, 3, 1), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LinkedList<Way> linkedList = new LinkedList<Way>(Main.main.getCurrentDataSet().getSelectedWays());
        if (linkedList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one closed way that should be joined."));
            return;
        }
        if (linkedList.size() > 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only up to two areas can be joined at the moment."));
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Way object : linkedList) {
            if (!object.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("\"{0}\" is not closed and therefore cannot be joined.", object.getName()));
                return;
            }
            arrayList.addAll(object.getNodes());
        }
        Area area = Main.main.getCurrentDataSet().getDataSourceArea();
        if (area != null) {
            for (Node node : arrayList) {
                if (area.contains(node.getCoor())) continue;
                int n = JOptionPane.showConfirmDialog(Main.parent, I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", linkedList.size()) + "\n" + I18n.tr("This can lead to nodes being deleted accidentally.") + "\n" + I18n.tr("Are you really sure to continue?"), I18n.tr("Please abort if you are not sure"), 0, 2);
                if (n == 0) break;
                return;
            }
        }
        if (this.joinAreas(linkedList.getFirst(), linkedList.getLast())) {
            Main.map.mapView.repaint();
            DataSet dataSet = Main.main.getCurrentDataSet();
            dataSet.fireSelectionChanged();
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No intersection found. Nothing was changed."));
        }
    }

    private boolean joinAreas(Way way, Way way2) {
        ArrayList<OsmPrimitive> arrayList;
        boolean bl = way.equals(way2);
        boolean bl2 = false;
        if (!bl) {
            int n = 0;
            if (this.checkForTagConflicts(way, way2)) {
                return true;
            }
            if (this.joinAreas(way, way)) {
                ++n;
            }
            if (this.joinAreas(way2, way2)) {
                ++n;
            }
            bl2 = n > 0;
            this.cmdsCount = n;
        }
        if ((arrayList = this.addIntersections(way, way2)).size() == 0) {
            return bl2;
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> arrayList2 = this.removeFromRelations(way);
        if (!bl) {
            arrayList2.addAll(this.removeFromRelations(way2));
        }
        boolean bl3 = arrayList2.size() > 0;
        Collection<Way> collection = this.splitWaysOnNodes(way, way2, arrayList);
        Collection<Node> collection2 = this.getNodesFromWays(collection);
        Collection<Way> collection3 = this.findInnerWays(collection, collection2);
        Way way3 = this.joinOuterWays(collection, collection3);
        ArrayList<Way> arrayList3 = this.fixMultipolygons(collection3, way3, bl);
        if (collection3 != null && collection3.size() > 0) {
            this.cmds.add(DeleteCommand.delete(Main.map.mapView.getEditLayer(), collection3, true));
        }
        this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        this.addOwnMultigonRelation(arrayList3, way3, arrayList2);
        this.fixRelations(arrayList2, way3);
        this.commitCommands(I18n.marktr("Fix relations"));
        this.stripTags(arrayList3);
        this.makeCommitsOneAction(bl ? I18n.marktr("Joined self-overlapping area") : I18n.marktr("Joined overlapping areas"));
        if (bl3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some of the ways were part of relations that have been modified. Please verify no errors have been introduced."));
        }
        return true;
    }

    private boolean checkForTagConflicts(Way way, Way way2) {
        Way way322;
        ArrayList<Way> arrayList = new ArrayList<Way>();
        arrayList.add(way);
        arrayList.add(way2);
        TreeMap treeMap = new TreeMap();
        for (Way way322 : arrayList) {
            for (String object2 : way322.keySet()) {
                if (!treeMap.containsKey(object2)) {
                    treeMap.put(object2, new TreeSet());
                }
                ((Set)treeMap.get(object2)).add(way322.get(object2));
            }
        }
        Way way4 = new Way(way);
        way322 = new Way(way2);
        HashMap hashMap = new HashMap();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (Map.Entry entry : treeMap.entrySet()) {
            if (TigerUtils.isTigerTag((String)entry.getKey())) {
                String string = TigerUtils.combineTags((String)entry.getKey(), (Set)entry.getValue());
                way4.put((String)entry.getKey(), string);
                way322.put((String)entry.getKey(), string);
                continue;
            }
            if (((Set)entry.getValue()).size() > 1) {
                if ("created_by".equals(entry.getKey())) {
                    way4.remove("created_by");
                    way322.remove("created_by");
                    continue;
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(((Set)entry.getValue()).toArray());
                jComboBox.setEditable(true);
                jPanel.add((Component)new JLabel((String)entry.getKey()), GBC.std());
                jPanel.add(Box.createHorizontalStrut(10), GBC.std());
                jPanel.add(jComboBox, GBC.eol());
                hashMap.put(entry.getKey(), jComboBox);
                continue;
            }
            String string = (String)((Set)entry.getValue()).iterator().next();
            way4.put((String)entry.getKey(), string);
            way322.put((String)entry.getKey(), string);
        }
        if (hashMap.isEmpty()) {
            return false;
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Enter values for all conflicts."), new String[]{I18n.tr("Solve Conflicts"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"dialogs/conflict.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return true;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = ((JComboBox)entry.getValue()).getEditor().getItem().toString();
            way4.put((String)entry.getKey(), string);
            way322.put((String)entry.getKey(), string);
        }
        this.cmds.add(new ChangeCommand(way, way4));
        this.cmds.add(new ChangeCommand(way2, way322));
        this.commitCommands(I18n.marktr("Fix tag conflicts"));
        return false;
    }

    private ArrayList<OsmPrimitive> addIntersections(Way way, Way way2) {
        int n;
        boolean bl = way.equals(way2);
        int n2 = way.getNodesCount();
        int n3 = way2.getNodesCount();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        ArrayList<NodeToSegs> arrayList2 = new ArrayList<NodeToSegs>();
        ArrayList<NodeToSegs> arrayList3 = new ArrayList<NodeToSegs>();
        int n4 = n = bl ? 1 : 0;
        while (n < n2 - 1) {
            int n5;
            int n6 = n5 = bl ? n + 2 : 0;
            while (n5 < n3 - 1) {
                if (way.getNode(n).equals(way2.getNode(n5)) || way.getNode(n + 1).equals(way2.getNode(n5))) {
                    arrayList.add(way2.getNode(n5));
                } else if (way.getNode(n).equals(way2.getNode(n5 + 1)) || way.getNode(n + 1).equals(way2.getNode(n5 + 1))) {
                    arrayList.add(way2.getNode(n5 + 1));
                } else {
                    LatLon latLon = JoinAreasAction.getLineLineIntersection(way.getNode(n).getEastNorth().east(), way.getNode(n).getEastNorth().north(), way.getNode(n + 1).getEastNorth().east(), way.getNode(n + 1).getEastNorth().north(), way2.getNode(n5).getEastNorth().east(), way2.getNode(n5).getEastNorth().north(), way2.getNode(n5 + 1).getEastNorth().east(), way2.getNode(n5 + 1).getEastNorth().north());
                    if (latLon != null) {
                        Node node = new Node(latLon);
                        this.cmds.add(new AddCommand(node));
                        arrayList.add(node);
                        arrayList2.add(new NodeToSegs(n, node, way.getNode(n).getCoor()));
                        if (bl) {
                            arrayList2.add(new NodeToSegs(n5, node, way.getNode(n5).getCoor()));
                        } else {
                            arrayList3.add(new NodeToSegs(n5, node, way2.getNode(n5).getCoor()));
                        }
                    }
                }
                ++n5;
            }
            ++n;
        }
        this.addNodesToWay(way, arrayList2);
        if (!bl) {
            this.addNodesToWay(way2, arrayList3);
        }
        return arrayList;
    }

    private static LatLon getLineLineIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (!Line2D.linesIntersect(d, d2, d3, d4, d5, d6, d7, d8)) {
            return null;
        }
        double d9 = d4 - d2;
        double d10 = d - d3;
        double d11 = d3 * d2 - d * d4;
        double d12 = d8 - d6;
        double d13 = d5 - d7;
        double d14 = d7 * d6 - d5 * d8;
        double d15 = d9 * d13 - d12 * d10;
        if (d15 == 0.0) {
            return null;
        }
        return Main.proj.eastNorth2latlon(new EastNorth((d10 * d14 - d13 * d11) / d15, (d12 * d11 - d9 * d14) / d15));
    }

    private void addNodesToWay(Way way, ArrayList<NodeToSegs> arrayList) {
        if (arrayList.size() == 0) {
            return;
        }
        Way way2 = new Way(way);
        Collections.sort(arrayList);
        int n = 1;
        for (NodeToSegs nodeToSegs : arrayList) {
            way2.addNode(nodeToSegs.pos + n, nodeToSegs.n);
            ++n;
        }
        this.cmds.add(new ChangeCommand(way, way2));
    }

    private void commitCommands(String string) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr(string), this.cmds);
                Main.main.undoRedo.add(sequenceCommand);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    private ArrayList<RelationRole> removeFromRelations(OsmPrimitive osmPrimitive) {
        ArrayList<RelationRole> arrayList = new ArrayList<RelationRole>();
        block0: for (Relation relation : Main.main.getCurrentDataSet().getRelations()) {
            if (relation.isDeleted()) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember() != osmPrimitive) continue;
                Relation relation2 = new Relation(relation);
                List<RelationMember> list = relation2.getMembers();
                list.remove(relationMember);
                relation2.setMembers(list);
                this.cmds.add(new ChangeCommand(relation, relation2));
                RelationRole relationRole = new RelationRole(relation, relationMember.getRole());
                if (arrayList.contains(relationRole)) continue block0;
                arrayList.add(relationRole);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return arrayList;
    }

    private Collection<Way> splitWaysOnNodes(Way way, Way way2, Collection<OsmPrimitive> collection) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        arrayList.add(way);
        if (!way.equals(way2)) {
            arrayList.add(way2);
        }
        ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
        for (Way way3 : arrayList) {
            collection.add(way3);
            Main.main.getCurrentDataSet().setSelected(collection);
            collection.remove(way3);
            new SplitWayAction().actionPerformed(null);
            ++this.cmdsCount;
            arrayList2.addAll(Main.main.getCurrentDataSet().getSelectedWays());
        }
        return JoinAreasAction.osmprim2way(arrayList2);
    }

    private static Collection<Way> osmprim2way(Collection<OsmPrimitive> collection) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            arrayList.add((Way)osmPrimitive);
        }
        return arrayList;
    }

    private Collection<Node> getNodesFromWays(Collection<Way> collection) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Way way : collection) {
            arrayList.addAll(way.getNodes());
        }
        return arrayList;
    }

    private Collection<Way> findInnerWays(Collection<Way> collection, Collection<Node> collection2) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Way way : collection) {
            Polygon polygon = new Polygon();
            for (Node node : way.getNodes()) {
                polygon.addPoint(this.latlonToXY(node.getCoor().lat()), this.latlonToXY(node.getCoor().lon()));
            }
            for (Node node : collection2) {
                if (way.containsNode(node) || !polygon.contains(this.latlonToXY(node.getCoor().lat()), this.latlonToXY(node.getCoor().lon()))) continue;
                this.getWaysByNode(arrayList, collection, node);
            }
        }
        return arrayList;
    }

    private int latlonToXY(double d) {
        return (int)Math.round(d * 1000000.0);
    }

    private void getWaysByNode(Collection<Way> collection, Collection<Way> collection2, Node node) {
        for (Way way : collection2) {
            if (!way.containsNode(node) || collection.contains(way)) continue;
            collection.add(way);
        }
    }

    private Way joinOuterWays(Collection<Way> collection, Collection<Way> collection2) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Way way : collection) {
            if (collection2.contains(way)) continue;
            if (way.getNodesCount() <= 2) {
                this.cmds.add(new DeleteCommand(way));
                continue;
            }
            arrayList.add(way);
        }
        this.commitCommands(I18n.marktr("Join Areas: Remove Short Ways"));
        return this.closeWay(this.joinWays(arrayList));
    }

    private Way closeWay(Way way) {
        if (way.isClosed()) {
            return way;
        }
        Main.main.getCurrentDataSet().setSelected(way);
        Way way2 = new Way(way);
        way2.addNode(way2.firstNode());
        this.cmds.add(new ChangeCommand(way, way2));
        this.commitCommands(I18n.marktr("Closed Way"));
        return (Way)Main.main.getCurrentDataSet().getSelectedWays().toArray()[0];
    }

    private Way joinWays(ArrayList<Way> arrayList) {
        if (arrayList.size() < 2) {
            return arrayList.get(0);
        }
        Way way = null;
        for (Way way2 : arrayList) {
            if (way == null) {
                way = way2;
                continue;
            }
            if (way.getNode(0).equals(way2.getNode(0)) || way.getNode(way.getNodesCount() - 1).equals(way2.getNode(way2.getNodesCount() - 1))) {
                Main.main.getCurrentDataSet().setSelected(way2);
                new ReverseWayAction().actionPerformed(null);
                ++this.cmdsCount;
            }
            way = way2;
        }
        way = new CombineWayAction().combineWays(arrayList);
        if (way != null) {
            ++this.cmdsCount;
        }
        return way;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Way> fixMultipolygons(Collection<Way> collection, Way way, boolean bl) {
        Collection<Node> collection2 = this.getNodesFromWays(collection);
        List<Node> list = way.getNodes();
        ArrayList<Way> arrayList = new ArrayList<Way>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        block0: for (Way object : collection) {
            boolean bl2 = false;
            for (Node node : object.getNodes()) {
                if (list.contains(node)) {
                    if (bl) continue;
                    continue block0;
                }
                if (bl2 || !collection2.contains(node)) continue;
                bl2 = true;
            }
            if (!bl2 || object.getNodesCount() < 2) continue;
            arrayList2.add(object);
        }
        this.removeAlmostAlikeWays(arrayList2);
        for (int i = 0; i < 2; ++i) {
            void var9_18;
            Object var9_12 = null;
            block3: do {
                this.removePartlyUnconnectedWays(arrayList2);
                Object var9_14 = null;
                for (Way way2 : arrayList2) {
                    if (way2.isClosed()) {
                        if (!this.wayIsCollapsed(way2)) {
                            collection.remove(way2);
                            arrayList.add(way2);
                        }
                        Way way3 = way2;
                        arrayList2.remove(way2);
                        continue block3;
                    }
                    ArrayList<Way> arrayList3 = new ArrayList<Way>();
                    for (Way way4 : arrayList2) {
                        int n = 0;
                        if (way2.equals(way4)) continue;
                        if (way4.isFirstLastNode(way2.firstNode())) {
                            ++n;
                        }
                        if (way4.isFirstLastNode(way2.lastNode())) {
                            ++n;
                        }
                        if (n == 2) {
                            if (arrayList3.size() > 0) {
                                arrayList3.clear();
                            }
                            arrayList3.add(way4);
                            break;
                        }
                        if (n <= 0) continue;
                        arrayList3.add(way4);
                    }
                    if (!(i == 0 ? arrayList3.size() == 1 : arrayList3.size() > 0)) continue;
                    ArrayList arrayList4 = new ArrayList();
                    arrayList4.add(way2);
                    arrayList4.add(arrayList3.get(0));
                    Way way5 = this.joinWays(arrayList4);
                    if (way5 == null) continue;
                    collection.removeAll(arrayList4);
                    arrayList2.removeAll(arrayList4);
                    List<Node> list2 = way5.getNodes();
                    collection.add(way5);
                    arrayList2.add(way5);
                    continue block3;
                }
            } while (var9_18 != null);
        }
        return arrayList;
    }

    private void removeAlmostAlikeWays(ArrayList<Way> arrayList) {
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            Way way = arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Way way2 = arrayList.get(j);
                ArrayList<Node> arrayList3 = new ArrayList<Node>(way2.getNodes());
                Collections.reverse(arrayList3);
                if (!((Object)way.getNodes()).equals(way2.getNodes()) && !((Object)way.getNodes()).equals(arrayList3)) continue;
                arrayList2.add(way);
                continue block0;
            }
        }
        arrayList.removeAll(arrayList2);
    }

    private void removePartlyUnconnectedWays(ArrayList<Way> arrayList) {
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way way : arrayList) {
            if (way.isClosed()) continue;
            boolean bl = false;
            boolean bl2 = false;
            for (Way way2 : arrayList) {
                if (way.equals(way2)) continue;
                if (way2.isFirstLastNode(way.firstNode())) {
                    bl = true;
                }
                if (!way2.isFirstLastNode(way.lastNode())) continue;
                bl2 = true;
            }
            if (bl && bl2) continue;
            arrayList2.add(way);
        }
        arrayList.removeAll(arrayList2);
    }

    private boolean wayIsCollapsed(Way way) {
        if (way.getNodesCount() <= 3) {
            return true;
        }
        Way way2 = new Way(way);
        int n = 0;
        for (Node node : way.getNodes()) {
            way2.removeNode(node);
            if (way2.containsNode(node)) {
                ++n;
            }
            if (n != 2) continue;
            return true;
        }
        return false;
    }

    private void addOwnMultigonRelation(Collection<Way> collection, Way way, ArrayList<RelationRole> arrayList) {
        if (collection.size() == 0) {
            return;
        }
        Relation relation = new Relation();
        relation.put("type", "multipolygon");
        for (Way way2 : collection) {
            relation.addMember(new RelationMember("inner", way2));
        }
        this.cmds.add(new AddCommand(relation));
        arrayList.add(new RelationRole(relation, "outer"));
    }

    private void fixRelations(ArrayList<RelationRole> arrayList, Way way) {
        ArrayList<RelationRole> arrayList2 = new ArrayList<RelationRole>();
        for (RelationRole object : arrayList) {
            if (object.rel.get("type") != null && object.rel.get("type").equalsIgnoreCase("multipolygon") && object.role.equalsIgnoreCase("outer")) {
                arrayList2.add(object);
                continue;
            }
            Object object2 = new Relation(object.rel);
            ((Relation)object2).addMember(new RelationMember(object.role, way));
            this.cmds.add(new ChangeCommand(object.rel, (OsmPrimitive)object2));
        }
        Object object = null;
        switch (arrayList2.size()) {
            case 0: {
                return;
            }
            case 1: {
                object = new Relation(((RelationRole)arrayList2.get((int)0)).rel);
                ((Relation)object).addMember(new RelationMember(((RelationRole)arrayList2.get((int)0)).role, way));
                this.cmds.add(new ChangeCommand(((RelationRole)arrayList2.get((int)0)).rel, (OsmPrimitive)object));
                return;
            }
        }
        object = new Relation();
        for (Object object2 : arrayList2) {
            for (RelationMember relationMember : ((RelationRole)object2).rel.getMembers()) {
                if (((Relation)object).getMembers().contains(relationMember)) continue;
                ((Relation)object).addMember(relationMember);
            }
            for (String string : ((RelationRole)object2).rel.keySet()) {
                ((OsmPrimitive)object).put(string, ((RelationRole)object2).rel.get(string));
            }
            this.cmds.add(new DeleteCommand(((RelationRole)object2).rel));
        }
        ((Relation)object).addMember(new RelationMember("outer", way));
        this.cmds.add(new AddCommand((OsmPrimitive)object));
    }

    private void stripTags(Collection<Way> collection) {
        for (Way way : collection) {
            this.stripTags(way);
        }
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    private void stripTags(Way way) {
        if (way.getKeys() == null) {
            return;
        }
        Way way2 = new Way(way);
        for (String string : way.keySet()) {
            way2.remove(string);
        }
        this.cmds.add(new ChangeCommand(way, way2));
    }

    private void makeCommitsOneAction(String string) {
        int n;
        UndoRedoHandler undoRedoHandler = Main.main.undoRedo;
        this.cmds.clear();
        for (n = Math.max(undoRedoHandler.commands.size() - this.cmdsCount, 0); n < undoRedoHandler.commands.size(); ++n) {
            this.cmds.add(undoRedoHandler.commands.get(n));
        }
        for (n = 0; n < this.cmds.size(); ++n) {
            undoRedoHandler.undo();
        }
        this.commitCommands(string == null ? I18n.marktr("Join Areas Function") : string);
        this.cmdsCount = 0;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        public RelationRole(Relation relation, String string) {
            this.rel = relation;
            this.role = string;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelationRole)) {
                return false;
            }
            RelationRole relationRole = (RelationRole)object;
            return relationRole.role.equals(this.role) && relationRole.rel.equals(this.rel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeToSegs
    implements Comparable<NodeToSegs> {
        public int pos;
        public Node n;
        public double dis;

        public NodeToSegs(int n, Node node, LatLon latLon) {
            this.pos = n;
            this.n = node;
            this.dis = node.getCoor().greatCircleDistance(latLon);
        }

        @Override
        public int compareTo(NodeToSegs nodeToSegs) {
            if (this.pos == nodeToSegs.pos) {
                return this.dis - nodeToSegs.dis > 0.0 ? 1 : -1;
            }
            return this.pos - nodeToSegs.pos;
        }

        public int hashCode() {
            return this.pos;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeToSegs) {
                return this.compareTo((NodeToSegs)object) == 0;
            }
            return false;
        }
    }
}

