/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String explainOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        osmApiInitializationException.printStackTrace();
        String string = I18n.tr("<html>Failed to initialize communication with the OSM server {0}.<br>Check the server URL in your preferences and your internet connection.</html>", Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api"));
        return string;
    }

    public static String explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException missingOAuthAccessTokenException) {
        missingOAuthAccessTokenException.printStackTrace();
        String string = I18n.tr("<html>Failed to authenticate at the OSM server ''{0}''.<br>You are using OAuth to authenticate but currently there is no<br>OAuth Access Token configured.<br>Please open the Preferences Dialog and generate or enter an Access Token.</html>", Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api"));
        return string;
    }

    public static String explainDeletedRelationStillInUse(OsmApiException osmApiException, long l, long l2) {
        String string = I18n.tr("<html><strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relation {1}.<br>Please load relation {1}, remove the reference to relation {0}, and upload again.</html>", l, l2);
        return string;
    }

    public static String explainPreconditionFailed(OsmApiException osmApiException) {
        String string;
        Pattern pattern;
        Matcher matcher;
        osmApiException.printStackTrace();
        String string2 = osmApiException.getErrorHeader();
        if (string2 != null && (matcher = (pattern = Pattern.compile(string = "Precondition failed: The relation (\\d+) is used in relation (\\d+)\\.")).matcher(string2)).matches()) {
            long l = Long.parseLong(matcher.group(1));
            long l2 = Long.parseLong(matcher.group(2));
            return ExceptionUtil.explainDeletedRelationStillInUse(osmApiException, l, l2);
        }
        string2 = I18n.tr("<html>Uploading to the server <strong>failed</strong> because your current<br>dataset violates a precondition.<br>The error message is:<br>{0}</html>", osmApiException.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        return string2;
    }

    public static String explainFailedBasicAuthentication(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        return I18n.tr("<html>Authentication at the OSM server with the username ''{0}'' failed.<br>Please check the username and the password in the JOSM preferences.</html>", Main.pref.get("osm-server.username"));
    }

    public static String explainFailedOAuthAuthentication(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        return I18n.tr("<html>Authentication at the OSM server with the OAuth token ''{0}'' failed.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey());
    }

    public static String explainFailedOAuthAuthorisation(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        return I18n.tr("<html>Authorisation at the OSM server with the OAuth token ''{0}'' failed.<br>The token is not authorised to access the protected resource<br>''{1}''.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey(), osmApiException.getAccessedUrl() == null ? I18n.tr("unknown") : osmApiException.getAccessedUrl());
    }

    public static String explainClientTimeout(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        return I18n.tr("<html>Communication with the OSM server ''{0}'' timed out. Please retry later.</html>", OsmApi.getOsmApi().getBaseUrl());
    }

    public static String explainGenericOsmApiException(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        String string = osmApiException.getErrorHeader();
        if (string == null) {
            string = osmApiException.getErrorBody();
        }
        if (string == null) {
            string = I18n.tr("no error message available");
        }
        return I18n.tr("<html>Communication with the OSM server ''{0}''failed. The server replied<br>the following error code and the following error message:<br><strong>Error code:<strong> {1}<br><strong>Error message (untranslated)</strong>: {2}</html>", OsmApi.getOsmApi().getBaseUrl(), osmApiException.getResponseCode(), string);
    }

    public static String explainConflict(OsmApiException osmApiException) {
        osmApiException.printStackTrace();
        String string = osmApiException.getErrorHeader();
        if (string != null) {
            String string2 = "The changeset (\\d+) was closed at (.*)";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                long l = Long.parseLong(matcher.group(1));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
                Date date = null;
                try {
                    date = simpleDateFormat.parse(matcher.group(2));
                }
                catch (ParseException parseException) {
                    System.err.println(I18n.tr("Failed to parse date ''{0}'' replied by server.", matcher.group(2)));
                    parseException.printStackTrace();
                }
                if (date == null) {
                    string = I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed <br>because it has already been closed.</html>", l);
                } else {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat();
                    string = I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed<br> because it has already been closed on {1}.</html>", l, simpleDateFormat2.format(date));
                }
                return string;
            }
            string = I18n.tr("<html>The server reported that it has detected a conflict.<br>Error message (untranslated):<br>{0}</html>", string);
        }
        string = I18n.tr("<html>The server reported that it has detected a conflict.</html>");
        return string;
    }

    public static String explainChangesetClosedException(ChangesetClosedException changesetClosedException) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        String string = I18n.tr("<html>Failed to upload to changeset <strong>{0}</strong><br>because it has already been closed on {1}.</html>", changesetClosedException.getChangesetId(), simpleDateFormat.format(changesetClosedException.getClosedOn()));
        changesetClosedException.printStackTrace();
        return string;
    }

    public static String explainGeneric(Exception exception) {
        String string = exception.getMessage();
        if (string == null || string.trim().equals("")) {
            string = exception.toString();
        }
        exception.printStackTrace();
        return string;
    }

    public static String explainSecurityException(OsmTransferException osmTransferException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("unknown");
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string3 = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''<br>for security reasons. This is most likely because you are running<br>in an applet and because you did not load your applet from ''{1}''.</html>", string, string2);
        return string3;
    }

    public static String explainNestedSocketException(OsmTransferException osmTransferException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Please check your internet connection.</html>", string);
        osmTransferException.printStackTrace();
        return string2;
    }

    public static String explainNestedIOException(OsmTransferException osmTransferException) {
        IOException iOException = ExceptionUtil.getNestedException(osmTransferException, IOException.class);
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("<html>Failed to upload data to or download data from<br>''{0}''<br>due to a problem with transferring data.<br>Details(untranslated): {1}</html>", string, iOException.getMessage());
        osmTransferException.printStackTrace();
        return string2;
    }

    public static String explainNestedIllegalDataException(OsmTransferException osmTransferException) {
        IllegalDataException illegalDataException = ExceptionUtil.getNestedException(osmTransferException, IllegalDataException.class);
        String string = I18n.tr("<html>Failed to download data. Its format is either unsupported, ill-formed, and/or inconsistent.<br><br>Details (untranslated): {0}</html>", illegalDataException.getMessage());
        osmTransferException.printStackTrace();
        return string;
    }

    public static String explainInternalServerError(OsmTransferException osmTransferException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("<html>The OSM server<br>''{0}''<br>reported an internal server error.<br>This is most likely a temporary problem. Please try again later.</html>", string);
        osmTransferException.printStackTrace();
        return string2;
    }

    public static String explainBadRequest(OsmApiException osmApiException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("The OSM server ''{0}'' reported a bad request.<br>", string);
        if (osmApiException.getErrorHeader() != null && (osmApiException.getErrorHeader().startsWith("The maximum bbox") || osmApiException.getErrorHeader().startsWith("You requested too many nodes"))) {
            string2 = string2 + "<br>" + I18n.tr("The area you tried to download is too big or your request was too large.<br>Either request a smaller area or use an export file provided by the OSM community.");
        } else if (osmApiException.getErrorHeader() != null) {
            string2 = string2 + I18n.tr("<br>Error message(untranslated): {0}", osmApiException.getErrorHeader());
        }
        string2 = "<html>" + string2 + "</html>";
        osmApiException.printStackTrace();
        return string2;
    }

    public static String explainNotFound(OsmApiException osmApiException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("The OSM server ''{0}'' does not know about an object<br>you tried to read, update, or delete. Either the respective object<br>does not exist on the server or you are using an invalid URL to access<br>it. Please carefully check the server''s address ''{0}'' for typos.", string);
        string2 = "<html>" + string2 + "</html>";
        osmApiException.printStackTrace();
        return string2;
    }

    public static String explainNestedUnkonwnHostException(OsmTransferException osmTransferException) {
        String string = OsmApi.getOsmApi().getBaseUrl();
        String string2 = I18n.tr("unknown");
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string3 = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Host name ''{1}'' could not be resolved. <br>Please check the API URL in your preferences and your internet connection.</html>", string, string2);
        osmTransferException.printStackTrace();
        return string3;
    }

    protected static <T> T getNestedException(Exception exception, Class<T> clazz) {
        Throwable throwable;
        for (throwable = exception; throwable != null && !clazz.isInstance(throwable); throwable = throwable.getCause()) {
        }
        if (throwable == null) {
            return null;
        }
        if (clazz.isInstance(throwable)) {
            return clazz.cast(throwable);
        }
        return null;
    }

    public static String explainOsmTransferException(OsmTransferException osmTransferException) {
        if (ExceptionUtil.getNestedException(osmTransferException, SecurityException.class) != null) {
            return ExceptionUtil.explainSecurityException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, SocketException.class) != null) {
            return ExceptionUtil.explainNestedSocketException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, UnknownHostException.class) != null) {
            return ExceptionUtil.explainNestedUnkonwnHostException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, IOException.class) != null) {
            return ExceptionUtil.explainNestedIOException(osmTransferException);
        }
        if (osmTransferException instanceof OsmApiInitializationException) {
            return ExceptionUtil.explainOsmApiInitializationException((OsmApiInitializationException)osmTransferException);
        }
        if (osmTransferException instanceof ChangesetClosedException) {
            return ExceptionUtil.explainChangesetClosedException((ChangesetClosedException)osmTransferException);
        }
        if (osmTransferException instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)osmTransferException;
            if (osmApiException.getResponseCode() == 412) {
                return ExceptionUtil.explainPreconditionFailed(osmApiException);
            }
            if (osmApiException.getResponseCode() == 410) {
                return ExceptionUtil.explainGoneForUnknownPrimitive(osmApiException);
            }
            if (osmApiException.getResponseCode() == 500) {
                return ExceptionUtil.explainInternalServerError(osmApiException);
            }
            if (osmApiException.getResponseCode() == 400) {
                return ExceptionUtil.explainBadRequest(osmApiException);
            }
        }
        return ExceptionUtil.explainGeneric(osmTransferException);
    }

    public static String explainGoneForUnknownPrimitive(OsmApiException osmApiException) {
        String string = I18n.tr("<html>The server reports that an object is deleted.<br><strong>Uploading failed</strong> if you tried to update or delete this object.<br> <strong>Downloading failed</strong> if you tried to download this object.<br><br>The error message is:<br>{0}</html>", osmApiException.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        return string;
    }

    public static String explainException(Exception exception) {
        String string = "";
        string = exception instanceof OsmTransferException ? ExceptionUtil.explainOsmTransferException((OsmTransferException)exception) : ExceptionUtil.explainGeneric(exception);
        exception.printStackTrace();
        return string;
    }
}

