/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.tools.I18n;

class FilenameCellEditor
extends JPanel
implements TableCellEditor {
    private JTextField tfFileName;
    private CopyOnWriteArrayList<CellEditorListener> listeners = new CopyOnWriteArrayList();
    private File value;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tfFileName = new JTextField();
        this.add((Component)this.tfFileName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add(new JButton(new LaunchFileChooserAction()));
        this.tfFileName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                FilenameCellEditor.this.tfFileName.selectAll();
            }
        });
    }

    public FilenameCellEditor() {
        this.build();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null) {
            this.listeners.addIfAbsent(cellEditorListener);
        }
    }

    protected void fireEditingCanceled() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.value = this.tfFileName.getText() == null || this.tfFileName.getText().trim().equals("") ? null : new File(this.tfFileName.getText());
        this.fireEditingStopped();
        return true;
    }

    public void setInitialValue(File file) {
        this.value = file;
        if (file == null) {
            this.tfFileName.setText("");
        } else {
            this.tfFileName.setText(file.toString());
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
        this.setInitialValue(saveLayerInfo.getFile());
        this.tfFileName.selectAll();
        return this;
    }

    class LaunchFileChooserAction
    extends AbstractAction {
        public LaunchFileChooserAction() {
            this.putValue("Name", "...");
            this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Select filename"), "osm");
            if (file != null) {
                FilenameCellEditor.this.tfFileName.setText(file.toString());
                FilenameCellEditor.this.tfFileName.selectAll();
            }
        }
    }
}

