/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePaintVisitor
extends AbstractVisitor
implements PaintVisitor {
    protected Graphics2D g;
    protected NavigatableComponent nc;
    public boolean inactive;
    protected static final double PHI = Math.toRadians(20.0);
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color nodeColor;
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color incompleteColor;
    protected Color backgroundColor;
    protected Color highlightColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showRelevantDirectionsOnly;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected int defaultSegmentWidth;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;
    protected Color currentColor = null;
    protected GeneralPath currentPath = new GeneralPath();
    DataSet ds;
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);

    public void getColors() {
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.incompleteColor = PaintColors.INCOMPLETE_WAY.get();
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
    }

    protected void getSettings(boolean bl) {
        MapPaintSettings mapPaintSettings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = mapPaintSettings.isShowDirectionArrow();
        this.showRelevantDirectionsOnly = mapPaintSettings.isShowRelevantDirectionsOnly();
        this.showHeadArrowOnly = mapPaintSettings.isShowHeadArrowOnly();
        this.showOrderNumber = mapPaintSettings.isShowOrderNumber();
        this.selectedNodeSize = mapPaintSettings.getSelectedNodeSize();
        this.unselectedNodeSize = mapPaintSettings.getUnselectedNodeSize();
        this.connectionNodeSize = mapPaintSettings.getConnectionNodeSize();
        this.taggedNodeSize = mapPaintSettings.getTaggedNodeSize();
        this.defaultSegmentWidth = mapPaintSettings.getDefaultSegmentWidth();
        this.fillSelectedNode = mapPaintSettings.isFillSelectedNode();
        this.fillUnselectedNode = mapPaintSettings.isFillUnselectedNode();
        this.fillConnectionNode = mapPaintSettings.isFillConnectionNode();
        this.fillTaggedNode = mapPaintSettings.isFillTaggedNode();
        this.virtualNodeSize = bl ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void visitAll(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = new BBox(bounds);
        this.ds = dataSet;
        this.getSettings(bl);
        for (Relation osmPrimitive : dataSet.searchRelations(bBox)) {
            if (osmPrimitive.isDeleted() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isFiltered()) continue;
            ((OsmPrimitive)osmPrimitive).visit(this);
        }
        for (Way way : dataSet.searchWays(bBox)) {
            if (way.isDeleted() || this.ds.isSelected(way) || way.isFiltered() || !way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (Way way : dataSet.searchWays(bBox)) {
            if (way.isDeleted() || this.ds.isSelected(way) || way.isFiltered() || way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (osmPrimitive.isDeleted()) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (Node node : dataSet.searchNodes(bBox)) {
            if (node.isDeleted() || this.ds.isSelected(node) || node.isFiltered()) continue;
            ((OsmPrimitive)node).visit(this);
        }
        this.drawVirtualNodes(dataSet.searchWays(bBox));
    }

    private static final int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    @Override
    public void visit(Node node) {
        if (node.isIncomplete()) {
            return;
        }
        if (node.isHighlighted()) {
            this.drawNode(node, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.inactive || node.isDisabled() ? this.inactiveColor : (this.ds.isSelected(node) ? this.selectedColor : (node.isConnectionNode() ? (node.isTagged() ? this.taggedConnectionColor : this.connectionColor) : (node.isTagged() ? this.taggedColor : this.nodeColor)));
            int n = SimplePaintVisitor.max(this.ds.isSelected(node) ? this.selectedNodeSize : 0, node.isTagged() ? this.taggedNodeSize : 0, node.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean bl = this.ds.isSelected(node) && this.fillSelectedNode || node.isTagged() && this.fillTaggedNode || node.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(node, color, n, bl);
        }
    }

    public static boolean isLargeSegment(Point point, Point point2, int n) {
        int n2;
        int n3 = point.x - point2.x;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = point.y - point2.y) < 0) {
            n2 = -n2;
        }
        return n3 + n2 > n;
    }

    public void drawVirtualNodes(Collection<Way> collection) {
        if (this.virtualNodeSize != 0) {
            GeneralPath generalPath = new GeneralPath();
            for (Way way : collection) {
                if (!way.isUsable() || way.isFiltered() || way.isDisabled()) continue;
                this.visitVirtual(generalPath, way);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(generalPath);
        }
    }

    public void visitVirtual(GeneralPath generalPath, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                if (this.isSegmentVisible(point, point2) && SimplePaintVisitor.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    generalPath.moveTo(n - this.virtualNodeSize, n2);
                    generalPath.lineTo(n + this.virtualNodeSize, n2);
                    generalPath.moveTo(n, n2 - this.virtualNodeSize);
                    generalPath.lineTo(n, n2 + this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }

    @Override
    public void visit(Way way) {
        boolean bl;
        if (way.isIncomplete() || way.getNodesCount() < 2) {
            return;
        }
        boolean bl2 = this.ds.isSelected(way) || this.showDirectionArrow && (!this.showRelevantDirectionsOnly || way.hasDirectionKeys());
        boolean bl3 = bl = bl2 && !this.ds.isSelected(way) && this.showHeadArrowOnly;
        Color color = this.inactive || way.isDisabled() ? this.inactiveColor : (way.isHighlighted() ? this.highlightColor : (this.ds.isSelected(way) ? this.selectedColor : (!way.isTagged() ? this.untaggedWayColor : this.dfltWayColor)));
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            int n = 1;
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                this.drawSegment(point, point2, color, bl ? !iterator.hasNext() : bl2);
                if (this.showOrderNumber) {
                    this.drawOrderNumber(point, point2, n);
                }
                point = point2;
                ++n;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isIncomplete()) {
            return;
        }
        Color color = this.inactive || relation.isDisabled() ? this.inactiveColor : (this.ds.isSelected(relation) ? this.selectedColor : this.relationColor);
        this.g.setColor(color);
        for (RelationMember relationMember : relation.getMembers()) {
            Cloneable cloneable;
            if (relationMember.getMember().isIncomplete() || relationMember.getMember().isDeleted()) continue;
            if (relationMember.isNode()) {
                cloneable = this.nc.getPoint(relationMember.getNode());
                if (((Point)cloneable).x < 0 || ((Point)cloneable).y < 0 || ((Point)cloneable).x > this.nc.getWidth() || ((Point)cloneable).y > this.nc.getHeight()) continue;
                this.g.drawOval(((Point)cloneable).x - 3, ((Point)cloneable).y - 3, 6, 6);
                continue;
            }
            if (!relationMember.isWay()) continue;
            cloneable = new GeneralPath();
            boolean bl = true;
            for (Node node : relationMember.getWay().getNodes()) {
                if (node.isIncomplete() || node.isDeleted()) continue;
                Point point = this.nc.getPoint(node);
                if (bl) {
                    ((Path2D.Float)cloneable).moveTo(point.x, point.y);
                    bl = false;
                    continue;
                }
                ((Path2D.Float)cloneable).lineTo(point.x, point.y);
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape((Shape)((Object)cloneable)));
        }
    }

    protected void drawOrderNumber(Point point, Point point2, int n) {
        if (this.isSegmentVisible(point, point2) && SimplePaintVisitor.isLargeSegment(point, point2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && SimplePaintVisitor.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.displaySegments();
            Color color = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n > 1) {
            int n2 = n / 2;
            Point point = this.nc.getPoint(node);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n, n);
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
        }
    }

    protected void drawSegment(GeneralPath generalPath, Point point, Point point2, boolean bl) {
        if (this.isSegmentVisible(point, point2)) {
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point2.x, point2.y);
            if (bl) {
                double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
                generalPath.lineTo((int)((double)point2.x + 10.0 * Math.cos(d - PHI)), (int)((double)point2.y + 10.0 * Math.sin(d - PHI)));
                generalPath.moveTo((int)((double)point2.x + 10.0 * Math.cos(d + PHI)), (int)((double)point2.y + 10.0 * Math.sin(d + PHI)));
                generalPath.lineTo(point2.x, point2.y);
            }
        }
    }

    protected void drawSegment(Point point, Point point2, Color color, boolean bl) {
        if (color != this.currentColor) {
            this.displaySegments(color);
        }
        this.drawSegment(this.currentPath, point, point2, bl);
    }

    protected boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0) {
            return false;
        }
        if (rectangle.x > this.nc.getWidth()) {
            return false;
        }
        if (rectangle.y > this.nc.getHeight()) {
            return false;
        }
        if (rectangle.x + rectangle.width < 0) {
            return false;
        }
        return rectangle.y + rectangle.height >= 0;
    }

    @Override
    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    @Override
    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color color) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = color;
        }
    }

    @Override
    public void setInactive(boolean bl) {
        this.inactive = bl;
    }
}

