/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    private Storage<OsmPrimitive> allPrimitives = new Storage<OsmPrimitive>(new IdHash(), 16, true);
    private Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new IdHash());
    private List<DataSetListener> listeners = new ArrayList<DataSetListener>();
    private int updateCount;
    private int highlightUpdateCount;
    private String version;
    private QuadBuckets<Node> nodes = new QuadBuckets();
    private QuadBuckets<Way> ways = new QuadBuckets();
    private Collection<Relation> relations = new ArrayList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static final Collection<SelectionChangedListener> selListeners = Collections.synchronizedList(new LinkedList());
    LinkedHashSet<OsmPrimitive> selectedPrimitives = new LinkedHashSet();
    private Map<OsmPrimitive, List<String>> errors = new HashMap<OsmPrimitive, List<String>>();

    public int getHighlightUpdateCount() {
        return this.highlightUpdateCount;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    private <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<OsmPrimitive> predicate) {
        return new DatasetCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(OsmPrimitive.nodePredicate);
    }

    public List<Node> searchNodes(BBox bBox) {
        return this.nodes.search(bBox);
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(OsmPrimitive.wayPredicate);
    }

    public List<Way> searchWays(BBox bBox) {
        return this.ways.search(bBox);
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(OsmPrimitive.relationPredicate);
    }

    public List<Relation> searchRelations(BBox bBox) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        for (Relation relation : this.relations) {
            if (!relation.getBBox().intersects(bBox)) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(OsmPrimitive.allPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedCompletePredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPhysicalPredicate);
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(OsmPrimitive.modifiedPredicate);
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        if (this.getPrimitiveById(osmPrimitive) != null) {
            throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", osmPrimitive.toString()));
        }
        osmPrimitive.updatePosition();
        if (osmPrimitive instanceof Node) {
            this.nodes.add((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.add((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.add((Relation)osmPrimitive);
        }
        this.allPrimitives.add(osmPrimitive);
        osmPrimitive.setDataset(this);
        this.firePrimitivesAdded(Collections.singletonList(osmPrimitive), false);
    }

    public OsmPrimitive addPrimitive(PrimitiveData primitiveData) {
        OsmPrimitive osmPrimitive;
        if (primitiveData instanceof NodeData) {
            osmPrimitive = new Node();
        } else if (primitiveData instanceof WayData) {
            osmPrimitive = new Way();
        } else if (primitiveData instanceof RelationData) {
            osmPrimitive = new Relation();
        } else {
            throw new AssertionError();
        }
        osmPrimitive.setDataset(this);
        ((OsmPrimitive)osmPrimitive).load(primitiveData);
        this.addPrimitive(osmPrimitive);
        return osmPrimitive;
    }

    public void removePrimitive(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
        if (osmPrimitive == null) {
            return;
        }
        if (osmPrimitive instanceof Node) {
            this.nodes.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.remove(osmPrimitive);
        }
        this.selectedPrimitives.remove(osmPrimitive);
        this.allPrimitives.remove(osmPrimitive);
        osmPrimitive.setDataset(null);
        this.errors.remove(osmPrimitive);
        this.firePrimitivesRemoved(Collections.singletonList(osmPrimitive), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionChanged() {
        Collection<SelectionChangedListener> collection = selListeners;
        synchronized (collection) {
            List<OsmPrimitive> list = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(this.selectedPrimitives));
            for (SelectionChangedListener selectionChangedListener : selListeners) {
                selectionChangedListener.selectionChanged(list);
            }
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.selectedPrimitives) {
            if (!(osmPrimitive instanceof Way) && !(osmPrimitive instanceof Node)) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> getSelected() {
        return Collections.unmodifiableSet(this.selectedPrimitives);
    }

    public Collection<Node> getSelectedNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.selectedPrimitives.size());
        for (OsmPrimitive osmPrimitive : this.selectedPrimitives) {
            if (!(osmPrimitive instanceof Node)) continue;
            arrayList.add((Node)osmPrimitive);
        }
        return arrayList;
    }

    public Collection<Way> getSelectedWays() {
        ArrayList<Way> arrayList = new ArrayList<Way>(this.selectedPrimitives.size());
        for (OsmPrimitive osmPrimitive : this.selectedPrimitives) {
            if (!(osmPrimitive instanceof Way)) continue;
            arrayList.add((Way)osmPrimitive);
        }
        return arrayList;
    }

    public Collection<Relation> getSelectedRelations() {
        ArrayList<Relation> arrayList = new ArrayList<Relation>(this.selectedPrimitives.size() / 10);
        for (OsmPrimitive osmPrimitive : this.selectedPrimitives) {
            if (!(osmPrimitive instanceof Relation)) continue;
            arrayList.add((Relation)osmPrimitive);
        }
        return arrayList;
    }

    public boolean isSelected(OsmPrimitive osmPrimitive) {
        return this.selectedPrimitives.contains(osmPrimitive);
    }

    public void toggleSelected(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        for (PrimitiveId primitiveId : collection) {
            bl |= this.__toggleSelected(primitiveId);
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void toggleSelected(PrimitiveId ... primitiveIdArray) {
        this.toggleSelected(Arrays.asList(primitiveIdArray));
    }

    private boolean __toggleSelected(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
        if (osmPrimitive == null) {
            return false;
        }
        if (!this.selectedPrimitives.remove(osmPrimitive)) {
            this.selectedPrimitives.add(osmPrimitive);
        }
        return true;
    }

    public void setSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2 = this.selectedPrimitives.isEmpty();
        this.selectedPrimitives = new LinkedHashSet();
        this.addSelected(collection, bl);
        if (!bl2 && this.selectedPrimitives.isEmpty() && bl) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(Collection<? extends PrimitiveId> collection) {
        this.setSelected(collection, true);
    }

    public void setSelected(PrimitiveId ... primitiveIdArray) {
        if (primitiveIdArray.length == 1 && primitiveIdArray[0] == null) {
            this.setSelected(new PrimitiveId[0]);
            return;
        }
        List<PrimitiveId> list = Arrays.asList(primitiveIdArray);
        this.setSelected(list);
    }

    public void addSelected(Collection<? extends PrimitiveId> collection) {
        this.addSelected(collection, true);
    }

    public void addSelected(PrimitiveId ... primitiveIdArray) {
        this.addSelected(Arrays.asList(primitiveIdArray));
    }

    public void addSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2 = false;
        for (PrimitiveId primitiveId : collection) {
            OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
            if (osmPrimitive == null) continue;
            bl2 |= this.selectedPrimitives.add(osmPrimitive);
        }
        if (bl && bl2) {
            this.fireSelectionChanged();
        }
    }

    public void clearSelection(PrimitiveId ... primitiveIdArray) {
        this.clearSelection(Arrays.asList(primitiveIdArray));
    }

    public void clearSelection(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        for (PrimitiveId primitiveId : collection) {
            OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
            if (osmPrimitive == null) continue;
            bl |= this.selectedPrimitives.remove(osmPrimitive);
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void clearSelection() {
        if (!this.selectedPrimitives.isEmpty()) {
            this.selectedPrimitives.clear();
            this.fireSelectionChanged();
        }
    }

    public void setDisabled(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setDisabled(new OsmPrimitive[0]);
            return;
        }
        this.clearDisabled(this.allPrimitives());
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.setDisabled(true);
        }
    }

    public void setDisabled(Collection<? extends OsmPrimitive> collection) {
        this.clearDisabled(this.nodes);
        this.clearDisabled(this.ways);
        this.clearDisabled(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setDisabled(true);
        }
    }

    private void clearDisabled(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setDisabled(false);
        }
    }

    public void setFiltered(Collection<? extends OsmPrimitive> collection) {
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setFiltered(true);
        }
    }

    public void setFiltered(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setFiltered(new OsmPrimitive[0]);
            return;
        }
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.setFiltered(true);
        }
    }

    private void clearFiltered(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setFiltered(false);
        }
    }

    public DataSet clone() {
        ArrayList<Node> arrayList;
        OsmPrimitive osmPrimitive;
        DataSet dataSet = new DataSet();
        HashMap<OsmPrimitive, OsmPrimitive> hashMap = new HashMap<OsmPrimitive, OsmPrimitive>();
        for (Node object : this.nodes) {
            osmPrimitive = new Node(object);
            hashMap.put(object, osmPrimitive);
            dataSet.addPrimitive(osmPrimitive);
        }
        for (Way way : this.ways) {
            osmPrimitive = new Way(way);
            hashMap.put(way, osmPrimitive);
            arrayList = new ArrayList<Node>();
            for (Node node : way.getNodes()) {
                arrayList.add((Node)hashMap.get(node));
            }
            ((Way)osmPrimitive).setNodes(arrayList);
            dataSet.addPrimitive(osmPrimitive);
        }
        for (Relation relation : this.relations) {
            osmPrimitive = new Relation(relation, relation.isNew());
            ((Relation)osmPrimitive).setMembers(null);
            hashMap.put(relation, osmPrimitive);
            dataSet.addPrimitive(osmPrimitive);
        }
        for (Relation relation : this.relations) {
            osmPrimitive = (Relation)hashMap.get(relation);
            arrayList = new ArrayList();
            for (RelationMember relationMember : relation.getMembers()) {
                arrayList.add((Node)((Object)new RelationMember(relationMember.getRole(), (OsmPrimitive)hashMap.get(relationMember.getMember()))));
            }
            ((Relation)osmPrimitive).setMembers(arrayList);
        }
        for (DataSource dataSource : this.dataSources) {
            dataSet.dataSources.add(new DataSource(dataSource.bounds, dataSource.origin));
        }
        dataSet.version = this.version;
        return dataSet;
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : this.dataSources) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public OsmPrimitive getPrimitiveById(long l, OsmPrimitiveType osmPrimitiveType) {
        return this.getPrimitiveById(new SimplePrimitiveId(l, osmPrimitiveType), false);
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return this.getPrimitiveById(primitiveId, false);
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId, boolean bl) {
        OsmPrimitive osmPrimitive = this.primitivesMap.get(primitiveId);
        if (osmPrimitive == null && bl) {
            switch (primitiveId.getType()) {
                case NODE: {
                    osmPrimitive = new Node(primitiveId.getUniqueId(), true);
                    break;
                }
                case WAY: {
                    osmPrimitive = new Way(primitiveId.getUniqueId(), true);
                    break;
                }
                case RELATION: {
                    osmPrimitive = new Relation(primitiveId.getUniqueId(), true);
                }
            }
            this.addPrimitive(osmPrimitive);
        }
        return osmPrimitive;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
        if (osmPrimitive == null) {
            System.out.println(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this  at http://josm.openstreetmap.de . This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId())}));
            new Exception().printStackTrace();
        }
        return osmPrimitive;
    }

    protected void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    public void unlinkNodeFromWays(Node node) {
        for (Way way : this.ways) {
            List<Node> list = way.getNodes();
            if (!list.remove(node)) continue;
            if (list.size() < 2) {
                this.deleteWay(way);
                continue;
            }
            way.setNodes(list);
        }
    }

    public void unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        for (Relation relation : this.relations) {
            List<RelationMember> list = relation.getMembers();
            Iterator<RelationMember> iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                RelationMember relationMember = iterator.next();
                if (!relationMember.getMember().equals(osmPrimitive)) continue;
                iterator.remove();
                bl = true;
            }
            if (!bl) continue;
            relation.setMembers(list);
        }
    }

    public void unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.unlinkNodeFromWays((Node)osmPrimitive);
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        } else {
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        }
    }

    public boolean isModified() {
        for (Node osmPrimitive : this.nodes) {
            if (!osmPrimitive.isModified()) continue;
            return true;
        }
        for (Way way : this.ways) {
            if (!way.isModified()) continue;
            return true;
        }
        for (Relation relation : this.relations) {
            if (!relation.isModified()) continue;
            return true;
        }
        return false;
    }

    private void reindexNode(Node node, LatLon latLon) {
        this.nodes.remove(node);
        node.setCoorInternal(latLon);
        this.nodes.add(node);
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (osmPrimitive instanceof Way) {
                this.reindexWay((Way)osmPrimitive);
                continue;
            }
            this.reindexRelation((Relation)osmPrimitive);
        }
    }

    private void reindexWay(Way way) {
        BBox bBox = way.getBBox();
        this.ways.remove(way);
        way.updatePosition();
        this.ways.add(way);
        if (!way.getBBox().equals(bBox)) {
            for (OsmPrimitive osmPrimitive : way.getReferrers()) {
                this.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    private void reindexRelation(Relation relation) {
        BBox bBox = relation.getBBox();
        relation.updatePosition();
        if (!bBox.equals(relation.getBBox())) {
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                this.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        this.listeners.add(dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.listeners.remove(dataSetListener);
    }

    public void beginUpdate() {
        ++this.updateCount;
    }

    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0) {
                this.fireDataChanged();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        if (this.updateCount == 0) {
            for (DataSetListener dataSetListener : this.listeners) {
                abstractDatasetChangedEvent.fire(dataSetListener);
            }
        }
    }

    private void fireDataChanged() {
        this.fireEvent(new DataChangedEvent(this));
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesAddedEvent(this, collection, bl));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesRemovedEvent(this, collection, bl));
    }

    void fireTagsChanged(OsmPrimitive osmPrimitive, Map<String, String> map) {
        this.fireEvent(new TagsChangedEvent(this, osmPrimitive, map));
    }

    void fireRelationMembersChanged(Relation relation) {
        this.reindexRelation(relation);
        this.fireEvent(new RelationMembersChangedEvent(this, relation));
    }

    void fireNodeMoved(Node node, LatLon latLon) {
        this.reindexNode(node, latLon);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive osmPrimitive, int n, int n2) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(osmPrimitive), n, n2));
    }

    void fireHighlightingChanged(OsmPrimitive osmPrimitive) {
        ++this.highlightUpdateCount;
    }

    public void clenupDeletedPrimitives() {
        if (this.cleanupDeleted(this.nodes.iterator()) | this.cleanupDeleted(this.ways.iterator()) | this.cleanupDeleted(this.relations.iterator())) {
            this.fireSelectionChanged();
        }
    }

    private boolean cleanupDeleted(Iterator<? extends OsmPrimitive> iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            OsmPrimitive osmPrimitive = iterator.next();
            if (!osmPrimitive.isDeleted()) continue;
            this.selectedPrimitives.remove(osmPrimitive);
            this.allPrimitives.remove(osmPrimitive);
            osmPrimitive.setDataset(null);
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    public void clear() {
        this.clearSelection();
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            osmPrimitive.setDataset(null);
        }
        this.nodes.clear();
        this.ways.clear();
        this.relations.clear();
        this.allPrimitives.clear();
    }

    public void addError(OsmPrimitive osmPrimitive, String string) {
        List<String> list = this.errors.get(osmPrimitive);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string);
        this.errors.put(osmPrimitive, list);
    }

    @Deprecated
    public List<String> getErrors(OsmPrimitive osmPrimitive) {
        List<String> list = this.errors.get(osmPrimitive);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdHash
    implements Hash<PrimitiveId, OsmPrimitive> {
        private IdHash() {
        }

        @Override
        public int getHashCode(PrimitiveId primitiveId) {
            return (int)primitiveId.getUniqueId() ^ primitiveId.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId primitiveId, OsmPrimitive osmPrimitive) {
            if (primitiveId == null || osmPrimitive == null) {
                return false;
            }
            return primitiveId.getUniqueId() == osmPrimitive.getUniqueId() && primitiveId.getType() == osmPrimitive.getType();
        }
    }
}

