/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oauth.signpost.OAuth;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.OAuthMessageSigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmacSha1MessageSigner
extends OAuthMessageSigner {
    private static final String MAC_NAME = "HmacSHA1";

    @Override
    public String sign(HttpRequest request, Map<String, String> oauthParameters) throws OAuthMessageSignerException {
        try {
            String keyString = OAuth.percentEncode(this.getConsumerSecret()) + '&' + OAuth.percentEncode(this.getTokenSecret());
            byte[] keyBytes = keyString.getBytes("UTF-8");
            SecretKeySpec key = new SecretKeySpec(keyBytes, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(key);
            String sbs = this.computeSignatureBaseString(request, oauthParameters);
            byte[] text = sbs.getBytes("UTF-8");
            return this.base64Encode(mac.doFinal(text)).trim();
        }
        catch (GeneralSecurityException e) {
            throw new OAuthMessageSignerException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthMessageSignerException(e);
        }
    }
}

