/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfUsedTags
implements DataSetListener {
    final TreeMap<String, TreeSet<String>> allData = new TreeMap();
    private boolean dirty;

    public Collection<String> getUsedKeys() {
        if (this.dirty) {
            this.rebuild();
        }
        return this.allData.keySet();
    }

    public Collection<String> getUsedValues(String string) {
        Collection collection;
        if (this.dirty) {
            this.rebuild();
        }
        if ((collection = (Collection)this.allData.get(string)) == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    public void rebuildNecessary() {
        this.dirty = true;
    }

    private void rebuild() {
        this.dirty = false;
        this.allData.clear();
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            this.addPrimitives(dataSet.allNonDeletedPrimitives());
        }
    }

    private void addPrimitives(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            this.addPrimitive(osmPrimitive);
        }
    }

    private void addPrimitive(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            this.addKey(string, osmPrimitive.get(string));
        }
    }

    private void addKey(String string, String string2) {
        TreeSet<String> treeSet = this.allData.get(string);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.allData.put(string, treeSet);
        }
        treeSet.add(string2);
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.rebuild();
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void primtivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        this.addPrimitives(primitivesAddedEvent.getPrimitives());
    }

    @Override
    public void primtivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.dirty = true;
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        Map<String, String> map = tagsChangedEvent.getPrimitive().getKeys();
        Map<String, String> map2 = tagsChangedEvent.getOriginalKeys();
        if (!map.keySet().containsAll(map2.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (entry.getValue().equals(map.get(entry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.addPrimitive(tagsChangedEvent.getPrimitive());
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }
}

