/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiPreconditionCheckerHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        OsmApi osmApi = OsmApi.getOsmApi();
        try {
            osmApi.initialize(NullProgressMonitor.INSTANCE);
            long l = 0L;
            if (osmApi.getCapabilities().isDefined("waynodes", "maximum")) {
                l = osmApi.getCapabilities().getLong("waynodes", "maximum");
            }
            if (l > 0L) {
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToAdd(), l)) {
                    return false;
                }
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToUpdate(), l)) {
                    return false;
                }
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToDelete(), l)) {
                    return false;
                }
            }
        }
        catch (OsmTransferCancelledException osmTransferCancelledException) {
            return false;
        }
        catch (OsmApiInitializationException osmApiInitializationException) {
            ExceptionDialogUtil.explainOsmTransferException(osmApiInitializationException);
            return false;
        }
        return true;
    }

    private boolean checkMaxNodes(Collection<OsmPrimitive> collection, long l) {
        for (OsmPrimitive osmPrimitive : collection) {
            for (String string : osmPrimitive.keySet()) {
                String string2 = osmPrimitive.get(string);
                if (string.length() <= 255) continue;
                if (osmPrimitive.isDeleted()) {
                    System.out.println(I18n.tr("Warning: automatically truncating value of tag ''{0}'' on deleted object {1}", string, Long.toString(osmPrimitive.getId())));
                    osmPrimitive.put(string, string2.substring(0, 255));
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Length of value for tag ''{0}'' on object {1} exceeds the max. allowed length {2}. Values length is {3}.", string, Long.toString(osmPrimitive.getId()), 255, string2.length()), I18n.tr("Precondition Violation"), 0);
                Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
                return false;
            }
            if (!(osmPrimitive instanceof Way) || (long)((Way)osmPrimitive).getNodesCount() <= l) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("{0} nodes in way {1} exceed the max. allowed number of nodes {2}", ((Way)osmPrimitive).getNodesCount(), Long.toString(osmPrimitive.getId()), l), I18n.tr("API Capabilities Violation"), 0);
            Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
            return false;
        }
        return true;
    }
}

