/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    private Cursor oldCursor;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private EastNorth lastTranslatedN1en;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = PaintColors.SELECTED.get();
    }

    private static Cursor getCursor(String string, String string2, int n) {
        try {
            return ImageProvider.getCursor(string, string2);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(n);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(cursor);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            Node node = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
            Node node2 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
            EastNorth eastNorth = node.getEastNorth();
            EastNorth eastNorth2 = node2.getEastNorth();
            EastNorth eastNorth3 = Main.map.mapView.getEastNorth(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            double d = ((eastNorth3.east() - eastNorth.east()) * (eastNorth2.east() - eastNorth.east()) + (eastNorth3.north() - eastNorth.north()) * (eastNorth2.north() - eastNorth.north())) / eastNorth2.distanceSq(eastNorth);
            EastNorth eastNorth4 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
            double d2 = Main.proj.eastNorth2latlon(eastNorth4).greatCircleDistance(Main.proj.eastNorth2latlon(eastNorth3));
            Main.map.statusLine.setDist(d2);
            this.updateStatusLine();
            double d3 = eastNorth3.east() - eastNorth4.east();
            double d4 = eastNorth3.north() - eastNorth4.north();
            this.newN1en = new EastNorth(eastNorth.getX() + d3, eastNorth.getY() + d4);
            this.newN2en = new EastNorth(eastNorth2.getX() + d3, eastNorth2.getY() + d4);
            Main.map.statusLine.setDist(Main.proj.eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.proj.eastNorth2latlon(this.newN1en)));
            this.updateStatusLine();
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (this.mode != Mode.extrude && this.mode == Mode.translate) {
                Command command;
                Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
                if (command instanceof SequenceCommand) {
                    command = ((SequenceCommand)command).getLastCommand();
                }
                Node node3 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
                Node node4 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
                EastNorth eastNorth5 = new EastNorth(this.newN1en.getX() - this.lastTranslatedN1en.getX(), this.newN1en.getY() - this.lastTranslatedN1en.getY());
                if (command instanceof MoveCommand && ((MoveCommand)command).getMovedNodes().contains(node3) && ((MoveCommand)command).getMovedNodes().contains(node4) && ((MoveCommand)command).getMovedNodes().size() == 2) {
                    ((MoveCommand)command).moveAgain(eastNorth5.getX(), eastNorth5.getY());
                    this.lastTranslatedN1en = this.newN1en;
                } else {
                    LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
                    linkedList.add(node3);
                    linkedList.add(node4);
                    command = new MoveCommand(linkedList, eastNorth5.getX(), eastNorth5.getY());
                    Main.main.undoRedo.add(command);
                    this.lastTranslatedN1en = this.newN1en;
                }
            }
            Main.map.mapView.repaint();
        }
    }

    private static Line2D createSemiInfiniteLine(Point2D point2D, Point2D point2D2, Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getDeviceConfiguration().getBounds();
        try {
            AffineTransform affineTransform = graphics2D.getTransform().createInverse();
            Point2D point2D3 = affineTransform.deltaTransform(new Point2D.Double(rectangle.width, 0.0), null);
            Point2D point2D4 = affineTransform.deltaTransform(new Point2D.Double(0.0, rectangle.height), null);
            double d = Math.abs(point2D3.getX()) + Math.abs(point2D3.getY()) + Math.abs(point2D4.getX()) + Math.abs(point2D4.getY());
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * d, point2D.getY() + point2D2.getY() * d));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Line2D.Double(point2D, new Point2D.Double(point2D.getX() + point2D2.getX() * 10.0, point2D.getY() + point2D2.getY() * 10.0));
        }
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mode != Mode.select && this.newN1en != null) {
            Graphics2D graphics2D2 = graphics2D;
            graphics2D2.setColor(this.selectedColor);
            graphics2D2.setStroke(new BasicStroke(3.0f, 1, 1));
            Point point = mapView.getPoint(this.initialN1en);
            Point point2 = mapView.getPoint(this.initialN2en);
            Point point3 = mapView.getPoint(this.newN1en);
            Point point4 = mapView.getPoint(this.newN2en);
            if (this.mode == Mode.extrude) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(point.x, point.y);
                generalPath.lineTo(point3.x, point3.y);
                generalPath.lineTo(point4.x, point4.y);
                generalPath.lineTo(point2.x, point2.y);
                generalPath.lineTo(point.x, point.y);
                graphics2D2.draw(generalPath);
                graphics2D2.setStroke(new BasicStroke(1.0f));
            } else if (this.mode == Mode.translate) {
                Line2D.Double double_ = new Line2D.Double(point3, point4);
                graphics2D2.draw(double_);
                graphics2D2.setStroke(new BasicStroke(1.0f));
                Line2D.Double double_2 = new Line2D.Double(point, point2);
                graphics2D2.draw(double_2);
                EastNorth eastNorth = new EastNorth(this.initialN2en.getX() - this.initialN1en.getX(), this.initialN2en.getY() - this.initialN1en.getY());
                double d = 1.0 / Math.hypot(eastNorth.getX(), eastNorth.getY());
                EastNorth eastNorth2 = new EastNorth(eastNorth.getY() * d, eastNorth.getX() * d);
                Point2D.Double double_3 = new Point2D.Double((point.getX() + point2.getX()) * 0.5, (point.getY() + point2.getY()) * 0.5);
                EastNorth eastNorth3 = this.newN1en == null || this.newN1en.getX() > this.initialN1en.getX() == eastNorth2.getX() > -0.0 ? eastNorth2 : new EastNorth(-eastNorth2.getX(), -eastNorth2.getY());
                Line2D line2D = ExtrudeAction.createSemiInfiniteLine(double_3, eastNorth3, graphics2D2);
                graphics2D2.draw(line2D);
                double d2 = 1.0 / graphics2D2.getTransform().getScaleX();
                double d3 = 8.0 * d2 * eastNorth3.getX();
                double d4 = 8.0 * d2 * eastNorth3.getY();
                Point2D.Double double_4 = new Point2D.Double(((Point2D)double_3).getX() + d3, ((Point2D)double_3).getY() + d4);
                Point2D.Double double_5 = new Point2D.Double(((Point2D)double_3).getX() - d4, ((Point2D)double_3).getY() + d3);
                Point2D.Double double_6 = new Point2D.Double(((Point2D)double_4).getX() - d4, ((Point2D)double_4).getY() + d3);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
                generalPath.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
                generalPath.lineTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
                graphics2D2.draw(generalPath);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment != null) {
            this.initialN1en = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex).getEastNorth();
            this.initialN2en = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1).getEastNorth();
            this.newN1en = null;
            this.newN2en = null;
            Main.map.mapView.addTemporaryLayer(this);
            this.updateStatusLine();
            Main.map.mapView.repaint();
            this.mouseDownTime = System.currentTimeMillis();
            this.initialMousePos = mouseEvent.getPoint();
            if ((mouseEvent.getModifiers() & 2) != 0) {
                this.mode = Mode.translate;
                this.lastTranslatedN1en = this.initialN1en;
            } else {
                this.mode = Mode.extrude;
                this.getCurrentDataSet().setSelected(this.selectedSegment.way);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.extrude) {
                if (mouseEvent.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    Node node = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
                    Node node2 = new Node(Main.proj.eastNorth2latlon(this.newN2en));
                    Node node3 = new Node(Main.proj.eastNorth2latlon(this.newN1en));
                    Way way = new Way(this.selectedSegment.way);
                    way.addNode(this.selectedSegment.lowerIndex + 1, node2);
                    way.addNode(this.selectedSegment.lowerIndex + 1, node3);
                    if (way.getNodesCount() == 4) {
                        way.addNode(node);
                    }
                    LinkedList<Command> linkedList = new LinkedList<Command>();
                    linkedList.add(new AddCommand(node3));
                    linkedList.add(new AddCommand(node2));
                    linkedList.add(new ChangeCommand(this.selectedSegment.way, way));
                    SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way"), linkedList);
                    Main.main.undoRedo.add(sequenceCommand);
                }
            } else if (this.mode == Mode.translate) {
                // empty if block
            }
            this.restoreCursor();
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.");
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal.");
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        extrude,
        translate,
        select;

    }
}

