/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmOAuthAuthorizationClient {
    private static final Logger logger = Logger.getLogger(OsmOAuthAuthorizationClient.class.getName());
    private OAuthParameters oauthProviderParameters;
    private OAuthConsumer consumer;
    private OAuthProvider provider;
    private boolean canceled;
    private HttpURLConnection connection;

    public OsmOAuthAuthorizationClient() {
        this.oauthProviderParameters = OAuthParameters.createDefault();
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters, OAuthToken oAuthToken) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(oAuthToken.getKey(), oAuthToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object;
        DefaultOAuthProvider defaultOAuthProvider = (DefaultOAuthProvider)this.provider;
        this.canceled = true;
        if (defaultOAuthProvider != null) {
            try {
                object = defaultOAuthProvider.getClass().getDeclaredField("connection");
                ((Field)object).setAccessible(true);
                HttpURLConnection httpURLConnection = (HttpURLConnection)((Field)object).get(defaultOAuthProvider);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
        }
        object = this;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCancelledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(null);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthCommunicationException oAuthCommunicationException) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(oAuthCommunicationException);
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCancelledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(null);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthCommunicationException oAuthCommunicationException) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(oAuthCommunicationException);
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken oAuthToken) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?").append("oauth_token").append("=").append(oAuthToken.getKey());
        return stringBuilder.toString();
    }

    protected String extractOsmSession(HttpURLConnection httpURLConnection) {
        List<String> list = httpURLConnection.getHeaderFields().get("Set-Cookie");
        if (list == null) {
            return null;
        }
        for (String string : list) {
            String[] stringArray = string.split(";");
            if (stringArray == null || stringArray.length == 0) continue;
            for (String string2 : stringArray) {
                String[] stringArray2 = (string2 = string2.trim()).split("=");
                if (stringArray2 == null || stringArray2.length != 2 || !stringArray2[0].equals("_osm_session")) continue;
                return stringArray2[1];
            }
        }
        return null;
    }

    protected String buildPostRequest(Map<String, String> map) throws OsmOAuthAuthorizationException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getValue();
                string = string == null ? "" : string;
                stringBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(string, "UTF-8"));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("&");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OsmOAuthAuthorizationException(unsupportedEncodingException);
        }
    }

    public String buildOsmLoginUrl() throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL uRL2 = new URL("http", uRL.getHost(), uRL.getPort(), "/login");
            return uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
    }

    protected String buildOsmLogoutUrl() throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL uRL2 = new URL("http", uRL.getHost(), uRL.getPort(), "/logout");
            return uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.buildOsmLoginUrl()).append("?cookie_test=true");
            URL uRL = new URL(stringBuilder.toString());
            Object object = this;
            synchronized (object) {
                this.connection = (HttpURLConnection)uRL.openConnection();
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            object = this.extractOsmSession(this.connection);
            if (object == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", uRL.toString()));
            }
            Object object2 = object;
            return object2;
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(String string, String string2, String string3) throws OsmLoginFailedException {
        FilterOutputStream filterOutputStream = null;
        try {
            URL uRL = new URL(this.buildOsmLoginUrl());
            Object object = this;
            synchronized (object) {
                this.connection = (HttpURLConnection)uRL.openConnection();
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            object = new HashMap();
            object.put("user[email]", string2);
            object.put("user[password]", string3);
            object.put("referer", "/");
            object.put("commit", "Login");
            String string4 = this.buildPostRequest((Map<String, String>)object);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(string4.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + string);
            this.connection.setInstanceFollowRedirects(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            filterOutputStream = new DataOutputStream(this.connection.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes(string4);
            ((DataOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            int n = this.connection.getResponseCode();
            if (n != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", string2));
            }
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            throw new OsmLoginFailedException(osmOAuthAuthorizationException.getCause());
        }
        catch (IOException iOException) {
            throw new OsmLoginFailedException(iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(String string) throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.buildOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)uRL.openConnection();
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(String string, OAuthToken oAuthToken, OsmPrivileges osmPrivileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("oauth_token", oAuthToken.getKey());
        hashMap.put("oauth_callback", "");
        if (osmPrivileges.isAllowWriteApi()) {
            hashMap.put("allow_write_api", "yes");
        }
        if (osmPrivileges.isAllowWriteGpx()) {
            hashMap.put("allow_write_gpx", "yes");
        }
        if (osmPrivileges.isAllowReadGpx()) {
            hashMap.put("allow_read_gpx", "yes");
        }
        if (osmPrivileges.isAllowWritePrefs()) {
            hashMap.put("allow_write_prefs", "yes");
        }
        if (osmPrivileges.isAllowReadPrefs()) {
            hashMap.put("allow_read_prefs", "yes");
        }
        hashMap.put("commit", "Save changes");
        String string2 = this.buildPostRequest(hashMap);
        FilterOutputStream filterOutputStream = null;
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)uRL.openConnection();
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(string2.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + string);
            this.connection.setInstanceFollowRedirects(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            filterOutputStream = new DataOutputStream(this.connection.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes(string2);
            ((DataOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            int n = this.connection.getResponseCode();
            if (n != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", oAuthToken.getKey()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmOAuthAuthorizationException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    protected void setHttpRequestParameters(HttpURLConnection httpURLConnection) {
        httpURLConnection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
        httpURLConnection.setRequestProperty("Host", httpURLConnection.getURL().getHost());
    }

    public void authorise(OAuthToken oAuthToken, String string, String string2, OsmPrivileges osmPrivileges, ProgressMonitor progressMonitor) throws IllegalArgumentException, OsmOAuthAuthorizationException, OsmTransferCancelledException {
        CheckParameterUtil.ensureParameterNotNull(oAuthToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(string, "osmUserName");
        CheckParameterUtil.ensureParameterNotNull(string2, "osmPassword");
        CheckParameterUtil.ensureParameterNotNull(osmPrivileges, "privileges");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", oAuthToken.getKey()));
            progressMonitor.setTicksCount(4);
            progressMonitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website..."));
            String string3 = this.fetchOsmWebsiteSessionId();
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", string));
            this.authenticateOsmSession(string3, string, string2);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", oAuthToken.getKey()));
            this.sendAuthorisationRequest(string3, oAuthToken, osmPrivileges);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", string3));
            this.logoutOsmSession(string3);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            progressMonitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw osmOAuthAuthorizationException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

