/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.command.PurgePrimitivesCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.SimplePaintVisitor;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private static int dataLayerCounter = 0;
    public final DataSet data;
    private ConflictCollection conflicts;
    @Deprecated
    public final LinkedList<DataChangeListener> listenerDataChanged = new LinkedList();
    private static TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean bl) {
        boolean bl2 = this.requiresSaveToFile;
        this.requiresSaveToFile = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, bl2, bl);
        }
    }

    protected void setRequiresUploadToServer(boolean bl) {
        boolean bl2 = this.requiresUploadToServer;
        this.requiresUploadToServer = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, bl2, bl);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public static void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("background"), Color.BLACK));
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 15, 15);
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW));
        graphics2D.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bufferedImage, rectangle);
    }

    public OsmDataLayer(DataSet dataSet, String string, File file) {
        super(string);
        this.data = dataSet;
        this.setAssociatedFile(file);
        this.conflicts = new ConflictCollection();
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        boolean bl;
        boolean bl2 = mapView.getActiveLayer() == this;
        boolean bl3 = !bl2 && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl4 = bl = !bl3 && mapView.isVirtualNodesEnabled();
        if (bl2 && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            object = mapView.getBounds();
            ((Rectangle)object).grow(100, 100);
            Area area = new Area((Shape)object);
            for (DataSource dataSource : this.data.dataSources) {
                if (dataSource.bounds == null || dataSource.bounds.getMin().equals(dataSource.bounds.getMax())) continue;
                EastNorth eastNorth = mapView.getProjection().latlon2eastNorth(dataSource.bounds.getMin());
                EastNorth eastNorth2 = mapView.getProjection().latlon2eastNorth(dataSource.bounds.getMax());
                Point point = mapView.getPoint(eastNorth);
                Point point2 = mapView.getPoint(eastNorth2);
                Rectangle rectangle = new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
                area.subtract(new Area(rectangle));
            }
            graphics2D.setPaint(hatched);
            graphics2D.fill(area);
        }
        object = Main.pref.getBoolean("draw.wireframe") ? new SimplePaintVisitor() : new MapPaintVisitor();
        object.setGraphics(graphics2D);
        object.setNavigatableComponent(mapView);
        object.setInactive(bl3);
        object.visitAll(this.data, bl, bounds);
        Main.map.conflictDialog.paintConflicts(graphics2D, mapView);
    }

    @Override
    public String getToolTipText() {
        File file;
        int n = this.undeletedSize(this.data.getNodes());
        int n2 = this.undeletedSize(this.data.getWays());
        String string = I18n.trn("{0} node", "{0} nodes", n, n) + ", ";
        string = string + I18n.trn("{0} way", "{0} ways", n2, n2);
        if (this.data.getVersion() != null) {
            string = string + ", " + I18n.tr("version {0}", this.data.getVersion());
        }
        if ((file = this.getAssociatedFile()) != null) {
            string = "<html>" + string + "<br>" + file.getPath() + "</html>";
        }
        return string;
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.mergeFrom(((OsmDataLayer)layer).data);
    }

    public void mergeFrom(DataSet dataSet) {
        DataSetMerger dataSetMerger = new DataSetMerger(this.data, dataSet);
        dataSetMerger.merge();
        Area area = this.data.getDataSourceArea();
        for (DataSource object2 : dataSet.dataSources) {
            if (area != null && area.contains(object2.bounds.asRect())) continue;
            this.data.dataSources.add(object2);
        }
        if (this.data.getVersion() == null) {
            this.data.setVersion(dataSet.getVersion());
        } else if ("0.5".equals(this.data.getVersion()) ^ "0.5".equals(dataSet.getVersion())) {
            System.err.println(I18n.tr("Warning: mixing 0.6 and 0.5 data results in version 0.5"));
            this.data.setVersion("0.5");
        }
        int n = 0;
        for (Conflict<?> conflict : dataSetMerger.getConflicts()) {
            if (this.conflicts.hasConflict(conflict)) continue;
            ++n;
            this.conflicts.add(conflict);
        }
        PurgePrimitivesCommand purgePrimitivesCommand = this.buildPurgeCommand();
        if (purgePrimitivesCommand != null) {
            Main.main.undoRedo.add(purgePrimitivesCommand);
        }
        this.fireDataChange();
        Main.map.mapView.repaint();
        this.warnNumNewConflicts(n, purgePrimitivesCommand == null ? 0 : purgePrimitivesCommand.getPurgedPrimitives().size());
    }

    protected void warnNumNewConflicts(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        String string = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", n, n);
        String string2 = I18n.trn("{0} conflict has been <strong>resolved automatically</strong> by purging {0} object<br>from the local dataset because it is deleted on the server.", "{0} conflicts have been <strong>resolved automatically</strong> by purging {0} objects<br> from the local dataset because they are deleted on the server.", n2, n2);
        int n3 = n - n2;
        String string3 = "";
        if (n3 > 0) {
            string3 = I18n.trn("{0} conflict remains to be resolved.<br><br>Please open the Conflict List Dialog and manually resolve it.", "{0} conflicts remain to be resolved.<br><br>Please open the Conflict List Dialog and manually resolve them.", n3, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>").append(string);
        if (n2 > 0) {
            stringBuffer.append("<br>").append(string2);
        }
        if (n3 > 0) {
            stringBuffer.append("<br>").append(string3);
        }
        stringBuffer.append("</html>");
        if (n > 0) {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK"), ImageProvider.get("ok"), I18n.tr("Click to close this dialog and continue editing"), null)};
            HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuffer.toString(), I18n.tr("Conflicts detected"), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
            Main.map.conflictDialog.unfurlDialog();
            Main.map.repaint();
        }
    }

    protected PurgePrimitivesCommand buildPurgeCommand() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        block0: for (Conflict<?> conflict : this.conflicts) {
            if (((OsmPrimitive)conflict.getMy()).isDeleted() && !((OsmPrimitive)conflict.getTheir()).isVisible()) {
                arrayList.add((OsmPrimitive)conflict.getMy());
                continue;
            }
            if (((OsmPrimitive)conflict.getMy()).isModified() || ((OsmPrimitive)conflict.getTheir()).isVisible()) continue;
            if (conflict.getMy() instanceof Way || conflict.getMy() instanceof Relation) {
                arrayList.add((OsmPrimitive)conflict.getMy());
                continue;
            }
            for (OsmPrimitive osmPrimitive : ((OsmPrimitive)conflict.getMy()).getReferrers()) {
                if (!osmPrimitive.isModified() || !(osmPrimitive instanceof Way)) continue;
                continue block0;
            }
            arrayList.add((OsmPrimitive)conflict.getMy());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        PurgePrimitivesCommand purgePrimitivesCommand = new PurgePrimitivesCommand(this, arrayList);
        return purgePrimitivesCommand;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Node node : this.data.getNodes()) {
            if (!node.isUsable()) continue;
            boundingXYVisitor.visit(node);
        }
    }

    public void cleanupAfterUpload(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        this.data.clenupDeletedPrimitives();
        Iterator<OsmPrimitive> iterator = this.data.getNodes().iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
        iterator = this.data.getWays().iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
        iterator = this.data.getRelations().iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
    }

    private void cleanIterator(Iterator<? extends OsmPrimitive> iterator, Collection<OsmPrimitive> collection) {
        OsmPrimitive osmPrimitive = iterator.next();
        if (!collection.remove(osmPrimitive)) {
            return;
        }
        osmPrimitive.setModified(false);
    }

    private int undeletedSize(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isDeleted() || !osmPrimitive.isVisible()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getInfoComponent() {
        void var3_6;
        DataCountVisitor dataCountVisitor = new DataCountVisitor();
        for (OsmPrimitive object2 : this.data.allPrimitives()) {
            object2.visit(dataCountVisitor);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = I18n.trn("{0} node", "{0} nodes", dataCountVisitor.nodes, dataCountVisitor.nodes);
        if (dataCountVisitor.deletedNodes > 0) {
            String string2 = string + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedNodes, dataCountVisitor.deletedNodes) + ")";
        }
        String string3 = I18n.trn("{0} way", "{0} ways", dataCountVisitor.ways, dataCountVisitor.ways);
        if (dataCountVisitor.deletedWays > 0) {
            string3 = string3 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedWays, dataCountVisitor.deletedWays) + ")";
        }
        String string4 = I18n.trn("{0} relation", "{0} relations", dataCountVisitor.relations, dataCountVisitor.relations);
        if (dataCountVisitor.deletedRelations > 0) {
            string4 = string4 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedRelations, dataCountVisitor.deletedRelations) + ")";
        }
        jPanel.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        jPanel.add((Component)new JLabel((String)var3_6, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string3, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string4, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add(new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset"))));
        return jPanel;
    }

    @Override
    public Component[] getMenuEntries() {
        if (Main.applet) {
            return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JMenuItem(new ConsistencyTestAction()), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JMenuItem(new Layer.LayerSaveAction(this)), new JMenuItem(new Layer.LayerSaveAsAction(this)), new JMenuItem(new Layer.LayerGpxExportAction(this)), new JMenuItem(new ConvertToGpxLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JMenuItem(new ConsistencyTestAction()), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    public void fireDataChange() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
        for (DataChangeListener dataChangeListener : this.listenerDataChanged) {
            dataChangeListener.dataChanged(this);
        }
    }

    public static GpxData toGpxData(DataSet dataSet, File file) {
        Object object;
        Object object2;
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way osmPrimitive : dataSet.getWays()) {
            if (!osmPrimitive.isUsable()) continue;
            object2 = new ArrayList();
            object = new HashMap<String, Object>();
            if (osmPrimitive.get("name") != null) {
                object.put("name", osmPrimitive.get("name"));
            }
            ArrayList<WayPoint> arrayList = null;
            for (Node node : osmPrimitive.getNodes()) {
                if (!node.isUsable()) {
                    arrayList = null;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<WayPoint>();
                    object2.add(arrayList);
                }
                if (!node.isTagged()) {
                    hashSet.add(node);
                }
                WayPoint wayPoint = new WayPoint(node.getCoor());
                if (!node.isTimestampEmpty()) {
                    wayPoint.attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                    wayPoint.setTime();
                }
                arrayList.add(wayPoint);
            }
            gpxData.tracks.add(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)object2, (Map<String, Object>)object));
        }
        for (Node node : dataSet.getNodes()) {
            if (node.isIncomplete() || node.isDeleted() || hashSet.contains(node)) continue;
            object2 = new WayPoint(node.getCoor());
            if (!node.isTimestampEmpty()) {
                ((WayPoint)object2).attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                ((WayPoint)object2).setTime();
            }
            if ((object = node.get("name")) == null) continue;
            ((WayPoint)object2).attr.put("name", object);
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon latLon) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (DataSource dataSource : this.data.dataSources) {
            if (!dataSource.bounds.contains(latLon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.data.isModified());
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        public ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No problems found"));
            } else {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)new JLabel(I18n.tr("Following problems found:")), GBC.eol());
                JTextArea jTextArea = new JTextArea(string, 20, 60);
                jTextArea.setCaretPosition(0);
                jTextArea.setEditable(false);
                jPanel.add((Component)new JScrollPane(jTextArea), GBC.eop());
                JOptionPane.showMessageDialog(Main.parent, jPanel, I18n.tr("Warning"), 2);
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer"), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;

        public void visit(Node node) {
            ++this.nodes;
            if (node.isDeleted()) {
                ++this.deletedNodes;
            }
        }

        public void visit(Way way) {
            ++this.ways;
            if (way.isDeleted()) {
                ++this.deletedWays;
            }
        }

        public void visit(Relation relation) {
            ++this.relations;
            if (relation.isDeleted()) {
                ++this.deletedRelations;
            }
        }
    }
}

