/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTableModel
extends AbstractTableModel
implements SelectionChangedListener,
MapView.LayerChangeListener {
    private OsmDataLayer layer;
    private ArrayList<OsmPrimitive> cache;

    public SelectionTableModel(OsmDataLayer osmDataLayer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
        this.cache = new ArrayList();
        MapView.addLayerChangeListener(this);
        this.populateSelectedPrimitives(osmDataLayer);
    }

    public void unregister() {
        DataSet.selListeners.remove(this);
        MapView.removeLayerChangeListener(this);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (Main.map.mapView.getEditLayer() != this.layer) {
            return 0;
        }
        return this.cache.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.cache.get(n);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer == this.layer) {
            this.cache.clear();
        }
        if (layer2 == this.layer) {
            this.cache.addAll(((OsmDataLayer)layer2).data.getSelected());
        }
        this.fireTableDataChanged();
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer == this.layer) {
            this.unregister();
        }
        this.cache.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.layer == Main.map.mapView.getEditLayer()) {
            this.cache.clear();
            this.cache.addAll(collection);
        } else {
            this.cache.clear();
        }
        this.fireTableDataChanged();
    }

    public List<OsmPrimitive> getSelection() {
        return this.cache;
    }

    protected void populateSelectedPrimitives(OsmDataLayer osmDataLayer) {
        this.selectionChanged(osmDataLayer.data.getSelected());
    }

    public OsmPrimitive getPrimitive(int n) {
        return this.cache.get(n);
    }
}

