/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame) {
        jFrame.setContentPane(contentPane);
        jFrame.setJMenuBar(this.menu);
        jFrame.setBounds(bounds);
        jFrame.setIconImage(ImageProvider.get("logo.png").getImage());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!Main.saveUnsavedModifications()) {
                    return;
                }
                Main.saveGuiGeometry();
                System.exit(0);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor") + "\n\n" + I18n.tr("usage") + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options") + ":\n" + "\t--help|-?|-h                              " + I18n.tr("Show this help") + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument") + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box") + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)") + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)") + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps") + "\n" + "\t--downloadgps=<url>                       " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z) as raw gps") + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search") + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode") + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default") + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language") + "\n\n" + I18n.tr("options provided as Java system properties") + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ") + I18n.tr("Change the folder for all user settings") + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes") + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples") + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.") + "\n" + I18n.tr("Make sure you load some data if you use --selection.") + "\n");
    }

    private static Map<String, Collection<String>> buildCommandLineArgumentMap(String[] stringArray) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (String string : stringArray) {
            int n;
            if ("-h".equals(string) || "-?".equals(string)) {
                string = "--help";
            }
            if (!string.startsWith("--")) {
                string = "--download=" + string;
            }
            String string2 = (n = string.indexOf(61)) == -1 ? string.substring(2) : string.substring(2, n);
            String string3 = n == -1 ? "" : string.substring(n + 1);
            LinkedList<String> linkedList = (LinkedList<String>)hashMap.get(string2);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            linkedList.add(string3);
            hashMap.put(string2, linkedList);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        I18n.init();
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        final Map<String, Collection<String>> map = MainApplication.buildCommandLineArgumentMap(stringArray);
        Main.pref.init(map.containsKey("reset-preferences"));
        if (map.containsKey("language")) {
            I18n.set((String)map.get("language").toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        DefaultAuthenticator.createInstance(CredentialsManagerFactory.getCredentialManager());
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        ProxySelector.setDefault(new DefaultProxySelector(ProxySelector.getDefault()));
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManagerFactory.getCredentialManager());
        if (map.containsKey("help")) {
            MainApplication.showHelp();
            System.exit(0);
        }
        SplashScreen splashScreen = new SplashScreen();
        ProgressMonitor progressMonitor = splashScreen.getProgressMonitor();
        progressMonitor.beginTask(I18n.tr("Initializing"));
        progressMonitor.setTicksCount(7);
        splashScreen.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        List<PluginInformation> list = PluginHandler.buildListOfPluginsToLoad(splashScreen, progressMonitor.createSubTaskMonitor(1, false));
        if (!list.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splashScreen)) {
            progressMonitor.subTask(I18n.tr("Updating plugins..."));
            PluginHandler.updatePlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        }
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Installing updated plugins"));
        PluginHandler.installDownloadedPlugins(true);
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Loading early plugins"));
        PluginHandler.loadEarlyPlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Setting defaults"));
        MainApplication.preConstructorInit(map);
        MainApplication.removeObsoletePreferences();
        progressMonitor.worked(1);
        progressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI"));
        JFrame jFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor"));
        Main.parent = jFrame;
        Main.addListener();
        final MainApplication mainApplication = new MainApplication(jFrame);
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Loading plugins"));
        PluginHandler.loadLatePlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.worked(1);
        toolbar.refreshToolbarControl();
        splashScreen.setVisible(false);
        splashScreen.dispose();
        jFrame.setVisible(true);
        boolean bl = Boolean.parseBoolean(Main.pref.get("gui.maximized"));
        if (!map.containsKey("no-maximize") && bl || map.containsKey("maximize")) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                jFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                mainApplication.postConstructorProcessCmdLine(map);
            }
        });
    }

    public static void removeObsoletePreferences() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"proxy.anonymous", "proxy.enable"}) {
            if (!Main.pref.hasKey(string)) continue;
            Main.pref.removeFromCollection(string, Main.pref.get(string));
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }
}

