/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsChangedEvent
extends AbstractDatasetChangedEvent {
    private final OsmPrimitive primitive;
    private final Map<String, String> originalKeys;

    public TagsChangedEvent(DataSet dataSet, OsmPrimitive osmPrimitive, Map<String, String> map) {
        super(dataSet);
        this.primitive = osmPrimitive;
        this.originalKeys = map;
    }

    @Override
    public void fire(DataSetListener dataSetListener) {
        dataSetListener.tagsChanged(this);
    }

    public OsmPrimitive getPrimitive() {
        return this.primitive;
    }

    @Override
    public List<? extends OsmPrimitive> getPrimitives() {
        return Collections.singletonList(this.primitive);
    }

    @Override
    public AbstractDatasetChangedEvent.DatasetEventType getType() {
        return AbstractDatasetChangedEvent.DatasetEventType.TAGS_CHANGED;
    }

    public Map<String, String> getOriginalKeys() {
        return this.originalKeys;
    }
}

