/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage<T>
extends AbstractSet<T> {
    private final Hash<? super T, ? super T> hash;
    private Object[] data;
    private int mask;
    private int size;
    private volatile transient int modCount = 0;
    private float loadFactor = 0.6f;

    public Storage() {
        this(Storage.defaultHash());
    }

    public Storage(int n) {
        this(Storage.defaultHash(), n);
    }

    public Storage(Hash<? super T, ? super T> hash) {
        this(hash, 16);
    }

    public Storage(Hash<? super T, ? super T> hash, int n) {
        this.hash = hash;
        int n2 = 1 << (int)Math.ceil(Math.log((float)n / this.loadFactor) / Math.log(2.0));
        this.data = new Object[n2];
        this.mask = this.data.length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public boolean contains(Object object) {
        int n = this.getBucket(this.hash, object);
        return n >= 0;
    }

    @Override
    public boolean add(T t) {
        T t2 = this.putUnique(t);
        return t2 != t;
    }

    @Override
    public boolean remove(Object object) {
        Object object2 = this.removeElem(object);
        return object2 != null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (T t : this) {
            n += this.hash.getHashCode(t);
        }
        return n;
    }

    public T put(T t) {
        ++this.modCount;
        this.ensureSpace();
        int n = this.getBucket(this.hash, t);
        if (n < 0) {
            ++this.size;
            assert (this.data[n ^= 0xFFFFFFFF] == null);
        }
        Object object = this.data[n];
        this.data[n] = t;
        return (T)object;
    }

    public T get(T t) {
        int n = this.getBucket(this.hash, t);
        return (T)(n < 0 ? null : this.data[n]);
    }

    public T putUnique(T t) {
        ++this.modCount;
        this.ensureSpace();
        int n = this.getBucket(this.hash, t);
        if (n < 0) {
            ++this.size;
            assert (this.data[~n] == null);
            this.data[n ^ 0xFFFFFFFF] = t;
            return t;
        }
        return (T)this.data[n];
    }

    public T removeElem(T t) {
        ++this.modCount;
        int n = this.getBucket(this.hash, t);
        return n < 0 ? null : (T)this.doRemove(n);
    }

    public <K> Map<K, T> foreignKey(Hash<K, ? super T> hash) {
        return new FMap(hash);
    }

    private int rehash(int n) {
        return 1103515245 * n >> 2;
    }

    private <K> int getBucket(Hash<K, ? super T> hash, K k) {
        Object object;
        int n = this.rehash(hash.getHashCode(k));
        int n2 = n & this.mask;
        while ((object = this.data[n2]) != null) {
            if (hash.equals(k, object)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return ~n2;
    }

    private T doRemove(int n) {
        Object object = this.data[n];
        assert (object != null);
        this.fillTheHole(n);
        --this.size;
        return (T)object;
    }

    private void fillTheHole(int n) {
        Object object;
        int n2 = n + 1 & this.mask;
        while ((object = this.data[n2]) != null) {
            int n3 = this.rehash(this.hash.getHashCode(object)) & this.mask;
            if (n2 < n3 && (n3 <= n || n <= n2) || n3 <= n && n <= n2) {
                this.data[n] = this.data[n2];
                n = n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        this.data[n] = null;
    }

    private void ensureSpace() {
        if ((float)this.size > (float)this.data.length * this.loadFactor) {
            Object[] objectArray = new Object[this.data.length * 2];
            int n = objectArray.length - 1;
            for (Object object : this.data) {
                if (object == null) continue;
                int n2 = this.rehash(this.hash.getHashCode(object)) & n;
                while (objectArray[n2] != null) {
                    n2 = n2 + 1 & n;
                }
                objectArray[n2] = object;
            }
            this.data = objectArray;
            this.mask = n;
        }
    }

    public static <O> Hash<O, O> defaultHash() {
        return new Hash<O, O>(){

            @Override
            public int getHashCode(O o) {
                return o.hashCode();
            }

            @Override
            public boolean equals(O o, O o2) {
                return o.equals(o2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Iter
    implements Iterator<T> {
        private final int mods;
        int slot = 0;
        int removeSlot = -1;

        Iter() {
            this.mods = Storage.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.align();
            return this.slot < Storage.this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeSlot = this.slot;
            return Storage.this.data[this.slot++];
        }

        @Override
        public void remove() {
            if (this.removeSlot == -1) {
                throw new IllegalStateException();
            }
            Storage.this.doRemove(this.removeSlot);
            this.slot = this.removeSlot;
            this.removeSlot = -1;
        }

        private void align() {
            if (this.mods != Storage.this.modCount) {
                throw new ConcurrentModificationException();
            }
            while (this.slot < Storage.this.data.length && Storage.this.data[this.slot] == null) {
                ++this.slot;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FMap<K>
    implements Map<K, T> {
        Hash<K, ? super T> fHash;

        private FMap(Hash<K, ? super T> hash) {
            this.fHash = hash;
        }

        @Override
        public int size() {
            return Storage.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Storage.this.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            int n = Storage.this.getBucket(this.fHash, object);
            return n >= 0;
        }

        @Override
        public boolean containsValue(Object object) {
            return Storage.this.contains(object);
        }

        @Override
        public T get(Object object) {
            int n = Storage.this.getBucket(this.fHash, object);
            return n < 0 ? null : Storage.this.data[n];
        }

        @Override
        public T put(K k, T t) {
            if (!this.fHash.equals(k, t)) {
                throw new IllegalArgumentException("inconsistent key");
            }
            return Storage.this.put(t);
        }

        @Override
        public T remove(Object object) {
            Storage.this.modCount++;
            int n = Storage.this.getBucket(this.fHash, object);
            return n < 0 ? null : Storage.this.doRemove(n);
        }

        @Override
        public void putAll(Map<? extends K, ? extends T> map) {
            if (map instanceof FMap) {
                Storage.this.addAll(((FMap)map).values());
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    this.put(entry.getKey(), (T)entry.getValue());
                }
            }
        }

        @Override
        public void clear() {
            Storage.this.clear();
        }

        @Override
        public Set<K> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<T> values() {
            return Storage.this;
        }

        @Override
        public Set<Map.Entry<K, T>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

