/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveData
implements Tagged,
PrimitiveId {
    private final Map<String, String> keys = new HashMap<String, String>();
    private boolean modified;
    private boolean visible = true;
    private boolean deleted;
    private boolean incomplete;
    private long id;
    private User user;
    private int version;
    private Date timestamp = new Date();
    private int changesetId;

    public PrimitiveData() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public PrimitiveData(PrimitiveData primitiveData) {
        this.keys.putAll(primitiveData.keys);
        this.modified = primitiveData.modified;
        this.visible = primitiveData.visible;
        this.deleted = primitiveData.deleted;
        this.id = primitiveData.id;
        this.user = primitiveData.user;
        this.version = primitiveData.version;
        this.timestamp = primitiveData.timestamp;
        this.incomplete = primitiveData.incomplete;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public long getId() {
        return this.id > 0L ? this.id : 0L;
    }

    public void setId(long l) {
        this.id = l;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public int getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(int n) {
        this.changesetId = n;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.keys;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean bl) {
        this.incomplete = bl;
    }

    public void clearOsmId() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public abstract PrimitiveData makeCopy();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append(this.keys);
        if (this.modified) {
            stringBuilder.append("M");
        }
        if (this.visible) {
            stringBuilder.append("V");
        }
        if (this.deleted) {
            stringBuilder.append("D");
        }
        if (this.incomplete) {
            stringBuilder.append("I");
        }
        return stringBuilder.toString();
    }

    @Override
    public String get(String string) {
        return this.keys.get(string);
    }

    @Override
    public boolean hasKeys() {
        return !this.keys.isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.keys.keySet();
    }

    @Override
    public void put(String string, String string2) {
        this.keys.put(string, string2);
    }

    @Override
    public void remove(String string) {
        this.keys.remove(string);
    }

    @Override
    public void removeAll() {
        this.keys.clear();
    }

    @Override
    public void setKeys(Map<String, String> map) {
        this.keys.clear();
        this.keys.putAll(map);
    }

    public static <T extends PrimitiveData> List<T> getFilteredList(Collection<T> collection, OsmPrimitiveType osmPrimitiveType) {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        for (PrimitiveData primitiveData : collection) {
            if (!osmPrimitiveType.getDataClass().isInstance(primitiveData)) continue;
            arrayList.add(primitiveData);
        }
        return arrayList;
    }

    protected void setKeysAsList(String ... stringArray) {
        assert (stringArray.length % 2 == 0);
        for (int i = 0; i < stringArray.length / 2; ++i) {
            this.keys.put(stringArray[i * 2], stringArray[i * 2 + 1]);
        }
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    @Override
    public abstract OsmPrimitiveType getType();
}

